/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import org.apache.ojb.broker.locking.LockIsolation;

class LockIsolationManager {
    private LockIsolation readUncommitedStrategy = new ReadUncommittedIsolation();
    private LockIsolation readCommitedStrategy = new ReadCommittedIsolation();
    private LockIsolation readRepeatableStrategy = new RepeatableReadIsolation();
    private LockIsolation serializableStrategy = new SerializableIsolation();

    LockIsolationManager() {
    }

    public LockIsolation getStrategyFor(int n) {
        switch (n) {
            case 2: {
                return this.readUncommitedStrategy;
            }
            case 3: {
                return this.readCommitedStrategy;
            }
            case 5: {
                return this.readRepeatableStrategy;
            }
            case 7: {
                return this.serializableStrategy;
            }
        }
        return this.readUncommitedStrategy;
    }

    class SerializableIsolation
    extends LockIsolation {
        SerializableIsolation() {
        }

        public int getIsolationLevel() {
            return 7;
        }

        public String getIsolationLevelAsString() {
            return "serializable";
        }

        public boolean allowMultipleRead() {
            return false;
        }

        public boolean allowWriteWhenRead() {
            return false;
        }

        public boolean allowReadWhenWrite() {
            return false;
        }
    }

    class RepeatableReadIsolation
    extends LockIsolation {
        public int getIsolationLevel() {
            return 5;
        }

        public String getIsolationLevelAsString() {
            return "repeatable-read";
        }

        public boolean allowMultipleRead() {
            return true;
        }

        public boolean allowWriteWhenRead() {
            return false;
        }

        public boolean allowReadWhenWrite() {
            return false;
        }
    }

    class ReadCommittedIsolation
    extends LockIsolation {
        ReadCommittedIsolation() {
        }

        public int getIsolationLevel() {
            return 3;
        }

        public String getIsolationLevelAsString() {
            return "read-committed";
        }

        public boolean allowMultipleRead() {
            return true;
        }

        public boolean allowWriteWhenRead() {
            return true;
        }

        public boolean allowReadWhenWrite() {
            return false;
        }
    }

    class ReadUncommittedIsolation
    extends LockIsolation {
        ReadUncommittedIsolation() {
        }

        public int getIsolationLevel() {
            return 2;
        }

        public String getIsolationLevelAsString() {
            return "read-uncommitted";
        }

        public boolean allowMultipleRead() {
            return true;
        }

        public boolean allowWriteWhenRead() {
            return true;
        }

        public boolean allowReadWhenWrite() {
            return true;
        }
    }
}

