/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PBLifeCycleEvent;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.accesslayer.PagingIterator;
import org.apache.ojb.broker.accesslayer.PlainPrefetcher;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.MaterializationListener;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class QueryReferenceBroker {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$QueryReferenceBroker == null ? (class$org$apache$ojb$broker$core$QueryReferenceBroker = QueryReferenceBroker.class$("org.apache.ojb.broker.core.QueryReferenceBroker")) : class$org$apache$ojb$broker$core$QueryReferenceBroker);
    private PersistenceBrokerImpl pb;
    private HashMap m_retrievalTasks;
    private ArrayList prefetchingListeners;
    private final boolean batchRetrieval = true;
    private final boolean prefetchProxies = true;
    private Class classToPrefetch;
    private PBLifeCycleEvent afterLookupEvent;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$QueryReferenceBroker;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareCollection;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$ManageableArrayList;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareList;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareSet;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$ManageableHashSet;
    static /* synthetic */ Class class$org$apache$ojb$broker$ManageableCollection;

    public QueryReferenceBroker(PersistenceBrokerImpl persistenceBrokerImpl) {
        this.pb = persistenceBrokerImpl;
        this.afterLookupEvent = new PBLifeCycleEvent(persistenceBrokerImpl, PBLifeCycleEvent.Type.AFTER_LOOKUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManageableCollection getCollectionByQuery(Class clazz, Class clazz2, Query query) throws ClassNotPersistenceCapableException, PersistenceBrokerException {
        boolean bl;
        if (this.log.isDebugEnabled()) {
            this.log.debug("getCollectionByQuery (" + clazz + ", " + clazz2 + ", " + query + ")");
        }
        ClassDescriptor classDescriptor = this.pb.getClassDescriptor(clazz2);
        ManageableCollection manageableCollection = null;
        OJBIterator oJBIterator = null;
        int n = -1;
        int n2 = 0;
        boolean bl2 = bl = this.m_retrievalTasks == null;
        if (bl) {
            this.m_retrievalTasks = new HashMap();
        }
        this.pb.getInternalCache().enableMaterializationCache();
        try {
            try {
                IndirectionHandler indirectionHandler;
                Object object;
                manageableCollection = (ManageableCollection)clazz.newInstance();
                oJBIterator = this.pb.getIteratorFromQuery(query, classDescriptor);
                oJBIterator.disableLifeCycleEvents();
                if (oJBIterator instanceof PagingIterator) {
                    n = oJBIterator.fullSize();
                }
                while (oJBIterator.hasNext()) {
                    object = oJBIterator.next();
                    if (object == null) continue;
                    indirectionHandler = ProxyHelper.getIndirectionHandler(object);
                    if (indirectionHandler != null || clazz2.isAssignableFrom(object.getClass())) {
                        manageableCollection.ojbAdd(object);
                        ++n2;
                    } else {
                        this.log.warn("Candidate object [" + object + "] class [" + object.getClass().getName() + "] is not a subtype of [" + clazz2.getName() + "] or any type of proxy. NOT INCLUDED in result collection");
                    }
                    if (indirectionHandler == null || classDescriptor.getProxyPrefetchingLimit() <= 0 || !this.addRetrievalTask(object, this)) continue;
                    new PBMaterializationListener(object, this.m_retrievalTasks, this, classDescriptor.getProxyPrefetchingLimit());
                }
                if (bl) {
                    object = this.classToPrefetch;
                    this.classToPrefetch = null;
                    try {
                        this.performRetrievalTasks();
                    }
                    finally {
                        this.classToPrefetch = object;
                    }
                }
                object = manageableCollection.ojbIterator();
                while (object.hasNext()) {
                    indirectionHandler = object.next();
                    this.afterLookupEvent.setTarget(indirectionHandler);
                    this.pb.fireBrokerEvent(this.afterLookupEvent);
                    this.afterLookupEvent.setTarget(null);
                }
                this.pb.getInternalCache().disableMaterializationCache();
            }
            catch (RuntimeException runtimeException) {
                this.pb.getInternalCache().doLocalClear();
                throw runtimeException;
            }
            catch (Exception exception) {
                this.pb.getInternalCache().doLocalClear();
                this.log.error(exception);
                throw new PersistenceBrokerException(exception);
            }
            Object var14_15 = null;
            if (oJBIterator != null) {
                oJBIterator.releaseDbResources();
            }
            if (bl) {
                this.m_retrievalTasks = null;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (oJBIterator != null) {
                oJBIterator.releaseDbResources();
            }
            if (bl) {
                this.m_retrievalTasks = null;
            }
            throw throwable;
        }
        if (n < 0) {
            n = n2;
        }
        query.fullSize(n);
        return manageableCollection;
    }

    public ManageableCollection getCollectionByQuery(Class clazz, Query query, boolean bl) throws PersistenceBrokerException {
        try {
            ManageableCollection manageableCollection = query == null ? (ManageableCollection)clazz.newInstance() : (bl ? this.pb.getProxyFactory().createCollectionProxy(this.pb.getPBKey(), query, clazz) : this.getCollectionByQuery(clazz, query.getSearchClass(), query));
            return manageableCollection;
        }
        catch (Exception exception) {
            if (exception instanceof PersistenceBrokerException) {
                throw (PersistenceBrokerException)((Object)exception);
            }
            throw new PersistenceBrokerException(exception);
        }
    }

    public Collection getCollectionByQuery(Query query, boolean bl) throws PersistenceBrokerException {
        return (Collection)((Object)this.getCollectionByQuery(class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection, query, bl));
    }

    private Class getCollectionTypeClass(CollectionDescriptor collectionDescriptor) throws PersistenceBrokerException {
        Class clazz;
        Class clazz2 = collectionDescriptor.getPersistentField().getType();
        if (clazz2.isArray() || clazz2.isAssignableFrom(class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection)) {
            Class clazz3 = collectionDescriptor.isMtoNRelation() ? (class$org$apache$ojb$broker$util$collections$ManageableArrayList == null ? (class$org$apache$ojb$broker$util$collections$ManageableArrayList = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.ManageableArrayList")) : class$org$apache$ojb$broker$util$collections$ManageableArrayList) : (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection);
            clazz = clazz3;
        } else if (clazz2.isAssignableFrom(class$org$apache$ojb$broker$util$collections$RemovalAwareList == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareList = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareList")) : class$org$apache$ojb$broker$util$collections$RemovalAwareList)) {
            Class clazz4 = collectionDescriptor.isMtoNRelation() ? (class$org$apache$ojb$broker$util$collections$ManageableArrayList == null ? (class$org$apache$ojb$broker$util$collections$ManageableArrayList = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.ManageableArrayList")) : class$org$apache$ojb$broker$util$collections$ManageableArrayList) : (class$org$apache$ojb$broker$util$collections$RemovalAwareList == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareList = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareList")) : class$org$apache$ojb$broker$util$collections$RemovalAwareList);
            clazz = clazz4;
        } else if (clazz2.isAssignableFrom(class$org$apache$ojb$broker$util$collections$RemovalAwareSet == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareSet = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareSet")) : class$org$apache$ojb$broker$util$collections$RemovalAwareSet)) {
            Class clazz5 = collectionDescriptor.isMtoNRelation() ? (class$org$apache$ojb$broker$util$collections$ManageableHashSet == null ? (class$org$apache$ojb$broker$util$collections$ManageableHashSet = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.ManageableHashSet")) : class$org$apache$ojb$broker$util$collections$ManageableHashSet) : (class$org$apache$ojb$broker$util$collections$RemovalAwareSet == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareSet = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareSet")) : class$org$apache$ojb$broker$util$collections$RemovalAwareSet);
            clazz = clazz5;
        } else if ((class$org$apache$ojb$broker$ManageableCollection == null ? (class$org$apache$ojb$broker$ManageableCollection = QueryReferenceBroker.class$("org.apache.ojb.broker.ManageableCollection")) : class$org$apache$ojb$broker$ManageableCollection).isAssignableFrom(clazz2)) {
            clazz = clazz2;
        } else {
            throw new MetadataException("Cannot determine a default collection type for collection " + collectionDescriptor.getAttributeName() + " in type " + collectionDescriptor.getClassDescriptor().getClassNameOfObject());
        }
        return clazz;
    }

    private boolean addRetrievalTask(Object object, Object object2) {
        ArrayList<Object> arrayList = (ArrayList<Object>)this.m_retrievalTasks.get(object2);
        boolean bl = false;
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            this.m_retrievalTasks.put(object2, arrayList);
            bl = true;
        }
        arrayList.add(object);
        return bl;
    }

    public void performRetrievalTasks() {
        if (this.m_retrievalTasks == null) {
            return;
        }
        while (this.m_retrievalTasks.size() > 0) {
            HashMap hashMap = this.m_retrievalTasks;
            this.m_retrievalTasks = new HashMap();
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (!(k instanceof ObjectReferenceDescriptor)) continue;
                ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)k;
                ArrayList arrayList = (ArrayList)entry.getValue();
                if (objectReferenceDescriptor.isLazy() || objectReferenceDescriptor.getItemProxyClass() != null) continue;
                RelationshipPrefetcher relationshipPrefetcher = this.pb.getRelationshipPrefetcherFactory().createRelationshipPrefetcher(objectReferenceDescriptor);
                relationshipPrefetcher.prefetchRelationship(arrayList);
                iterator.remove();
            }
        }
    }

    public void retrieveReference(Object object, ClassDescriptor classDescriptor, ObjectReferenceDescriptor objectReferenceDescriptor, boolean bl) {
        Object object2 = null;
        if (bl || objectReferenceDescriptor.getCascadeRetrieve()) {
            this.pb.getInternalCache().enableMaterializationCache();
            try {
                Serializable serializable;
                Identity identity = this.getReferencedObjectIdentity(object, objectReferenceDescriptor, classDescriptor);
                boolean bl2 = true;
                if (identity == null) {
                    object2 = null;
                } else if (this.pb.serviceObjectCache().lookup(identity) != null) {
                    object2 = this.pb.doGetObjectByIdentity(identity);
                    if (objectReferenceDescriptor.isSuperReferenceDescriptor()) {
                        serializable = classDescriptor.getRepository().getDescriptorFor(objectReferenceDescriptor.getItemClass());
                        this.retrieveReferences(object2, (ClassDescriptor)serializable, false);
                        this.retrieveCollections(object2, (ClassDescriptor)serializable, false);
                    }
                } else if (this.m_retrievalTasks != null && !objectReferenceDescriptor.isLazy() && objectReferenceDescriptor.getItemProxyClass() == null) {
                    this.addRetrievalTask(object, objectReferenceDescriptor);
                    bl2 = false;
                } else {
                    object2 = this.getReferencedObject(identity, objectReferenceDescriptor);
                }
                if (bl2) {
                    PersistentField persistentField = objectReferenceDescriptor.getPersistentField();
                    persistentField.set(object, object2);
                    if (object2 != null && this.m_retrievalTasks != null && objectReferenceDescriptor.getProxyPrefetchingLimit() > 0 && (serializable = ProxyHelper.getIndirectionHandler(object2)) != null && this.addRetrievalTask(object, objectReferenceDescriptor)) {
                        new PBMaterializationListener(object, this.m_retrievalTasks, objectReferenceDescriptor, objectReferenceDescriptor.getProxyPrefetchingLimit());
                    }
                }
                this.pb.getInternalCache().disableMaterializationCache();
            }
            catch (RuntimeException runtimeException) {
                this.pb.getInternalCache().doLocalClear();
                throw runtimeException;
            }
        }
    }

    public void retrieveProxyReference(Object object, ClassDescriptor classDescriptor, ObjectReferenceDescriptor objectReferenceDescriptor, boolean bl) {
        Object object2 = null;
        this.pb.getInternalCache().enableMaterializationCache();
        try {
            IndirectionHandler indirectionHandler;
            Identity identity = this.getReferencedObjectIdentity(object, objectReferenceDescriptor, classDescriptor);
            if (identity != null) {
                object2 = this.pb.createProxy(objectReferenceDescriptor.getItemClass(), identity);
            }
            PersistentField persistentField = objectReferenceDescriptor.getPersistentField();
            persistentField.set(object, object2);
            if (object2 != null && this.m_retrievalTasks != null && objectReferenceDescriptor.getProxyPrefetchingLimit() > 0 && (indirectionHandler = ProxyHelper.getIndirectionHandler(object2)) != null && this.addRetrievalTask(object, objectReferenceDescriptor)) {
                new PBMaterializationListener(object, this.m_retrievalTasks, objectReferenceDescriptor, objectReferenceDescriptor.getProxyPrefetchingLimit());
            }
            this.pb.getInternalCache().disableMaterializationCache();
        }
        catch (RuntimeException runtimeException) {
            this.pb.getInternalCache().doLocalClear();
            throw runtimeException;
        }
    }

    public void retrieveReferences(Object object, ClassDescriptor classDescriptor, boolean bl) throws PersistenceBrokerException {
        Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        Class clazz = this.classToPrefetch;
        this.classToPrefetch = null;
        this.pb.getInternalCache().enableMaterializationCache();
        try {
            while (iterator.hasNext()) {
                ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
                this.retrieveReference(object, classDescriptor, objectReferenceDescriptor, bl);
            }
            this.pb.getInternalCache().disableMaterializationCache();
        }
        catch (RuntimeException runtimeException) {
            this.pb.getInternalCache().doLocalClear();
            throw runtimeException;
        }
        finally {
            this.classToPrefetch = clazz;
        }
    }

    public void retrieveProxyReferences(Object object, ClassDescriptor classDescriptor, boolean bl) throws PersistenceBrokerException {
        Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        Class clazz = this.classToPrefetch;
        this.classToPrefetch = null;
        this.pb.getInternalCache().enableMaterializationCache();
        try {
            while (iterator.hasNext()) {
                ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
                this.retrieveProxyReference(object, classDescriptor, objectReferenceDescriptor, bl);
            }
            this.pb.getInternalCache().disableMaterializationCache();
        }
        catch (RuntimeException runtimeException) {
            this.pb.getInternalCache().doLocalClear();
            throw runtimeException;
        }
        finally {
            this.classToPrefetch = clazz;
        }
    }

    private Identity getReferencedObjectIdentity(Object object, ObjectReferenceDescriptor objectReferenceDescriptor, ClassDescriptor classDescriptor) {
        Object[] objectArray = objectReferenceDescriptor.getForeignKeyValues(object, classDescriptor);
        FieldDescriptor[] fieldDescriptorArray = objectReferenceDescriptor.getForeignKeyFieldDescriptors(classDescriptor);
        boolean bl = this.hasNullifiedFK(fieldDescriptorArray, objectArray);
        if (bl) {
            Object object2;
            if (BrokerHelper.hasAnonymousKeyReference(classDescriptor, objectReferenceDescriptor) && (object2 = objectReferenceDescriptor.getPersistentField().get(object)) != null) {
                return this.pb.serviceIdentity().buildIdentity(object2);
            }
        } else {
            return this.pb.serviceIdentity().buildIdentity(objectReferenceDescriptor.getItemClass(), this.pb.getTopLevelClass(objectReferenceDescriptor.getItemClass()), objectArray);
        }
        return null;
    }

    private boolean hasNullifiedFK(FieldDescriptor[] fieldDescriptorArray, Object[] objectArray) {
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.pb.serviceBrokerHelper().representsNull(fieldDescriptorArray[i], objectArray[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private Object getReferencedObject(Identity identity, ObjectReferenceDescriptor objectReferenceDescriptor) {
        Class clazz = objectReferenceDescriptor.isLazy() ? objectReferenceDescriptor.getItemClass() : objectReferenceDescriptor.getItemProxyClass();
        if (clazz != null) {
            try {
                return this.pb.createProxy(clazz, identity);
            }
            catch (Exception exception) {
                this.log.error("Error while instantiate object " + identity + ", msg: " + exception.getMessage(), exception);
                if (exception instanceof PersistenceBrokerException) {
                    throw (PersistenceBrokerException)((Object)exception);
                }
                throw new PersistenceBrokerException(exception);
            }
        }
        return this.pb.doGetObjectByIdentity(identity);
    }

    public void retrieveCollection(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor, boolean bl) {
        this.doRetrieveCollection(object, classDescriptor, collectionDescriptor, bl, collectionDescriptor.isLazy());
    }

    public void retrieveProxyCollection(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor, boolean bl) {
        this.doRetrieveCollection(object, classDescriptor, collectionDescriptor, bl, true);
    }

    private void doRetrieveCollection(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor, boolean bl, boolean bl2) {
        if (bl || collectionDescriptor.getCascadeRetrieve()) {
            if (this.m_retrievalTasks != null && !collectionDescriptor.isLazy() && !collectionDescriptor.hasProxyItems() && collectionDescriptor.getQueryCustomizer() == null) {
                this.addRetrievalTask(object, collectionDescriptor);
            } else {
                Class clazz = collectionDescriptor.getCollectionClass();
                PersistentField persistentField = collectionDescriptor.getPersistentField();
                Query query = this.getFKQuery(object, classDescriptor, collectionDescriptor);
                this.pb.getInternalCache().enableMaterializationCache();
                try {
                    Object object2;
                    if (clazz == null) {
                        Collection collection = (Collection)((Object)this.getCollectionByQuery(this.getCollectionTypeClass(collectionDescriptor), query, bl2));
                        if (persistentField.getType().isArray()) {
                            int n = collection.size();
                            Class<?> clazz2 = persistentField.getType().getComponentType();
                            Object object3 = Array.newInstance(clazz2, n);
                            int n2 = 0;
                            Iterator iterator = collection.iterator();
                            while (iterator.hasNext()) {
                                Array.set(object3, n2, iterator.next());
                                ++n2;
                            }
                            persistentField.set(object, object3);
                        } else {
                            persistentField.set(object, collection);
                        }
                        object2 = collection;
                    } else {
                        ManageableCollection manageableCollection = this.getCollectionByQuery(clazz, query, bl2);
                        persistentField.set(object, manageableCollection);
                        object2 = manageableCollection;
                    }
                    if (this.m_retrievalTasks != null && collectionDescriptor.getProxyPrefetchingLimit() > 0 && collectionDescriptor.getQueryCustomizer() == null && ProxyHelper.isCollectionProxy(object2) && this.addRetrievalTask(object, collectionDescriptor)) {
                        new PBCollectionProxyListener(object, this.m_retrievalTasks, collectionDescriptor, collectionDescriptor.getProxyPrefetchingLimit());
                    }
                    this.pb.getInternalCache().disableMaterializationCache();
                }
                catch (RuntimeException runtimeException) {
                    this.pb.getInternalCache().doLocalClear();
                    throw runtimeException;
                }
            }
        }
    }

    private Query getFKQuery(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor) {
        QueryByCriteria queryByCriteria = collectionDescriptor.isMtoNRelation() ? this.getFKQueryMtoN(object, classDescriptor, collectionDescriptor) : this.getFKQuery1toN(object, classDescriptor, collectionDescriptor);
        if (!collectionDescriptor.getOrderBy().isEmpty()) {
            Iterator iterator = collectionDescriptor.getOrderBy().iterator();
            while (iterator.hasNext()) {
                queryByCriteria.addOrderBy((FieldHelper)iterator.next());
            }
        }
        Query query = collectionDescriptor.getQueryCustomizer() != null ? collectionDescriptor.getQueryCustomizer().customizeQuery(object, this.pb, collectionDescriptor, queryByCriteria) : queryByCriteria;
        return query;
    }

    private QueryByCriteria getFKQueryMtoN(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor) {
        int n;
        ValueContainer[] valueContainerArray = this.pb.serviceBrokerHelper().getKeyValues(classDescriptor, object);
        String[] stringArray = collectionDescriptor.getFksToThisClass();
        String[] stringArray2 = collectionDescriptor.getFksToItemClass();
        ClassDescriptor classDescriptor2 = this.pb.getClassDescriptor(collectionDescriptor.getItemClass());
        Criteria criteria = new Criteria();
        for (n = 0; n < stringArray.length; ++n) {
            criteria.addEqualTo(collectionDescriptor.getIndirectionTable() + "." + stringArray[n], valueContainerArray[n].getValue());
        }
        for (n = 0; n < stringArray2.length; ++n) {
            criteria.addEqualToField(collectionDescriptor.getIndirectionTable() + "." + stringArray2[n], classDescriptor2.getPkFields()[n].getAttributeName());
        }
        return QueryFactory.newQuery(classDescriptor2.getClassOfObject(), collectionDescriptor.getIndirectionTable(), criteria);
    }

    private QueryByCriteria getFKQuery1toN(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor) {
        ValueContainer[] valueContainerArray = this.pb.serviceBrokerHelper().getKeyValues(classDescriptor, object);
        ClassDescriptor classDescriptor2 = this.pb.getClassDescriptor(collectionDescriptor.getItemClass());
        FieldDescriptor[] fieldDescriptorArray = collectionDescriptor.getForeignKeyFieldDescriptors(classDescriptor2);
        Criteria criteria = new Criteria();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            criteria.addEqualTo(fieldDescriptor.getAttributeName(), valueContainerArray[i].getValue());
        }
        return QueryFactory.newQuery(classDescriptor2.getClassOfObject(), criteria);
    }

    public Query getPKQuery(Identity identity) {
        Object[] objectArray = identity.getPrimaryKeyValues();
        ClassDescriptor classDescriptor = this.pb.getClassDescriptor(identity.getObjectsTopLevelClass());
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        Criteria criteria = new Criteria();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            criteria.addEqualTo(fieldDescriptor.getAttributeName(), objectArray[i]);
        }
        return QueryFactory.newQuery(classDescriptor.getClassOfObject(), criteria);
    }

    public void retrieveCollections(Object object, ClassDescriptor classDescriptor, boolean bl) throws PersistenceBrokerException {
        this.doRetrieveCollections(object, classDescriptor, bl, false);
    }

    public void retrieveProxyCollections(Object object, ClassDescriptor classDescriptor, boolean bl) throws PersistenceBrokerException {
        this.doRetrieveCollections(object, classDescriptor, bl, true);
    }

    private void doRetrieveCollections(Object object, ClassDescriptor classDescriptor, boolean bl, boolean bl2) throws PersistenceBrokerException {
        Iterator iterator = classDescriptor.getCollectionDescriptors().iterator();
        Class clazz = this.classToPrefetch;
        this.classToPrefetch = null;
        this.pb.getInternalCache().enableMaterializationCache();
        try {
            while (iterator.hasNext()) {
                CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator.next();
                if (bl2) {
                    this.retrieveProxyCollection(object, classDescriptor, collectionDescriptor, bl);
                    continue;
                }
                this.retrieveCollection(object, classDescriptor, collectionDescriptor, bl);
            }
            this.pb.getInternalCache().disableMaterializationCache();
        }
        catch (RuntimeException runtimeException) {
            this.pb.getInternalCache().doLocalClear();
            throw runtimeException;
        }
        finally {
            this.classToPrefetch = clazz;
        }
    }

    public void removePrefetchingListeners() {
        if (this.prefetchingListeners != null) {
            Iterator iterator = this.prefetchingListeners.iterator();
            while (iterator.hasNext()) {
                PBPrefetchingListener pBPrefetchingListener = (PBPrefetchingListener)iterator.next();
                pBPrefetchingListener.removeThisListener();
            }
            this.prefetchingListeners.clear();
        }
    }

    public Class getClassToPrefetch() {
        return this.classToPrefetch;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PBCollectionProxyListener
    extends PBPrefetchingListener
    implements CollectionProxyListener {
        CollectionProxyDefaultImpl _listenedCollection;

        PBCollectionProxyListener(Object object, HashMap hashMap, CollectionDescriptor collectionDescriptor, int n) {
            super(object, hashMap, collectionDescriptor, n);
        }

        protected void addThisListenerTo(Object object) {
            PersistentField persistentField = ((CollectionDescriptor)this._key).getPersistentField();
            this._listenedCollection = (CollectionProxyDefaultImpl)persistentField.get(object);
            this._listenedCollection.addListener(this);
        }

        protected void removeThisListener() {
            if (this._listenedCollection != null) {
                this._listenedCollection.removeListener(this);
                this._listenedCollection = null;
            }
        }

        protected RelationshipPrefetcher getPrefetcher(Object object) {
            return QueryReferenceBroker.this.pb.getRelationshipPrefetcherFactory().createRelationshipPrefetcher((CollectionDescriptor)this._key);
        }

        public void beforeLoading(CollectionProxyDefaultImpl collectionProxyDefaultImpl) {
            this.prefetch(collectionProxyDefaultImpl);
        }

        public void afterLoading(CollectionProxyDefaultImpl collectionProxyDefaultImpl) {
        }
    }

    abstract class PBPrefetchingListener {
        private HashMap _retrievalTasks;
        private int _limit;
        protected Object _key;

        PBPrefetchingListener(Object object, HashMap hashMap, Object object2, int n) {
            this._retrievalTasks = hashMap;
            this._key = object2;
            this._limit = n + 1;
            if (QueryReferenceBroker.this.prefetchingListeners == null) {
                QueryReferenceBroker.this.prefetchingListeners = new ArrayList();
            }
            this.addThisListenerTo(object);
            QueryReferenceBroker.this.prefetchingListeners.add(this);
        }

        protected abstract void addThisListenerTo(Object var1);

        protected abstract void removeThisListener();

        protected abstract RelationshipPrefetcher getPrefetcher(Object var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void prefetch(Object object) {
            boolean bl;
            List list;
            ArrayList arrayList = (ArrayList)this._retrievalTasks.get(this._key);
            this.removeThisListener();
            if (arrayList == null) {
                return;
            }
            RelationshipPrefetcher relationshipPrefetcher = this.getPrefetcher(object);
            if (arrayList.size() <= this._limit) {
                list = arrayList;
                bl = true;
            } else {
                list = arrayList.subList(0, this._limit);
                bl = false;
            }
            Class clazz = QueryReferenceBroker.this.classToPrefetch;
            QueryReferenceBroker.this.classToPrefetch = relationshipPrefetcher.getItemClassDescriptor().getClassOfObject();
            try {
                relationshipPrefetcher.prefetchRelationship(list);
            }
            finally {
                QueryReferenceBroker.this.classToPrefetch = clazz;
            }
            if (bl) {
                this._retrievalTasks.remove(this._key);
            } else {
                list.clear();
                this.addThisListenerTo(arrayList.get(0));
            }
        }
    }

    class PBMaterializationListener
    extends PBPrefetchingListener
    implements MaterializationListener {
        private IndirectionHandler _listenedHandler;

        PBMaterializationListener(Object object, HashMap hashMap, Object object2, int n) {
            super(object, hashMap, object2, n);
        }

        protected void addThisListenerTo(Object object) {
            this._listenedHandler = ProxyHelper.getIndirectionHandler(object);
            if (this._listenedHandler != null) {
                this._listenedHandler.addListener(this);
            }
        }

        protected void removeThisListener() {
            if (this._listenedHandler != null) {
                this._listenedHandler.removeListener(this);
                this._listenedHandler = null;
            }
        }

        protected RelationshipPrefetcher getPrefetcher(Object object) {
            if (this._key instanceof ObjectReferenceDescriptor) {
                return QueryReferenceBroker.this.pb.getRelationshipPrefetcherFactory().createRelationshipPrefetcher((ObjectReferenceDescriptor)this._key);
            }
            IndirectionHandler indirectionHandler = (IndirectionHandler)object;
            return new PlainPrefetcher(QueryReferenceBroker.this.pb, indirectionHandler.getIdentity().getObjectsTopLevelClass());
        }

        public void beforeMaterialization(IndirectionHandler indirectionHandler, Identity identity) {
            this.prefetch(indirectionHandler);
        }

        public void afterMaterialization(IndirectionHandler indirectionHandler, Object object) {
        }
    }
}

