/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.access.exception.ObjectExistsException;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.RuntimeCacheException;

public class ObjectCacheJCSImpl
implements ObjectCache {
    public static final String DEFAULT_REGION = "ojbDefaultJCSRegion";
    private JCS jcsCache;
    private String regionName = "ojbDefaultJCSRegion";

    public ObjectCacheJCSImpl(PersistenceBroker persistenceBroker, Properties properties) {
        this(null);
    }

    public ObjectCacheJCSImpl(String string) {
        this.regionName = string != null ? string : DEFAULT_REGION;
        try {
            this.jcsCache = JCS.getInstance((String)this.regionName);
        }
        catch (Exception exception) {
            throw new RuntimeCacheException("Can't instantiate JCS ObjectCacheImplementation", exception);
        }
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void cache(Identity identity, Object object) {
        try {
            this.jcsCache.put((Object)identity.toString(), object);
        }
        catch (CacheException cacheException) {
            throw new RuntimeCacheException(cacheException);
        }
    }

    public boolean cacheIfNew(Identity identity, Object object) {
        boolean bl = false;
        try {
            this.jcsCache.putSafe((Object)identity.toString(), object);
            bl = true;
        }
        catch (ObjectExistsException objectExistsException) {
        }
        catch (CacheException cacheException) {
            throw new RuntimeCacheException(cacheException);
        }
        return bl;
    }

    public Object lookup(Identity identity) {
        return this.jcsCache.get((Object)identity.toString());
    }

    public void remove(Identity identity) {
        try {
            this.jcsCache.remove((Object)identity.toString());
        }
        catch (CacheException cacheException) {
            throw new RuntimeCacheException(cacheException.getMessage());
        }
    }

    public void clear() {
        if (this.jcsCache != null) {
            try {
                this.jcsCache.remove();
            }
            catch (CacheException cacheException) {
                throw new RuntimeCacheException(cacheException);
            }
        }
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        toStringBuilder.append("JCS region name", (Object)this.regionName);
        toStringBuilder.append("JCS region", (Object)this.jcsCache);
        return toStringBuilder.toString();
    }
}

