/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCacheInternal;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ObjectCacheDefaultImpl
implements ObjectCacheInternal,
PBStateListener {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl == null ? (class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl = ObjectCacheDefaultImpl.class$("org.apache.ojb.broker.cache.ObjectCacheDefaultImpl")) : class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl);
    public static final String TIMEOUT_PROP = "timeout";
    public static final String AUTOSYNC_PROP = "autoSync";
    public static final String CACHING_KEY_TYPE_PROP = "cachingKeyType";
    public static final String SOFT_REFERENCES_PROP = "useSoftReferences";
    protected static final Map objectTable = new Hashtable();
    private static final ReferenceQueue queue = new ReferenceQueue();
    private static long hitCount = 0L;
    private static long failCount = 0L;
    private static long gcCount = 0L;
    protected PersistenceBroker broker;
    private List identitiesInWork;
    private long timeout = 900000L;
    private boolean useAutoSync = false;
    private int cachingKeyType;
    private boolean useSoftReferences = true;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl;

    public ObjectCacheDefaultImpl(PersistenceBroker persistenceBroker, Properties properties) {
        this.broker = persistenceBroker;
        this.timeout = properties == null ? this.timeout : Long.parseLong(properties.getProperty(TIMEOUT_PROP, "900")) * 1000L;
        this.useSoftReferences = properties != null && Boolean.valueOf(properties.getProperty(SOFT_REFERENCES_PROP, "true").trim()) != false;
        this.cachingKeyType = properties == null ? 0 : Integer.parseInt(properties.getProperty(CACHING_KEY_TYPE_PROP, "0"));
        boolean bl = this.useAutoSync = properties != null && Boolean.valueOf(properties.getProperty(AUTOSYNC_PROP, "false").trim()) != false;
        if (this.useAutoSync) {
            if (persistenceBroker != null) {
                persistenceBroker.addListener(this, true);
            } else {
                this.log.info("Can't enable property 'autoSync', because given PB instance is null");
            }
        }
        this.identitiesInWork = new ArrayList();
        if (this.log.isEnabledFor(2)) {
            ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
            toStringBuilder.append(TIMEOUT_PROP, this.timeout).append(SOFT_REFERENCES_PROP, this.useSoftReferences).append(CACHING_KEY_TYPE_PROP, this.cachingKeyType).append("useAutoSync", this.useAutoSync);
            this.log.info("Setup cache: " + toStringBuilder.toString());
        }
    }

    public void clear() {
        objectTable.clear();
        this.identitiesInWork.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInternalCache(Identity identity, Object object, int n) {
        if (object != null) {
            this.traceIdentity(identity);
            Map map = objectTable;
            synchronized (map) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cache object " + identity);
                }
                objectTable.put(this.buildKey(identity), this.buildEntry(object, identity));
            }
        }
    }

    public void cache(Identity identity, Object object) {
        this.doInternalCache(identity, object, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cacheIfNew(Identity identity, Object object) {
        boolean bl = false;
        Object object2 = this.buildKey(identity);
        if (object != null) {
            Map map = objectTable;
            synchronized (map) {
                if (!objectTable.containsKey(object2)) {
                    objectTable.put(object2, this.buildEntry(object, identity));
                    bl = true;
                }
            }
            if (bl) {
                this.traceIdentity(identity);
            }
        }
        return bl;
    }

    public Object lookup(Identity identity) {
        this.processQueue();
        ++hitCount;
        Object object = null;
        CacheEntry cacheEntry = (CacheEntry)objectTable.get(this.buildKey(identity));
        if (cacheEntry != null) {
            object = cacheEntry.get();
            if (object == null || cacheEntry.getLifetime() < System.currentTimeMillis()) {
                ++gcCount;
                this.remove(identity);
                object = null;
            } else {
                this.traceIdentity(identity);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Object match " + identity);
                }
            }
        } else {
            ++failCount;
        }
        return object;
    }

    public void remove(Identity identity) {
        if (identity != null) {
            this.removeTracedIdentity(identity);
            objectTable.remove(this.buildKey(identity));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Remove object " + identity);
            }
        }
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        toStringBuilder.append("Count of cached objects", objectTable.keySet().size());
        toStringBuilder.append("Lookup hits", hitCount);
        toStringBuilder.append("Failures", failCount);
        toStringBuilder.append("Reclaimed", gcCount);
        return toStringBuilder.toString();
    }

    private void traceIdentity(Identity identity) {
        if (this.useAutoSync && this.broker != null && this.broker.isInTransaction()) {
            this.identitiesInWork.add(identity);
        }
    }

    private void removeTracedIdentity(Identity identity) {
        this.identitiesInWork.remove(identity);
    }

    private void synchronizeWithTracedObjects() {
        this.log.info("tx was aborted, remove " + this.identitiesInWork.size() + " traced (potentially modified) objects from cache");
        Iterator iterator = this.identitiesInWork.iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            objectTable.remove(this.buildKey(identity));
        }
    }

    public void beforeRollback(PBStateEvent pBStateEvent) {
        this.synchronizeWithTracedObjects();
        this.identitiesInWork.clear();
    }

    public void beforeCommit(PBStateEvent pBStateEvent) {
    }

    public void beforeClose(PBStateEvent pBStateEvent) {
        if (!this.broker.isInTransaction()) {
            this.identitiesInWork.clear();
        }
    }

    public void afterRollback(PBStateEvent pBStateEvent) {
    }

    public void afterCommit(PBStateEvent pBStateEvent) {
        this.identitiesInWork.clear();
    }

    public void afterBegin(PBStateEvent pBStateEvent) {
    }

    public void beforeBegin(PBStateEvent pBStateEvent) {
    }

    public void afterOpen(PBStateEvent pBStateEvent) {
    }

    private CacheEntry buildEntry(Object object, Identity identity) {
        if (this.useSoftReferences) {
            return new CacheEntrySoft(object, identity, queue, this.timeout);
        }
        return new CacheEntryHard(object, identity, this.timeout);
    }

    private void processQueue() {
        CacheEntry cacheEntry;
        while ((cacheEntry = (CacheEntry)((Object)queue.poll())) != null) {
            this.removeTracedIdentity(cacheEntry.getOid());
            objectTable.remove(this.buildKey(cacheEntry.getOid()));
        }
    }

    private Object buildKey(Identity identity) {
        Object object;
        switch (this.cachingKeyType) {
            case 0: {
                object = identity;
                break;
            }
            case 1: {
                object = new OrderedTuple(identity, this.broker.getPBKey().getAlias());
                break;
            }
            case 2: {
                object = new OrderedTuple(identity, new Integer(this.broker.getDescriptorRepository().hashCode()));
                break;
            }
            case 3: {
                object = new OrderedTuple(identity, this.broker.getPBKey().getAlias(), new Integer(this.broker.getDescriptorRepository().hashCode()));
                break;
            }
            default: {
                throw new OJBRuntimeException("Unexpected error, 'cacheType =" + this.cachingKeyType + "' was not supported");
            }
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class CacheEntryHard
    implements CacheEntry {
        private final long lifetime;
        private final Identity oid;
        private Object obj;

        CacheEntryHard(Object object, Identity identity, long l) {
            this.obj = object;
            this.oid = identity;
            this.lifetime = l < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + l;
        }

        public Object get() {
            return this.obj;
        }

        public Identity getOid() {
            return this.oid;
        }

        public long getLifetime() {
            return this.lifetime;
        }
    }

    static final class CacheEntrySoft
    extends SoftReference
    implements CacheEntry {
        private final long lifetime;
        private final Identity oid;

        CacheEntrySoft(Object object, Identity identity, ReferenceQueue referenceQueue, long l) {
            super(object, referenceQueue);
            this.oid = identity;
            this.lifetime = l < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + l;
        }

        public Identity getOid() {
            return this.oid;
        }

        public long getLifetime() {
            return this.lifetime;
        }
    }

    static interface CacheEntry {
        public Object get();

        public Identity getOid();

        public long getLifetime();
    }

    static final class OrderedTuple {
        private static int[] multipliers = new int[]{13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 51};
        private Object[] elements;
        private int hashCode;

        public OrderedTuple(Object object) {
            this.elements = new Object[1];
            this.elements[0] = object;
            this.hashCode = this.calcHashCode();
        }

        public OrderedTuple(Object object, Object object2) {
            this.elements = new Object[2];
            this.elements[0] = object;
            this.elements[1] = object2;
            this.hashCode = this.calcHashCode();
        }

        public OrderedTuple(Object object, Object object2, Object object3) {
            this.elements = new Object[3];
            this.elements[0] = object;
            this.elements[1] = object2;
            this.elements[2] = object3;
            this.hashCode = this.calcHashCode();
        }

        public OrderedTuple(Object[] objectArray) {
            this.elements = objectArray;
            this.hashCode = this.calcHashCode();
        }

        private int calcHashCode() {
            int n = 7;
            for (int i = 0; i < this.elements.length; ++i) {
                int n2 = i % multipliers.length;
                n += this.elements[i].hashCode() * multipliers[n2];
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof OrderedTuple)) {
                return false;
            }
            OrderedTuple orderedTuple = (OrderedTuple)object;
            if (this.hashCode != orderedTuple.hashCode) {
                return false;
            }
            if (this.elements.length != orderedTuple.elements.length) {
                return false;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i].equals(orderedTuple.elements[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('{');
            for (int i = 0; i < this.elements.length; ++i) {
                stringBuffer.append(this.elements[i]).append('#').append(this.elements[i].hashCode()).append(',');
            }
            stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
            stringBuffer.append("#").append(this.hashCode);
            return stringBuffer.toString();
        }
    }
}

