/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.RuleSetBase;
import org.apache.commons.digester.Rules;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ojb.broker.ant.DataSet;
import org.apache.ojb.broker.ant.DataTaskException;
import org.apache.ojb.broker.ant.PreparedModel;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DdlUtilsDataHandling {
    private Database _dbModel;
    private Platform _platform;
    private PreparedModel _preparedModel;
    private Digester _digester = new Digester();
    static /* synthetic */ Class class$org$apache$ojb$broker$ant$DataSet;

    public DdlUtilsDataHandling() {
        this._digester.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) {
                return new InputSource(new StringReader(""));
            }
        });
        this._digester.setNamespaceAware(true);
        this._digester.setValidating(false);
        this._digester.setUseContextClassLoader(true);
        this._digester.setRules((Rules)new ExtendedBaseRules());
        this._digester.addRuleSet((RuleSet)new DataRuleSet());
    }

    public void setModel(Database database, DescriptorRepository descriptorRepository) {
        this._dbModel = database;
        this._preparedModel = new PreparedModel(descriptorRepository, database);
    }

    public void setPlatform(Platform platform) {
        this._platform = platform;
    }

    public void getDataDTD(Writer writer) throws DataTaskException {
        try {
            String string;
            writer.write("<!ELEMENT dataset (\n");
            Iterator iterator = this._preparedModel.getElementNames();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                writer.write("    ");
                writer.write(string);
                writer.write("*");
                writer.write(iterator.hasNext() ? " |\n" : "\n");
            }
            writer.write(")>\n<!ATTLIST dataset\n    name CDATA #REQUIRED\n>\n");
            iterator = this._preparedModel.getElementNames();
            while (iterator.hasNext()) {
                Object object;
                Iterator iterator2;
                string = (String)iterator.next();
                List list = this._preparedModel.getClassDescriptorsMappingTo(string);
                if (list == null) {
                    writer.write("\n<!-- Indirection table");
                } else {
                    writer.write("\n<!-- Mapped to : ");
                    iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        object = (ClassDescriptor)iterator2.next();
                        writer.write(((ClassDescriptor)object).getClassNameOfObject());
                        if (!iterator2.hasNext()) continue;
                        writer.write("\n                 ");
                    }
                }
                writer.write(" -->\n<!ELEMENT ");
                writer.write(string);
                writer.write(" EMPTY>\n<!ATTLIST ");
                writer.write(string);
                writer.write("\n");
                iterator2 = this._preparedModel.getAttributeNames(string);
                while (iterator2.hasNext()) {
                    object = (String)iterator2.next();
                    writer.write("    ");
                    writer.write((String)object);
                    writer.write(" CDATA #");
                    writer.write(this._preparedModel.isRequired(string, (String)object) ? "REQUIRED" : "IMPLIED");
                    writer.write("\n");
                }
                writer.write(">\n");
            }
        }
        catch (IOException iOException) {
            throw new DataTaskException(iOException);
        }
    }

    public void getInsertDataSql(Reader reader, Writer writer) throws DataTaskException {
        try {
            DataSet dataSet = (DataSet)this._digester.parse(reader);
            dataSet.createInsertionSql(this._dbModel, this._platform, writer);
        }
        catch (Exception exception) {
            if (exception instanceof DataTaskException) {
                throw (DataTaskException)((Object)exception);
            }
            throw new DataTaskException(exception);
        }
    }

    public void insertData(Reader reader, int n) throws DataTaskException {
        try {
            DataSet dataSet = (DataSet)this._digester.parse(reader);
            dataSet.insert(this._platform, this._dbModel, n);
        }
        catch (Exception exception) {
            if (exception instanceof DataTaskException) {
                throw (DataTaskException)((Object)exception);
            }
            throw new DataTaskException(exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class DataRuleSet
    extends RuleSetBase {
        public void addRuleInstances(Digester digester) {
            digester.addObjectCreate("dataset", class$org$apache$ojb$broker$ant$DataSet == null ? (class$org$apache$ojb$broker$ant$DataSet = DdlUtilsDataHandling.class$("org.apache.ojb.broker.ant.DataSet")) : class$org$apache$ojb$broker$ant$DataSet);
            digester.addRule("*/dataset/*", (Rule)new DynaFactoryCreateRule());
        }
    }

    private class DynaFactoryCreateRule
    extends Rule {
        private DynaFactoryCreateRule() {
        }

        public void begin(String string, String string2, Attributes attributes) throws Exception {
            DynaBean dynaBean = DdlUtilsDataHandling.this._preparedModel.createBeanFor(string2);
            if (dynaBean == null) {
                throw new DataTaskException("Unknown element " + string2);
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string3 = attributes.getLocalName(i);
                String string4 = attributes.getValue(i);
                Column column = DdlUtilsDataHandling.this._preparedModel.getColumnFor(string2, string3);
                if (column == null) {
                    throw new DataTaskException("Unknown attribute " + string3 + " of element " + string2);
                }
                dynaBean.set(column.getName(), (Object)string4);
            }
            DdlUtilsDataHandling.this._digester.push((Object)dynaBean);
        }

        public void end(String string, String string2) throws Exception {
            DynaBean dynaBean = (DynaBean)DdlUtilsDataHandling.this._digester.pop();
            ((DataSet)DdlUtilsDataHandling.this._digester.peek()).add(dynaBean);
        }
    }
}

