/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.conversions;

import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.accesslayer.conversions.ConversionException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;

public class TimeList2VarcharFieldConversion
implements FieldConversion {
    private static final String NULLVALUE = "#NULL#";
    private static final String EMPTYCOLLEC = "#EMTPY#";

    public Object javaToSql(Object object) throws ConversionException {
        if (object == null) {
            return NULLVALUE;
        }
        try {
            List list = (List)object;
            if (list.isEmpty()) {
                return NULLVALUE;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                Time time = (Time)list.get(i);
                String string = time.toString();
                string = StringUtils.replace((String)string, (String)"#", (String)"##");
                stringBuffer.append(string);
                stringBuffer.append("#");
            }
            return stringBuffer.toString();
        }
        catch (ClassCastException classCastException) {
            throw new ConversionException("Object is not a List of Time it is a" + object.getClass().getName());
        }
    }

    public Object sqlToJava(Object object) throws ConversionException {
        if (object == null) {
            return null;
        }
        if (object.toString().equals(NULLVALUE)) {
            return null;
        }
        if (object.toString().equals(EMPTYCOLLEC)) {
            return new ArrayList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = object.toString();
        int n = string.indexOf("#");
        while (n >= 0) {
            if (n == 0) {
                arrayList.add("");
            } else {
                arrayList.add(Time.valueOf(string.substring(0, n)));
            }
            if (n + 1 > string.length()) break;
            string = string.substring(n + 1, string.length());
            n = string.indexOf("#");
        }
        return arrayList;
    }
}

