/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryAbstractImpl;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionFactoryNotPooledImpl
extends ConnectionFactoryAbstractImpl {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$ConnectionFactoryNotPooledImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryNotPooledImpl = ConnectionFactoryNotPooledImpl.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryNotPooledImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryNotPooledImpl);
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryNotPooledImpl;

    public Connection checkOutJdbcConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("checkOutJdbcConnection: this implementation always return a new Connection");
        }
        Connection connection = this.newConnectionFromDriverManager(jdbcConnectionDescriptor);
        this.validateConnection(connection, jdbcConnectionDescriptor);
        return connection;
    }

    protected void validateConnection(Connection connection, JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        if (connection == null) {
            this.log.error(this.getJcdDescription(jdbcConnectionDescriptor) + " failed, DriverManager returned null");
            throw new LookupException("No Connection returned from DriverManager");
        }
        try {
            if (connection.isClosed()) {
                this.log.error(this.getJcdDescription(jdbcConnectionDescriptor) + " is invalid (closed)");
                throw new LookupException("Could not create valid connection, connection was " + connection);
            }
        }
        catch (SQLException sQLException) {
            this.log.error(this.getJcdDescription(jdbcConnectionDescriptor) + " failed validation with exception");
            throw new LookupException("Connection validation failed", sQLException);
        }
    }

    public void releaseJdbcConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor, Connection connection) throws LookupException {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            this.log.warn("Connection.close() failed, message was " + sQLException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

