/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.locking.LockManager;

public class LockManagerOdmgImpl
implements LockManager {
    private org.apache.ojb.broker.locking.LockManager lm;

    public LockManagerOdmgImpl(org.apache.ojb.broker.locking.LockManager lm) {
        this.lm = lm;
    }

    private boolean ignore(int isolationLevel) {
        return isolationLevel == 4 || isolationLevel == -1;
    }

    public boolean readLock(TransactionImpl tx, Object obj) {
        Identity oid = tx.getBroker().serviceIdentity().buildIdentity(obj);
        return this.readLock(tx, oid, obj);
    }

    public boolean readLock(TransactionImpl tx, Identity oid, Object obj) {
        ClassDescriptor cld = tx.getBroker().getClassDescriptor(ProxyHelper.getRealClass(obj));
        int isolationLevel = cld.getIsolationLevel();
        return this.ignore(isolationLevel) ? true : this.lm.readLock(tx.getGUID(), oid, isolationLevel);
    }

    public boolean writeLock(TransactionImpl tx, Object obj) {
        Identity oid = tx.getBroker().serviceIdentity().buildIdentity(obj);
        return this.writeLock(tx, oid, obj);
    }

    public boolean writeLock(TransactionImpl tx, Identity oid, Object obj) {
        ClassDescriptor cld = tx.getBroker().getClassDescriptor(ProxyHelper.getRealClass(obj));
        int isolationLevel = cld.getIsolationLevel();
        return this.ignore(isolationLevel) ? true : this.lm.writeLock(tx.getGUID(), oid, isolationLevel);
    }

    public boolean upgradeLock(TransactionImpl tx, Object obj) {
        Identity oid = tx.getBroker().serviceIdentity().buildIdentity(obj);
        return this.upgradeLock(tx, oid, obj);
    }

    public boolean upgradeLock(TransactionImpl tx, Identity oid, Object obj) {
        ClassDescriptor cld = tx.getBroker().getClassDescriptor(ProxyHelper.getRealClass(obj));
        int isolationLevel = cld.getIsolationLevel();
        return this.ignore(isolationLevel) ? true : this.lm.upgradeLock(tx.getGUID(), oid, isolationLevel);
    }

    public boolean releaseLock(TransactionImpl tx, Object obj) {
        Identity oid = tx.getBroker().serviceIdentity().buildIdentity(obj);
        return this.releaseLock(tx, oid, obj);
    }

    public boolean releaseLock(TransactionImpl tx, Identity oid, Object obj) {
        return this.lm.releaseLock(tx.getGUID(), oid);
    }

    public boolean checkRead(TransactionImpl tx, Object obj) {
        Identity oid = tx.getBroker().serviceIdentity().buildIdentity(obj);
        return this.checkRead(tx, oid, obj);
    }

    public boolean checkRead(TransactionImpl tx, Identity oid, Object obj) {
        return this.lm.hasRead(tx.getGUID(), oid);
    }

    public boolean checkWrite(TransactionImpl tx, Object obj) {
        Identity oid = tx.getBroker().serviceIdentity().buildIdentity(obj);
        return this.checkWrite(tx, oid, obj);
    }

    public boolean checkWrite(TransactionImpl tx, Identity oid, Object obj) {
        return this.lm.hasWrite(tx.getGUID(), oid);
    }
}

