/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListEntry;
import org.apache.ojb.odmg.collections.DSetEntry;
import org.apache.ojb.odmg.collections.DSetIterator;
import org.apache.ojb.odmg.oql.EnhancedOQLQuery;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DCollection;
import org.odmg.DList;
import org.odmg.DSet;
import org.odmg.ODMGRuntimeException;
import org.odmg.QueryInvalidException;

public class DSetImpl
extends AbstractSet
implements DSet,
Serializable,
PersistenceBrokerAware,
ManageableCollection {
    private static final long serialVersionUID = -4459673364598652639L;
    private transient Logger log;
    private Integer id;
    private List elements = new ArrayList();
    private PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DSetImpl;

    public DSetImpl() {
        this.getPBKey();
    }

    public DSetImpl(PBKey pbKey) {
        this();
        this.pbKey = pbKey;
    }

    protected Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DSetImpl == null ? (class$org$apache$ojb$odmg$collections$DSetImpl = DSetImpl.class$("org.apache.ojb.odmg.collections.DSetImpl")) : class$org$apache$ojb$odmg$collections$DSetImpl);
        }
        return this.log;
    }

    private DSetEntry prepareEntry(Object obj) {
        return new DSetEntry(this, obj);
    }

    protected TransactionImpl getTransaction() {
        return TxManagerFactory.instance().getTransaction();
    }

    protected boolean checkForOpenTransaction(TransactionImpl tx) {
        boolean result = false;
        if (tx != null && tx.isOpen()) {
            result = true;
        }
        return result;
    }

    public PBKey getPBKey() {
        TransactionImpl tx;
        if (this.pbKey == null && (tx = this.getTransaction()) != null && tx.isOpen()) {
            this.pbKey = tx.getBroker().getPBKey();
        }
        return this.pbKey;
    }

    public void setPBKey(PBKey pbKey) {
        this.pbKey = pbKey;
    }

    public boolean remove(Object o) {
        return super.remove(o);
    }

    public boolean removeAll(Collection c) {
        return super.removeAll(c);
    }

    public boolean add(Object o) {
        if (!this.contains(o)) {
            DSetEntry entry = this.prepareEntry(o);
            this.elements.add(entry);
            TransactionImpl tx = this.getTransaction();
            if (tx != null && tx.isOpen()) {
                RuntimeObject rt = new RuntimeObject(this, tx);
                tx.lockAndRegister(rt, 4, false);
                tx.lock(o, 1);
                rt = new RuntimeObject(entry, tx, true);
                tx.lockAndRegister(rt, 4, false);
            }
            return true;
        }
        return false;
    }

    public DSet difference(DSet otherSet) {
        DSetImpl result = new DSetImpl(this.getPBKey());
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object candidate = iter.next();
            if (otherSet.contains(candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    public boolean existsElement(String predicate) throws QueryInvalidException {
        DList results = (DList)this.query(predicate);
        return results != null && results.size() != 0;
    }

    public List getElements() {
        return this.elements;
    }

    public void setElements(List elements) {
        this.elements = elements;
    }

    public Integer getId() {
        return this.id;
    }

    public DSet intersection(DSet otherSet) {
        DSet union = this.union(otherSet);
        DSetImpl result = new DSetImpl(this.getPBKey());
        Iterator iter = union.iterator();
        while (iter.hasNext()) {
            Object candidate = iter.next();
            if (!this.contains(candidate) || !otherSet.contains(candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    public Iterator iterator() {
        return new DSetIterator(this);
    }

    public boolean properSubsetOf(DSet otherSet) {
        return this.size() > 0 && this.size() < otherSet.size() && this.subsetOf(otherSet);
    }

    public boolean properSupersetOf(DSet otherSet) {
        return otherSet.size() > 0 && otherSet.size() < this.size() && this.supersetOf(otherSet);
    }

    public DCollection query(String predicate) throws QueryInvalidException {
        String oql = "select all from java.lang.Object where " + predicate;
        TransactionImpl tx = this.getTransaction();
        EnhancedOQLQuery predicateQuery = tx.getImplementation().newOQLQuery();
        PBCapsule capsule = new PBCapsule(tx.getImplementation().getCurrentPBKey(), tx);
        PersistenceBroker broker = capsule.getBroker();
        try {
            predicateQuery.create(oql);
            Query pQ = ((OQLQueryImpl)predicateQuery).getQuery();
            Criteria pCrit = pQ.getCriteria();
            Criteria allElementsCriteria = this.getPkCriteriaForAllElements(broker);
            pCrit.addAndCriteria(allElementsCriteria);
            Class clazz = this.getElementsExtentClass(broker);
            QueryByCriteria q = new QueryByCriteria(clazz, pCrit);
            if (this.log.isDebugEnabled()) {
                this.log.debug(((Object)q).toString());
            }
            DSetImpl dSetImpl = (DSetImpl)broker.getCollectionByQuery(class$org$apache$ojb$odmg$collections$DSetImpl == null ? (class$org$apache$ojb$odmg$collections$DSetImpl = DSetImpl.class$("org.apache.ojb.odmg.collections.DSetImpl")) : class$org$apache$ojb$odmg$collections$DSetImpl, q);
            return dSetImpl;
        }
        catch (PersistenceBrokerException e) {
            throw new ODMGRuntimeException(e.getMessage());
        }
        finally {
            capsule.destroy();
        }
    }

    private Criteria getPkCriteriaForAllElements(PersistenceBroker broker) {
        try {
            Criteria crit = null;
            for (int i = 0; i < this.elements.size(); ++i) {
                DListEntry entry = (DListEntry)this.elements.get(i);
                Object obj = entry.getRealSubject();
                ClassDescriptor cld = broker.getClassDescriptor(obj.getClass());
                FieldDescriptor[] pkFields = cld.getPkFields();
                ValueContainer[] pkValues = broker.serviceBrokerHelper().getKeyValues(cld, obj);
                Criteria criteria = new Criteria();
                for (int j = 0; j < pkFields.length; ++j) {
                    FieldDescriptor fld = pkFields[j];
                    criteria.addEqualTo(fld.getPersistentField().getName(), pkValues[j].getValue());
                }
                if (crit == null) {
                    crit = criteria;
                    continue;
                }
                crit.addOrCriteria(criteria);
            }
            return crit;
        }
        catch (PersistenceBrokerException e) {
            this.log.error((Object)e);
            return null;
        }
    }

    private Class getElementsExtentClass(PersistenceBroker broker) throws PersistenceBrokerException {
        DListEntry entry = (DListEntry)this.elements.get(0);
        Class<?> elementsClass = entry.getRealSubject().getClass();
        Class extentClass = broker.getTopLevelClass(elementsClass);
        return extentClass;
    }

    public Iterator select(String predicate) throws QueryInvalidException {
        return this.query(predicate).iterator();
    }

    public Object selectElement(String predicate) throws QueryInvalidException {
        return ((DList)this.query(predicate)).get(0);
    }

    public void setElements(Vector elements) {
        this.elements = elements;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean subsetOf(DSet otherSet) {
        return otherSet.containsAll(this);
    }

    public boolean supersetOf(DSet otherSet) {
        return this.containsAll(otherSet);
    }

    public DSet union(DSet otherSet) {
        DSetImpl result = new DSetImpl(this.getPBKey());
        result.addAll(this);
        result.addAll(otherSet);
        return result;
    }

    public void ojbAdd(Object anObject) {
        DSetEntry entry = this.prepareEntry(anObject);
        entry.setPosition(this.elements.size());
        this.elements.add(entry);
    }

    public void ojbAddAll(ManageableCollection otherCollection) {
        Iterator it = otherCollection.ojbIterator();
        while (it.hasNext()) {
            this.ojbAdd(it.next());
        }
    }

    public void afterStore(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    public void beforeInsert(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void beforeUpdate(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void beforeDelete(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterUpdate(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterInsert(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterDelete(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterLookup(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

