/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import java.util.Map;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DMapImpl;

public class DMapEntry
implements Map.Entry,
Serializable,
PersistenceBrokerAware {
    private static final long serialVersionUID = 4382757889982004339L;
    private transient Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DMapEntry == null ? (class$org$apache$ojb$odmg$collections$DMapEntry = DMapEntry.class$("org.apache.ojb.odmg.collections.DMapEntry")) : class$org$apache$ojb$odmg$collections$DMapEntry);
    private PBKey pbKey;
    private Integer id;
    private Integer dmapId;
    private Identity keyOid;
    private Identity valueOid;
    private transient Object keyRealSubject;
    private transient Object valueRealSubject;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DMapEntry;

    public DMapEntry() {
        this.pbKey = this.getPBKey();
    }

    public DMapEntry(DMapImpl map, Object key, Object value) {
        if (map != null) {
            this.dmapId = map.getId();
        }
        this.keyRealSubject = key;
        this.valueRealSubject = value;
        this.getPBKey();
    }

    protected Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DMapEntry == null ? (class$org$apache$ojb$odmg$collections$DMapEntry = DMapEntry.class$("org.apache.ojb.odmg.collections.DMapEntry")) : class$org$apache$ojb$odmg$collections$DMapEntry);
        }
        return this.log;
    }

    protected TransactionImpl getTransaction() {
        return TxManagerFactory.instance().getTransaction();
    }

    public PBKey getPBKey() {
        TransactionImpl tx;
        if (this.pbKey == null && (tx = this.getTransaction()) != null && tx.isOpen()) {
            this.pbKey = tx.getBroker().getPBKey();
        }
        return this.pbKey;
    }

    protected void prepareForPersistency(PersistenceBroker broker) {
        if (this.keyOid == null) {
            if (this.keyRealSubject == null) {
                throw new OJBRuntimeException("Key identity and real key object are 'null' - Can not persist empty entry");
            }
            this.keyOid = broker.serviceIdentity().buildIdentity(this.keyRealSubject);
        }
        if (this.valueOid == null) {
            if (this.valueRealSubject == null) {
                throw new OJBRuntimeException("Key identity and real key object are 'null' - Can not persist empty entry");
            }
            this.valueOid = broker.serviceIdentity().buildIdentity(this.valueRealSubject);
        }
    }

    protected void prepareKeyRealSubject(PersistenceBroker broker) {
        if (this.keyOid == null) {
            this.getLog().info("Cannot retrieve real key object because its id is not known");
        } else {
            this.keyRealSubject = broker.getObjectByIdentity(this.keyOid);
        }
    }

    protected void prepareValueRealSubject(PersistenceBroker broker) {
        if (this.valueOid == null) {
            this.getLog().info("Cannot retrieve real key object because its id is not known");
        } else {
            this.valueRealSubject = broker.getObjectByIdentity(this.valueOid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRealKey() {
        if (this.keyRealSubject != null) {
            return this.keyRealSubject;
        }
        TransactionImpl tx = this.getTransaction();
        if (tx != null && tx.isOpen()) {
            this.prepareKeyRealSubject(tx.getBroker());
        } else if (this.getPBKey() != null) {
            PBCapsule capsule = new PBCapsule(this.getPBKey(), null);
            try {
                this.prepareKeyRealSubject(capsule.getBroker());
            }
            finally {
                capsule.destroy();
            }
        } else {
            this.getLog().warn("No tx, no PBKey - can't materialise key with Identity " + this.getKeyOid());
        }
        return this.keyRealSubject;
    }

    public Object getKey() {
        if (this.keyRealSubject == null) {
            return this.getRealKey();
        }
        return this.keyRealSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRealValue() {
        if (this.valueRealSubject != null) {
            return this.valueRealSubject;
        }
        TransactionImpl tx = this.getTransaction();
        if (tx != null && tx.isOpen()) {
            this.prepareValueRealSubject(tx.getBroker());
        } else if (this.getPBKey() != null) {
            PBCapsule capsule = new PBCapsule(this.getPBKey(), null);
            try {
                this.prepareValueRealSubject(capsule.getBroker());
            }
            finally {
                capsule.destroy();
            }
        } else {
            this.getLog().warn("No tx, no PBKey - can't materialise value with Identity " + this.getKeyOid());
        }
        return this.valueRealSubject;
    }

    public Object getValue() {
        if (this.valueRealSubject == null) {
            return this.getRealValue();
        }
        return this.valueRealSubject;
    }

    public Object setValue(Object obj) {
        Object old = this.valueRealSubject;
        this.valueRealSubject = obj;
        return old;
    }

    public Integer getDmapId() {
        return this.dmapId;
    }

    public void setDmapId(Integer dmapId) {
        this.dmapId = dmapId;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Identity getKeyOid() {
        return this.keyOid;
    }

    public void setKeyOid(Identity keyOid) {
        this.keyOid = keyOid;
    }

    public Identity getValueOid() {
        return this.valueOid;
    }

    public void setValueOid(Identity valueOid) {
        this.valueOid = valueOid;
    }

    public void beforeInsert(PersistenceBroker broker) throws PersistenceBrokerException {
        this.prepareForPersistency(broker);
    }

    public void beforeUpdate(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void beforeDelete(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterLookup(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterDelete(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterInsert(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterUpdate(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

