/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListEntry;
import org.apache.ojb.odmg.collections.DListIterator;
import org.apache.ojb.odmg.oql.EnhancedOQLQuery;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DArray;
import org.odmg.DCollection;
import org.odmg.DList;
import org.odmg.ODMGRuntimeException;
import org.odmg.QueryInvalidException;

public class DListImpl
extends AbstractList
implements DList,
DArray,
ManageableCollection,
PersistenceBrokerAware {
    private static final long serialVersionUID = -9219943066614026526L;
    private transient Logger log;
    private Integer id;
    private List elements = new ArrayList();
    private PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DListImpl;

    public DListImpl() {
        this.getPBKey();
    }

    public DListImpl(PBKey pbKey) {
        this();
        this.pbKey = pbKey;
    }

    protected Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DListImpl == null ? (class$org$apache$ojb$odmg$collections$DListImpl = DListImpl.class$("org.apache.ojb.odmg.collections.DListImpl")) : class$org$apache$ojb$odmg$collections$DListImpl);
        }
        return this.log;
    }

    private DListEntry prepareEntry(Object obj) {
        return new DListEntry(this, obj);
    }

    protected TransactionImpl getTransaction() {
        return TxManagerFactory.instance().getTransaction();
    }

    protected boolean checkForOpenTransaction(TransactionImpl tx) {
        boolean result = false;
        if (tx != null && tx.isOpen()) {
            result = true;
        }
        return result;
    }

    public PBKey getPBKey() {
        TransactionImpl tx;
        if (this.pbKey == null && (tx = this.getTransaction()) != null && tx.isOpen()) {
            this.pbKey = tx.getBroker().getPBKey();
        }
        return this.pbKey;
    }

    public void setPBKey(PBKey pbKey) {
        this.pbKey = pbKey;
    }

    public void add(int index, Object element) {
        DListEntry entry = this.prepareEntry(element);
        this.elements.add(index, entry);
        TransactionImpl tx = this.getTransaction();
        if (this.checkForOpenTransaction(tx)) {
            RuntimeObject rt = new RuntimeObject(this, tx);
            tx.lockAndRegister(rt, 4, false);
            tx.lock(element, 1);
            rt = new RuntimeObject(entry, tx, true);
            tx.lockAndRegister(rt, 4, false);
        }
        int offset = 0;
        try {
            offset = ((DListEntry)this.elements.get(index - 1)).getPosition();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        for (int i = offset; i < this.elements.size(); ++i) {
            entry = (DListEntry)this.elements.get(i);
            entry.setPosition(i);
        }
    }

    public Object remove(int index) {
        DListEntry entry = (DListEntry)this.elements.get(index);
        TransactionImpl tx = this.getTransaction();
        if (this.checkForOpenTransaction(tx)) {
            tx.getAssociatedDatabase().deletePersistent(entry);
        }
        this.elements.remove(index);
        int offset = 0;
        try {
            offset = ((DListEntry)this.elements.get(index)).getPosition();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        for (int i = offset; i < this.elements.size(); ++i) {
            entry = (DListEntry)this.elements.get(i);
            entry.setPosition(i);
        }
        return entry.getRealSubject();
    }

    public DList concat(DList otherList) {
        DListImpl result = new DListImpl(this.pbKey);
        result.addAll(this);
        result.addAll(otherList);
        return result;
    }

    public boolean existsElement(String predicate) throws QueryInvalidException {
        DList results = (DList)this.query(predicate);
        return results != null && results.size() != 0;
    }

    public Object get(int index) {
        DListEntry entry = (DListEntry)this.elements.get(index);
        return entry.getRealSubject();
    }

    public List getElements() {
        return this.elements;
    }

    public Integer getId() {
        return this.id;
    }

    public Iterator iterator() {
        return new DListIterator(this);
    }

    public ListIterator listIterator() {
        return new DListIterator(this);
    }

    public ListIterator listIterator(int index) {
        return new DListIterator(this, index);
    }

    private Criteria getPkCriteriaForAllElements(PersistenceBroker brokerForClass) {
        try {
            Criteria crit = null;
            for (int i = 0; i < this.elements.size(); ++i) {
                DListEntry entry = (DListEntry)this.elements.get(i);
                Object obj = entry.getRealSubject();
                ClassDescriptor cld = brokerForClass.getClassDescriptor(obj.getClass());
                FieldDescriptor[] pkFields = cld.getPkFields();
                ValueContainer[] pkValues = brokerForClass.serviceBrokerHelper().getKeyValues(cld, obj);
                Criteria criteria = new Criteria();
                for (int j = 0; j < pkFields.length; ++j) {
                    FieldDescriptor fld = pkFields[j];
                    criteria.addEqualTo(fld.getPersistentField().getName(), pkValues[j].getValue());
                }
                if (crit == null) {
                    crit = criteria;
                    continue;
                }
                crit.addOrCriteria(criteria);
            }
            return crit;
        }
        catch (PersistenceBrokerException e) {
            return null;
        }
    }

    private Class getElementsExtentClass(PersistenceBroker brokerForClass) throws PersistenceBrokerException {
        DListEntry entry = (DListEntry)this.elements.get(0);
        Class<?> elementsClass = entry.getRealSubject().getClass();
        Class extentClass = brokerForClass.getTopLevelClass(elementsClass);
        return extentClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public DCollection query(String predicate) throws QueryInvalidException {
        void var8_13;
        String oql = "select all from java.lang.Object where " + predicate;
        TransactionImpl tx = this.getTransaction();
        if (tx == null) {
            throw new QueryInvalidException("Need running transaction to do query");
        }
        EnhancedOQLQuery predicateQuery = tx.getImplementation().newOQLQuery();
        predicateQuery.create(oql);
        Query pQ = ((OQLQueryImpl)predicateQuery).getQuery();
        Criteria pCrit = pQ.getCriteria();
        PBCapsule handle = new PBCapsule(this.pbKey, tx);
        try {
            PersistenceBroker broker = handle.getBroker();
            Criteria allElementsCriteria = this.getPkCriteriaForAllElements(broker);
            allElementsCriteria.addAndCriteria(pCrit);
            Class clazz = null;
            try {
                clazz = this.getElementsExtentClass(broker);
            }
            catch (PersistenceBrokerException e) {
                this.getLog().error((Object)e);
                throw new ODMGRuntimeException(e.getMessage());
            }
            QueryByCriteria q = new QueryByCriteria(clazz, allElementsCriteria);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug(((Object)q).toString());
            }
            DList result = null;
            try {
                result = (DList)((Object)broker.getCollectionByQuery(class$org$apache$ojb$odmg$collections$DListImpl == null ? (class$org$apache$ojb$odmg$collections$DListImpl = DListImpl.class$("org.apache.ojb.odmg.collections.DListImpl")) : class$org$apache$ojb$odmg$collections$DListImpl, q));
            }
            catch (PersistenceBrokerException e) {
                this.getLog().error("Query failed", (Throwable)((Object)e));
                throw new OJBRuntimeException((Throwable)((Object)e));
            }
        }
        finally {
            if (handle != null) {
                handle.destroy();
            }
        }
        return var8_13;
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this);
        buf.append("id", (Object)this.id);
        buf.append("pbKey", (Object)this.pbKey);
        buf.append((Object)"[containing elements: ");
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            buf.append((Object)(obj != null ? obj.toString() : null));
        }
        buf.append((Object)"]");
        return buf.toString();
    }

    public Iterator select(String predicate) throws QueryInvalidException {
        return this.query(predicate).iterator();
    }

    public Object selectElement(String predicate) throws QueryInvalidException {
        return ((DList)this.query(predicate)).get(0);
    }

    public int size() {
        return this.elements.size();
    }

    public void ojbAdd(Object anObject) {
        DListEntry entry = this.prepareEntry(anObject);
        entry.setPosition(this.elements.size());
        this.elements.add(entry);
    }

    public void ojbAddAll(ManageableCollection otherCollection) {
        Iterator it = otherCollection.ojbIterator();
        while (it.hasNext()) {
            this.ojbAdd(it.next());
        }
    }

    public void afterStore(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    public void resize(int newSize) {
    }

    public void setElements(List elements) {
        this.elements = elements;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void beforeInsert(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void beforeUpdate(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void beforeDelete(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterUpdate(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterInsert(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterDelete(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterLookup(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

