/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldType;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.broker.util.ObjectModificationDefaultImpl;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.ObjectEnvelopeTable;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionAware;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.link.LinkEntry;
import org.apache.ojb.odmg.link.LinkEntryOneToN;
import org.apache.ojb.odmg.link.LinkEntryOneToOne;
import org.apache.ojb.odmg.states.ModificationState;
import org.apache.ojb.odmg.states.StateNewDirty;
import org.apache.ojb.odmg.states.StateOldClean;
import org.apache.ojb.odmg.states.StateOldDirty;
import org.odmg.ClassNotPersistenceCapableException;

public class ObjectEnvelope
implements ObjectModification {
    static final long serialVersionUID = -829177767933340522L;
    static final int IS_MATERIALIZED_OBJECT = 11;
    static final int IS_MATERIALIZED_PROXY = 13;
    static final int IS_UNMATERIALIZED_PROXY = 17;
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$ObjectEnvelope == null ? (class$org$apache$ojb$odmg$ObjectEnvelope = ObjectEnvelope.class$("org.apache.ojb.odmg.ObjectEnvelope")) : class$org$apache$ojb$odmg$ObjectEnvelope);
    private ModificationState modificationState = null;
    private Identity oid;
    private Boolean hasChanged;
    private boolean writeLocked;
    private Object myObj;
    private Map beforeImage;
    private Map currentImage;
    private ObjectEnvelopeTable buffer;
    private List linkEntryList = new ArrayList();
    static /* synthetic */ Class class$org$apache$ojb$odmg$ObjectEnvelope;

    public ObjectEnvelope(ObjectEnvelopeTable buffer, Identity oid, Object obj, boolean isNewObject) {
        this.buffer = buffer;
        this.oid = oid;
        this.myObj = ProxyHelper.getRealObject(obj);
        if (!isNewObject) {
            this.refreshObjectImage();
        }
        this.prepareInitialState(isNewObject);
    }

    public PersistenceBroker getBroker() {
        return this.buffer.getTransaction().getBroker();
    }

    TransactionImpl getTx() {
        return this.buffer.getTransaction();
    }

    ObjectEnvelopeTable getEnvelopeTable() {
        return this.buffer;
    }

    public Map getBeforeImage() {
        if (this.beforeImage == null) {
            this.beforeImage = this.buildObjectImage(this.getBroker());
        }
        return this.beforeImage;
    }

    public Map getCurrentImage() {
        if (this.currentImage == null) {
            this.currentImage = this.buildObjectImage(this.getBroker());
        }
        return this.currentImage;
    }

    public void close() {
        EqualsBase base;
        Iterator iterator;
        if (this.currentImage != null) {
            iterator = this.currentImage.values().iterator();
            while (iterator.hasNext()) {
                base = (EqualsBase)iterator.next();
                if (base == null) continue;
                base.close();
            }
        }
        if (this.beforeImage != null) {
            iterator = this.beforeImage.values().iterator();
            while (iterator.hasNext()) {
                base = (EqualsBase)iterator.next();
                if (base == null) continue;
                base.close();
            }
        }
        this.myObj = null;
    }

    public void refreshObjectImage() {
        PersistenceBroker broker = this.getBroker();
        try {
            if (this.beforeImage != null) {
                this.oid = broker.serviceIdentity().buildIdentity(this.myObj);
            }
            if (this.currentImage != null) {
                this.beforeImage = this.currentImage;
            } else if (this.beforeImage == null) {
                this.beforeImage = this.buildObjectImage(this.getBroker());
            }
            this.currentImage = null;
            this.hasChanged = null;
        }
        catch (Exception ex) {
            this.beforeImage = null;
            this.currentImage = null;
            this.hasChanged = null;
            this.log.error("Can't refresh object image", ex);
            throw new ClassNotPersistenceCapableException(ex.toString());
        }
    }

    public Identity getIdentity() {
        return this.oid;
    }

    public Object getObject() {
        return this.myObj;
    }

    public void refreshObjectIfNeeded(Object obj) {
        if (this.myObj != obj) {
            this.myObj = obj;
        }
    }

    public void beforeCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.beforeCommit();
        }
    }

    public void afterCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.afterCommit();
        }
    }

    public void beforeAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.beforeAbort();
        }
    }

    public void afterAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.afterAbort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map buildObjectImage(PersistenceBroker broker) throws PersistenceBrokerException {
        HashMap<Object, EqualsBase> fieldValues = new HashMap<Object, EqualsBase>();
        ClassDescriptor mif = broker.getClassDescriptor(this.getObject().getClass());
        Iterator iter = mif.getObjectReferenceDescriptors().iterator();
        ObjectReferenceDescriptor rds = null;
        while (iter.hasNext()) {
            Object referenceObject = null;
            rds = (ObjectReferenceDescriptor)iter.next();
            Object object = this.myObj;
            synchronized (object) {
                referenceObject = rds.getPersistentField().get(this.myObj);
            }
            IndirectionHandler handler = ProxyHelper.getIndirectionHandler(referenceObject);
            EqualsRefHelper erh = handler != null ? (handler.alreadyMaterialized() ? new EqualsRefHelper(handler.getRealSubject()) : new EqualsRefHelper(handler.getIdentity())) : new EqualsRefHelper(referenceObject);
            if (handler == null && referenceObject != null && BrokerHelper.hasAnonymousKeyReference(mif, rds)) {
                this.getBroker().serviceBrokerHelper().link(this.myObj, rds, false);
            }
            fieldValues.put(rds, erh);
        }
        FieldDescriptor[] fieldDescs = mif.getFieldDescriptions();
        for (int i = 0; i < fieldDescs.length; ++i) {
            FieldDescriptor fld = fieldDescs[i];
            Object value = fld.getPersistentField().get(this.myObj);
            value = fld.getFieldConversion().javaToSql(value);
            value = fld.getJdbcType().getFieldType().copy(value);
            fieldValues.put(fld.getPersistentField().getName(), new EqualsFieldHelper(fld.getJdbcType().getFieldType(), value));
        }
        Iterator collections = mif.getCollectionDescriptors().iterator();
        CollectionDescriptor cds = null;
        while (collections.hasNext()) {
            cds = (CollectionDescriptor)collections.next();
            Object collectionOrArray = cds.getPersistentField().get(this.myObj);
            EqualsColHelper ech = new EqualsColHelper(cds, collectionOrArray);
            fieldValues.put(cds, ech);
        }
        return fieldValues;
    }

    public ModificationState getModificationState() {
        return this.modificationState;
    }

    public boolean needsInsert() {
        return this.getModificationState().needsInsert();
    }

    public boolean needsUpdate() {
        return this.getModificationState().needsUpdate();
    }

    public boolean needsDelete() {
        return this.getModificationState().needsDelete();
    }

    private void prepareInitialState(boolean isNewObject) {
        ModificationState initialState = null;
        initialState = isNewObject ? StateNewDirty.getInstance() : (this.isDeleted(this.oid) ? StateOldDirty.getInstance() : StateOldClean.getInstance());
        this.modificationState = initialState;
    }

    public boolean isDeleted(Identity id) {
        ObjectEnvelope envelope = this.buffer.getByIdentity(id);
        return envelope == null ? false : envelope.needsDelete();
    }

    public void setModificationState(ModificationState newModificationState) {
        if (newModificationState != this.modificationState) {
            if (LoggerFactory.getDefaultLogger().isDebugEnabled()) {
                LoggerFactory.getDefaultLogger().debug("object state transition for object " + this.oid + " (" + this.modificationState + " --> " + newModificationState + ")");
            }
            this.modificationState = newModificationState;
        }
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this);
        buf.append("Identity", (Object)this.oid).append("ModificationState", (Object)this.modificationState.toString());
        return buf.toString();
    }

    public boolean hasChanged(PersistenceBroker broker) {
        try {
            this.currentImage = this.getCurrentImage();
        }
        catch (Exception e) {
            LoggerFactory.getDefaultLogger().warn("Could not verify object changes, return hasChanged 'true'", e);
        }
        this.hasChanged = this.beforeImage != null && ((Object)this.beforeImage).equals(this.currentImage) ? Boolean.FALSE : Boolean.TRUE;
        return this.hasChanged;
    }

    void markReferenceElements(PersistenceBroker broker) {
        if (this.getModificationState().needsInsert() || this.getModificationState().needsDelete()) {
            return;
        }
        Map oldImage = this.getBeforeImage();
        Map newImage = this.getCurrentImage();
        Iterator iter = newImage.entrySet().iterator();
        while (iter.hasNext()) {
            EqualsRefHelper newEh;
            Map.Entry entry = iter.next();
            if (!(entry.getKey() instanceof ObjectReferenceDescriptor)) continue;
            if (entry.getKey() instanceof CollectionDescriptor) {
                CollectionDescriptor cds = (CollectionDescriptor)entry.getKey();
                EqualsColHelper oldEch = (EqualsColHelper)oldImage.get(cds);
                EqualsColHelper newEch = (EqualsColHelper)entry.getValue();
                this.markDelete(cds, oldEch, newEch);
                this.markNew(cds, oldEch, newEch);
                continue;
            }
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)entry.getKey();
            EqualsRefHelper oldEh = (EqualsRefHelper)oldImage.get(rds);
            if (oldEh.equals(newEh = (EqualsRefHelper)newImage.get(rds))) continue;
            this.setModificationState(this.getModificationState().markDirty());
            if (newEh.value != null) {
                ObjectEnvelope oe = this.buffer.getByIdentity(newEh.oid);
                if (oe == null) {
                    RuntimeObject rt = new RuntimeObject(newEh.value, this.getTx());
                    this.getTx().lockAndRegister(rt, 1, false);
                }
                this.addLinkOneToOne(rds, false);
                continue;
            }
            if (!newEh.isNull()) continue;
            ObjectEnvelope oldRefMod = this.buffer.getByIdentity(oldEh.oid);
            if (this.buffer.isNewAssociatedObject(oldEh.oid)) continue;
            if (this.buffer.getTransaction().cascadeDeleteFor(rds)) {
                oldRefMod.setModificationState(oldRefMod.getModificationState().markDelete());
            }
            this.addLinkOneToOne(rds, true);
        }
    }

    private void markDelete(CollectionDescriptor cds, EqualsColHelper oldEch, EqualsColHelper newEch) {
        if (oldEch.references.size() == 0) {
            return;
        }
        Iterator oldIter = oldEch.references.entrySet().iterator();
        Map newRefs = newEch.references;
        while (oldIter.hasNext()) {
            Map.Entry entry = oldIter.next();
            Identity oldOid = (Identity)entry.getKey();
            if (newRefs.containsKey(oldOid) || newEch.status == 17) continue;
            ObjectEnvelope mod = this.buffer.getByIdentity(oldOid);
            if (this.buffer.isNewAssociatedObject(oldOid)) continue;
            if (mod != null) {
                boolean cascade = this.buffer.getTransaction().cascadeDeleteFor(cds);
                if (cascade) {
                    mod.setModificationState(mod.getModificationState().markDelete());
                    this.buffer.addForDeletionDependent(mod);
                }
                if (cds.isMtoNRelation()) {
                    this.buffer.addM2NUnlinkEntry(cds, this.getObject(), entry.getValue());
                    continue;
                }
                if (cascade) continue;
                mod.setModificationState(mod.getModificationState().markDirty());
                mod.addLinkOneToN(cds, this.getObject(), true);
                continue;
            }
            throw new ImageExcetion("Unexpected behaviour, unregistered object to delete: " + oldOid + ", main object is " + this.getIdentity());
        }
    }

    private void markNew(CollectionDescriptor cds, EqualsColHelper oldEch, EqualsColHelper newEch) {
        if (newEch.references.size() == 0) {
            return;
        }
        Iterator newIter = newEch.references.entrySet().iterator();
        Map oldRefs = oldEch.references;
        while (newIter.hasNext()) {
            Map.Entry entry = newIter.next();
            Identity newOid = (Identity)entry.getKey();
            Object newObj = entry.getValue();
            if (oldRefs != null && oldRefs.containsKey(newOid)) continue;
            ObjectEnvelope mod = this.buffer.getByIdentity(newOid);
            if (mod == null) {
                mod = this.buffer.get(newObj, true);
            }
            if (mod.needsDelete()) {
                mod.setModificationState(mod.getModificationState().markNew());
            } else {
                mod.setModificationState(mod.getModificationState().markDirty());
            }
            this.buffer.addNewAssociatedIdentity(newOid);
            if (cds.isMtoNRelation()) {
                this.buffer.addM2NLinkEntry(cds, this.getObject(), newObj);
            } else {
                mod.addLinkOneToN(cds, this.getObject(), false);
            }
            if (!mod.needsInsert()) continue;
            this.buffer.addForInsertDependent(mod);
        }
    }

    public void doUpdate() {
        this.performLinkEntries();
        this.getBroker().store(this.getObject(), ObjectModificationDefaultImpl.UPDATE);
    }

    public void doInsert() {
        this.performLinkEntries();
        this.getBroker().store(this.getObject(), ObjectModificationDefaultImpl.INSERT);
    }

    public void doDelete() {
        this.getBroker().delete(this.getObject());
    }

    public void doEvictFromCache() {
        this.getBroker().removeFromCache(this.getIdentity());
    }

    public boolean isWriteLocked() {
        return this.writeLocked;
    }

    public void setWriteLocked(boolean writeLocked) {
        this.writeLocked = writeLocked;
    }

    ClassDescriptor getClassDescriptor() {
        return this.getBroker().getClassDescriptor(ProxyHelper.getRealClass(this.getObject()));
    }

    void addLinkOneToOne(ObjectReferenceDescriptor ord, boolean unlink) {
        LinkEntryOneToOne entry = new LinkEntryOneToOne(ord, this.getObject(), unlink);
        this.linkEntryList.add(entry);
    }

    void addLinkOneToN(CollectionDescriptor col, Object source, boolean unlink) {
        if (col.isMtoNRelation()) {
            throw new OJBRuntimeException("Expected an 1:n relation, but specified a m:n");
        }
        LinkEntryOneToN entry = new LinkEntryOneToN(source, col, this.getObject(), unlink);
        this.linkEntryList.add(entry);
    }

    private void performLinkEntries() {
        PersistenceBroker broker = this.getBroker();
        for (int i = 0; i < this.linkEntryList.size(); ++i) {
            LinkEntry linkEntry = (LinkEntry)this.linkEntryList.get(i);
            linkEntry.execute(broker);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ImageExcetion
    extends OJBRuntimeException {
        public ImageExcetion() {
        }

        public ImageExcetion(String msg) {
            super(msg);
        }

        public ImageExcetion(Throwable cause) {
            super(cause);
        }

        public ImageExcetion(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    class EqualsColHelper
    extends EqualsBase
    implements CollectionProxyListener {
        private CollectionDescriptor des;
        private CollectionProxy collectionHandler;
        private int status;
        private Map references;

        public EqualsColHelper(CollectionDescriptor des, Object collOrArray) {
            this.des = des;
            this.references = new HashMap();
            this.assignReferenceObject(collOrArray);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("main class", (Object)this.des.getClassDescriptor().getClassNameOfObject()).append("reference name", (Object)this.des.getPersistentField().getName()).append("reference class", (Object)this.des.getItemClassName()).append("status", this.status).append("references", (Object)this.references).toString();
        }

        public boolean equals(Object obj) {
            return obj instanceof EqualsColHelper;
        }

        void prepareForCompare() {
        }

        void close() {
            if (this.collectionHandler != null) {
                this.collectionHandler.removeListener(this);
                this.collectionHandler = null;
            }
        }

        void assignReferenceObject(Object collOrArray) {
            CollectionProxy colProxy = ProxyHelper.getCollectionProxy(collOrArray);
            if (colProxy != null) {
                if (colProxy.isLoaded()) {
                    this.status = 13;
                    this.handleCollectionOrArray(((CollectionProxyDefaultImpl)colProxy).getData());
                } else {
                    this.status = 17;
                    colProxy.addListener(this);
                    this.collectionHandler = colProxy;
                }
            } else {
                this.status = 11;
                this.handleCollectionOrArray(collOrArray);
            }
        }

        public void beforeLoading(CollectionProxyDefaultImpl colProxy) {
        }

        public void afterLoading(CollectionProxyDefaultImpl colProxy) {
            if (this.status == 17) {
                this.handleMaterializedCollectionProxy(colProxy);
                this.status = 13;
                colProxy.removeListener(this);
                this.collectionHandler = null;
            }
        }

        void addReference(Identity oid, Object obj) {
            this.references.put(oid, obj);
        }

        void handleCollectionOrArray(Object collOrArray) {
            if (collOrArray == null) {
                return;
            }
            Iterator it = BrokerHelper.getCollectionIterator(collOrArray);
            while (it.hasNext()) {
                Object obj = it.next();
                this.addReference(ObjectEnvelope.this.getBroker().serviceIdentity().buildIdentity(obj), obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMaterializedCollectionProxy(CollectionProxyDefaultImpl colProxy) {
            if (colProxy.getData() == null || colProxy.getData().size() == 0) {
                return;
            }
            PBCapsule capsule = new PBCapsule(colProxy.getBrokerKey(), ObjectEnvelope.this.getTx());
            try {
                PersistenceBroker broker = capsule.getBroker();
                Iterator it = colProxy.ojbIterator();
                while (it.hasNext()) {
                    Object tempObj = it.next();
                    IndirectionHandler tempHandler = ProxyHelper.getIndirectionHandler(tempObj);
                    if (tempHandler != null) {
                        this.addReference(tempHandler.getIdentity(), tempObj);
                        continue;
                    }
                    this.addReference(broker.serviceIdentity().buildIdentity(tempObj), tempObj);
                }
            }
            finally {
                if (capsule != null) {
                    capsule.destroy();
                }
            }
        }
    }

    class EqualsRefHelper
    extends EqualsBase {
        Identity oid;
        Object value;

        public EqualsRefHelper(Object refObject) {
            this.value = refObject;
        }

        public EqualsRefHelper(Identity oid) {
            this.oid = oid;
        }

        void close() {
        }

        void prepareForCompare() {
        }

        public boolean isNull() {
            return this.oid == null && this.value == null;
        }

        public boolean equals(Object toCompare) {
            boolean result = false;
            if (this == toCompare) {
                result = true;
            } else if (toCompare instanceof EqualsRefHelper) {
                EqualsRefHelper other = (EqualsRefHelper)toCompare;
                if (this.oid == null && this.value != null) {
                    this.oid = ObjectEnvelope.this.getBroker().serviceIdentity().buildIdentity(this.value);
                }
                if (other.oid == null && other.value != null) {
                    other.oid = ObjectEnvelope.this.getBroker().serviceIdentity().buildIdentity(other.value);
                }
                result = this.oid != null ? this.oid.equals(other.oid) : other.oid == null;
            }
            return result;
        }
    }

    class EqualsFieldHelper
    extends EqualsBase {
        FieldType type;
        Object value;

        public EqualsFieldHelper(FieldType type, Object value) {
            this.type = type;
            this.value = value;
        }

        void close() {
        }

        void prepareForCompare() {
        }

        public boolean equals(Object valueNew) {
            boolean result = false;
            if (this == valueNew) {
                result = true;
            } else if (valueNew instanceof EqualsFieldHelper) {
                result = this.type.equals(this.value, ((EqualsFieldHelper)valueNew).value);
            }
            return result;
        }

        public String toString() {
            return "EqualsFieldHelper[type=" + this.type + "->value=" + this.value + "]";
        }
    }

    abstract class EqualsBase {
        EqualsBase() {
        }

        abstract void close();

        abstract void prepareForCompare();
    }
}

