/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo;

import java.util.Collection;
import java.util.Map;
import javax.jdo.Extent;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.apache.ojb.jdo.ExtentImpl;
import org.apache.ojb.jdo.PersistenceManagerImpl;
import org.apache.ojb.jdo.jdoql.Expression;
import org.apache.ojb.jdo.jdoql.LocalVariable;
import org.apache.ojb.jdo.jdoql.QueryParsingHelper;
import org.apache.ojb.jdo.jdoql.QueryTreeResolver;

public class QueryImpl
implements Query {
    private PersistenceManagerImpl _persistenceManager;
    private Class _searchedClass;
    private Collection _candidateInstances;
    private String _filterString;
    private Expression _filterExpression;
    private String _importString;
    private Collection _imports;
    private String _parameterString;
    private Map _parameters;
    private String _variableString;
    private Map _variables;
    private String _orderingString;
    private Collection _orderings;
    private boolean _ignoreCache;
    private boolean _needsCompilation = true;

    public QueryImpl(PersistenceManagerImpl pm) {
        this._persistenceManager = pm;
        this._candidateInstances = null;
    }

    public PersistenceManager getPersistenceManager() {
        return this._persistenceManager;
    }

    public void setClass(Class searchedClass) {
        this._searchedClass = searchedClass;
        this._needsCompilation = true;
    }

    public Class getSearchedClass() {
        return this._searchedClass;
    }

    public void setCandidates(Extent extent) {
        this._searchedClass = ((ExtentImpl)extent).ojbGetClass();
        this._needsCompilation = true;
    }

    public void setCandidates(Collection candidates) {
        this._candidateInstances = candidates;
        this._needsCompilation = true;
    }

    public void setFilter(String filter) throws JDOUserException {
        this._filterString = filter;
        this._filterExpression = new QueryParsingHelper().parseFilter(filter);
        this._needsCompilation = true;
    }

    public Expression getFilterExpression() {
        return this._filterExpression;
    }

    public void declareImports(String imports) throws JDOUserException {
        this._importString = imports;
        this._imports = new QueryParsingHelper().parseImports(imports);
        this._needsCompilation = true;
    }

    public Collection getImports() {
        return this._imports;
    }

    public void declareParameters(String params) throws JDOUserException {
        this._parameterString = params;
        this._parameters = new QueryParsingHelper().parseParameters(params);
        this._needsCompilation = true;
    }

    public Map getParameters() {
        return this._parameters;
    }

    public LocalVariable getParameter(String name) {
        return (LocalVariable)this._variables.get(name);
    }

    public void declareVariables(String variables) throws JDOUserException {
        this._variableString = variables;
        this._variables = new QueryParsingHelper().parseVariables(variables);
        this._needsCompilation = true;
    }

    public Map getVariables() {
        return this._variables;
    }

    public LocalVariable getVariable(String name) {
        return (LocalVariable)this._variables.get(name);
    }

    public void setOrdering(String orderings) throws JDOUserException {
        this._orderingString = orderings;
        this._orderings = new QueryParsingHelper().parseOrderings(orderings);
        this._needsCompilation = true;
    }

    public Collection getOrderings() {
        return this._orderings;
    }

    public void setIgnoreCache(boolean shouldIgnoreCache) {
        this._ignoreCache = shouldIgnoreCache;
    }

    public boolean getIgnoreCache() {
        return this._ignoreCache;
    }

    public void compile() {
        if (this._needsCompilation) {
            new QueryTreeResolver().resolveAndCheck(this);
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    public Object execute() {
        if (this._needsCompilation) {
            this.compile();
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Object execute(Object o) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Object execute(Object o, Object o1) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Object execute(Object o, Object o1, Object o2) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Object executeWithMap(Map map) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Object executeWithArray(Object[] objects) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public void close(Object o) {
    }

    public void closeAll() {
    }

    QueryImpl ojbClone() {
        QueryImpl query = new QueryImpl(this._persistenceManager);
        query.setClass(this._searchedClass);
        query.setCandidates(this._candidateInstances);
        query.declareImports(this._importString);
        query.declareParameters(this._parameterString);
        query.declareVariables(this._variableString);
        query.setFilter(this._filterString);
        query.setOrdering(this._orderingString);
        return query;
    }
}

