/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.util.HashMap;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;
import org.apache.ojb.broker.util.sequence.SequenceManagerNextValImpl;

public class SequenceManagerSeqHiLoImpl
extends SequenceManagerNextValImpl {
    public static final String PROPERTY_GRAB_SIZE = "grabSize";
    private static HashMap hiLoMap = new HashMap();
    protected int grabSize = Integer.parseInt(this.getConfigurationProperty("grabSize", "20"));

    public SequenceManagerSeqHiLoImpl(PersistenceBroker broker) {
        super(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getUniqueLong(FieldDescriptor field) throws SequenceManagerException {
        String sequenceName = this.calculateSequenceName(field);
        HashMap hashMap = hiLoMap;
        synchronized (hashMap) {
            HiLoEntry entry = (HiLoEntry)hiLoMap.get(sequenceName);
            if (entry == null) {
                entry = new HiLoEntry(this.grabSize, this.grabSize);
                hiLoMap.put(sequenceName, entry);
            }
            if (entry.needNewSequence()) {
                entry.maxVal = (long)this.grabSize * (super.getUniqueLong(field) + 1L);
                entry.counter = 0L;
            }
            return entry.nextVal();
        }
    }

    class HiLoEntry {
        long maxVal;
        long counter;

        public HiLoEntry(long maxVal, long counter) {
            this.maxVal = maxVal;
            this.counter = counter;
        }

        boolean needNewSequence() {
            return this.counter == (long)SequenceManagerSeqHiLoImpl.this.grabSize;
        }

        long nextVal() {
            return this.maxVal + this.counter++;
        }
    }
}

