/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.util.HashMap;
import java.util.Map;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggingConfiguration;
import org.apache.ojb.broker.util.logging.PoorMansLoggerImpl;

public class LoggerFactoryImpl {
    public static final LoggerFactoryImpl INSTANCE = new LoggerFactoryImpl();
    private Logger defaultLogger = null;
    private Logger bootLogger = null;
    private Map cache = new HashMap();
    private LoggingConfiguration conf;
    static /* synthetic */ Class class$java$lang$String;

    private LoggerFactoryImpl() {
    }

    public static LoggerFactoryImpl getInstance() {
        return INSTANCE;
    }

    private LoggingConfiguration getConfiguration() {
        if (this.conf == null) {
            this.conf = new LoggingConfiguration();
        }
        return this.conf;
    }

    public Logger getBootLogger() {
        if (this.bootLogger == null) {
            this.bootLogger = new PoorMansLoggerImpl("BOOT");
            String level = System.getProperty("OJB.bootLogLevel", "WARN");
            ((PoorMansLoggerImpl)this.bootLogger).setLevel(level);
        }
        return this.bootLogger;
    }

    public Logger getDefaultLogger() {
        if (this.defaultLogger == null) {
            this.defaultLogger = this.getLogger("DEFAULT");
        }
        return this.defaultLogger;
    }

    public Logger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }

    public Logger getLogger(String loggerName) {
        if (this.cache.containsKey(loggerName)) {
            return (Logger)this.cache.get(loggerName);
        }
        Logger logger = null;
        Class loggerClass = null;
        try {
            LoggingConfiguration conf = this.getConfiguration();
            loggerClass = conf.getLoggerClass();
            this.getBootLogger().debug("Using logger class " + loggerClass + " for " + loggerName);
            logger = (Logger)ClassHelper.newInstance(loggerClass, class$java$lang$String == null ? (class$java$lang$String = LoggerFactoryImpl.class$("java.lang.String")) : class$java$lang$String, (Object)loggerName);
            try {
                this.getBootLogger().debug("Initializing logger instance " + loggerName);
                logger.configure(conf);
            }
            catch (Exception ex) {
                logger = this.getBootLogger();
                logger.error("[" + this.getClass().getName() + "] Could not initialize logger for class " + loggerClass.getName(), ex);
            }
            this.cache.put(loggerName, logger);
        }
        catch (Throwable t) {
            logger = this.getBootLogger();
            logger.error("[" + this.getClass().getName() + "] Could not set logger for class '" + (loggerClass != null ? loggerClass.getName() : "null") + "'", t);
        }
        return logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

