/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.dbhandling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.dbhandling.DBHandling;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class DBHandlingTask
extends Task {
    private static final String HANDLING_TORQUE = "torque";
    private static final String COMMAND_CREATE = "create";
    private static final String COMMAND_INIT = "init";
    private String _handling = "torque";
    private String _propertiesFile = null;
    private String _jcdAlias = null;
    private String _workDir = null;
    private ArrayList _fileSets = new ArrayList();
    private String _commands = "";

    public void setHandling(String name) {
        this._handling = name == null ? HANDLING_TORQUE : name.toLowerCase();
    }

    public String getHandling() {
        return this._handling;
    }

    public void setPropertiesFile(String path) {
        this._propertiesFile = path;
    }

    public String getPropertiesFile() {
        return this._propertiesFile;
    }

    public void setJcdAlias(String alias) {
        this._jcdAlias = alias;
    }

    public String getJcdAlias() {
        return this._jcdAlias;
    }

    public void setWorkDir(String dir) {
        this._workDir = dir;
    }

    public String getWorkDir() {
        return this._workDir;
    }

    public void addFileset(FileSet fileset) {
        this._fileSets.add(fileset);
    }

    public void setCommands(String listOfCommands) {
        this._commands = listOfCommands;
    }

    public String getCommands() {
        return this._commands;
    }

    public void execute() throws BuildException {
        if (this._commands == null || this._commands.length() == 0) {
            return;
        }
        DBHandling handling = this.createDBHandling();
        try {
            if (this._workDir != null && this._workDir.length() > 0) {
                handling.setWorkDir(this._workDir);
                System.setProperty("user.dir", this._workDir);
            }
            Iterator it = this._fileSets.iterator();
            while (it.hasNext()) {
                this.addIncludes(handling, (FileSet)it.next());
            }
            if (this._propertiesFile != null && this._propertiesFile.length() > 0) {
                System.setProperty("OJB.properties", this._propertiesFile);
            }
            ConnectionRepository connRep = MetadataManager.getInstance().connectionRepository();
            PBKey pbKey = null;
            if (this._jcdAlias == null || this._jcdAlias.length() == 0) {
                pbKey = PersistenceBrokerFactory.getDefaultKey();
            } else {
                pbKey = connRep.getStandardPBKeyForJcdAlias(this._jcdAlias);
                if (pbKey == null) {
                    throw new BuildException("Undefined jcdAlias " + this._jcdAlias);
                }
            }
            handling.setConnection(connRep.getDescriptor(pbKey));
            StringTokenizer tokenizer = new StringTokenizer(this._commands, ",");
            while (tokenizer.hasMoreTokens()) {
                String command = tokenizer.nextToken().toLowerCase().trim();
                if (COMMAND_CREATE.equals(command)) {
                    handling.createDB();
                    continue;
                }
                if (COMMAND_INIT.equals(command)) {
                    handling.initDB();
                    continue;
                }
                throw new BuildException("Unknown command " + command);
            }
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private DBHandling createDBHandling() throws BuildException {
        if (this._handling == null || this._handling.length() == 0) {
            throw new BuildException("No handling specified");
        }
        try {
            String className = "org.apache.ojb.broker.platforms." + Character.toTitleCase(this._handling.charAt(0)) + this._handling.substring(1) + "DBHandling";
            Class handlingClass = ClassHelper.getClass(className);
            return (DBHandling)handlingClass.newInstance();
        }
        catch (Exception ex) {
            throw new BuildException("Invalid handling '" + this._handling + "' specified");
        }
    }

    private void addIncludes(DBHandling handling, FileSet fileSet) throws BuildException {
        DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
        String[] files = scanner.getIncludedFiles();
        StringBuffer includes = new StringBuffer();
        for (int idx = 0; idx < files.length; ++idx) {
            if (idx > 0) {
                includes.append(",");
            }
            includes.append(files[idx]);
        }
        try {
            handling.addDBDefinitionFiles(fileSet.getDir(this.getProject()).getAbsolutePath(), includes.toString());
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }
}

