/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.collections;

import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.collections.IRemovalAwareCollection;
import org.apache.ojb.broker.util.collections.ManageableArrayList;

public class RemovalAwareList
extends ManageableArrayList
implements IRemovalAwareCollection {
    private Vector allObjectsToBeRemoved = new Vector();

    public void afterStore(PersistenceBroker broker) throws PersistenceBrokerException {
        this.allObjectsToBeRemoved.removeAll(this);
        Iterator iter = this.allObjectsToBeRemoved.iterator();
        while (iter.hasNext()) {
            broker.delete(iter.next());
        }
        this.allObjectsToBeRemoved.clear();
    }

    public Object remove(int index) {
        Object toBeRemoved = super.remove(index);
        this.registerForDeletion(toBeRemoved);
        return toBeRemoved;
    }

    protected void registerForDeletion(Object toBeRemoved) {
        if (!this.allObjectsToBeRemoved.contains(toBeRemoved)) {
            this.allObjectsToBeRemoved.add(toBeRemoved);
        }
    }

    public boolean remove(Object o) {
        boolean result = super.remove(o);
        this.registerForDeletion(o);
        return result;
    }

    public synchronized void removeAllElements() {
        for (int i = 0; i < this.size(); ++i) {
            this.registerForDeletion(this.get(i));
        }
        super.clear();
    }

    public synchronized void removeElementAt(int index) {
        Object toBeDeleted = this.get(index);
        this.registerForDeletion(toBeDeleted);
        super.remove(index);
    }

    public synchronized void clear() {
        this.removeAllElements();
    }

    protected void removeRange(int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            this.registerForDeletion(this.get(i));
        }
        super.removeRange(fromIndex, toIndex);
    }

    public void resetDeleted() {
        this.allObjectsToBeRemoved.clear();
    }
}

