/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class PersistentFieldBase
implements PersistentField {
    public static final String PATH_TOKEN = "::";
    private String fieldName;
    protected Class rootObjectType;
    static /* synthetic */ Class class$java$lang$Object;

    public PersistentFieldBase() {
    }

    public PersistentFieldBase(Class clazz, String fieldname) {
        this.rootObjectType = clazz;
        this.fieldName = fieldname;
    }

    protected abstract boolean makeAccessible();

    public String getName() {
        return this.fieldName;
    }

    public Class getDeclaringClass() {
        return this.rootObjectType;
    }

    protected List getFieldGraph(boolean makeAccessible) {
        ArrayList<Field> result = new ArrayList<Field>();
        String[] fields = StringUtils.split((String)this.getName(), (String)PATH_TOKEN);
        Field fld = null;
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i];
            try {
                fld = fld == null ? this.getFieldRecursive(this.rootObjectType, fieldName) : this.getFieldRecursive(fld.getType(), fieldName);
                if (makeAccessible) {
                    fld.setAccessible(true);
                }
            }
            catch (NoSuchFieldException e) {
                throw new MetadataException("Can't find member '" + fieldName + "' in class " + (fld != null ? fld.getDeclaringClass() : this.rootObjectType), e);
            }
            result.add(fld);
        }
        return result;
    }

    private Field getFieldRecursive(Class c, String name) throws NoSuchFieldException {
        try {
            Field f = c.getDeclaredField(name);
            return f;
        }
        catch (NoSuchFieldException e) {
            if (c == (class$java$lang$Object == null ? (class$java$lang$Object = PersistentFieldBase.class$("java.lang.Object")) : class$java$lang$Object) || c.getSuperclass() == null || c.isInterface()) {
                throw e;
            }
            return this.getFieldRecursive(c.getSuperclass(), name);
        }
    }

    protected Logger getLog() {
        return LoggerFactory.getLogger("PersistentField");
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this);
        buf.append("rootType", (Object)this.rootObjectType);
        buf.append("fieldName", (Object)this.fieldName);
        return buf.toString();
    }

    protected String buildMessageString(Object obj, Object value, Field aField) {
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer buf = new StringBuffer();
        buf.append(eol + "[try to set 'object value' in 'target object'").append(eol + "target obj class: " + (obj != null ? obj.getClass().getName() : null)).append(eol + "target field name: " + (aField != null ? aField.getName() : null)).append(eol + "target field type: " + (aField != null ? aField.getType() : null)).append(eol + "target field declared in: " + (aField != null ? aField.getDeclaringClass().getName() : null)).append(eol + "object value class: " + (value != null ? value.getClass().getName() : null)).append(eol + "object value: " + (value != null ? value : null)).append(eol + "]");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

