/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.metadata.AttributeContainer;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;

public class SequenceDescriptor
implements Serializable,
XmlCapable,
AttributeContainer {
    private static final long serialVersionUID = -5161713731380949398L;
    private JdbcConnectionDescriptor jcd;
    private Class sequenceManagerClass;
    private Properties configurationProperties;

    public SequenceDescriptor(JdbcConnectionDescriptor jcd) {
        this.jcd = jcd;
        this.configurationProperties = new Properties();
    }

    public SequenceDescriptor(JdbcConnectionDescriptor jcd, Class sequenceManagerClass) {
        this(jcd);
        this.sequenceManagerClass = sequenceManagerClass;
    }

    public JdbcConnectionDescriptor getJdbcConnectionDescriptor() {
        return this.jcd;
    }

    public void setJdbcConnectionDescriptor(JdbcConnectionDescriptor jcd) {
        this.jcd = jcd;
    }

    public Class getSequenceManagerClass() {
        return this.sequenceManagerClass;
    }

    public void setSequenceManagerClass(Class sequenceManagerClass) {
        this.sequenceManagerClass = sequenceManagerClass;
    }

    public void addAttribute(String attributeName, String attributeValue) {
        this.configurationProperties.setProperty(attributeName, attributeValue);
    }

    public String getAttribute(String key) {
        return this.getAttribute(key, null);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        String result = this.configurationProperties.getProperty(attributeName);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        buf.append("   sequenceManagerClass", (Object)this.getSequenceManagerClass()).append("   Properties", (Object)this.getConfigurationProperties());
        return buf.toString();
    }

    public String toXML() {
        RepositoryTags tags = RepositoryTags.getInstance();
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer buf = new StringBuffer(1024);
        buf.append("      ");
        buf.append(tags.getOpeningTagNonClosingById(88));
        buf.append(eol);
        buf.append("         ");
        buf.append(tags.getAttribute(89, "" + this.getSequenceManagerClass().getName()));
        buf.append("      >");
        buf.append(eol);
        buf.append("         <!-- ");
        buf.append(eol);
        buf.append("         Add sequence manger properties here, using custom attributes");
        buf.append(eol);
        buf.append("         e.g. <attribute attribute-name=\"grabSize\" attribute-value=\"20\"/>");
        buf.append(eol);
        buf.append("         -->");
        buf.append(eol);
        buf.append(this.buildAttributes());
        buf.append("      ");
        buf.append(tags.getClosingTagById(88));
        buf.append(eol);
        return buf.toString();
    }

    private String buildAttributes() {
        String eol = SystemUtils.LINE_SEPARATOR;
        Properties prop = this.getConfigurationProperties();
        if (prop == null || prop.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Enumeration<Object> en = prop.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = prop.getProperty(key);
            buf.append("         <attribute attribute-name=\"");
            buf.append(key);
            buf.append("\" attribute-value=\"");
            buf.append(value);
            buf.append("\"/>");
            buf.append(eol);
        }
        return buf.toString();
    }
}

