/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;

public class ObjectReferenceDescriptor
extends AttributeDescriptorBase
implements XmlCapable {
    private static final long serialVersionUID = 5561562217150972131L;
    public static final int CASCADE_NONE = 17;
    public static final int CASCADE_LINK = 19;
    public static final int CASCADE_OBJECT = 23;
    private Class m_ClassOfItems = null;
    private Vector m_ForeignKeyFields = new Vector();
    private boolean m_CascadeRetrieve = true;
    private int m_CascadeStore = 17;
    private int m_CascadeDelete = 17;
    private int m_ProxyPrefetchingLimit = 50;
    private Class m_ProxyOfItems = null;
    private boolean m_LookedUpProxy = false;
    private boolean m_OtmDependent = false;
    private Hashtable fkFieldMap = new Hashtable();
    private boolean lazy = false;
    private boolean refresh = false;

    public ObjectReferenceDescriptor(ClassDescriptor descriptor) {
        super(descriptor);
    }

    public Class getItemProxyClass() throws PersistenceBrokerException {
        if (!this.m_LookedUpProxy) {
            this.m_ProxyOfItems = this.getClassDescriptor().getRepository().getDescriptorFor(this.m_ClassOfItems).getProxyClass();
            this.m_LookedUpProxy = true;
        }
        return this.m_ProxyOfItems;
    }

    public FieldDescriptor[] getForeignKeyFieldDescriptors(ClassDescriptor mif) {
        Vector v;
        FieldDescriptor[] foreignKeyFieldDescriptors = null;
        foreignKeyFieldDescriptors = (FieldDescriptor[])this.fkFieldMap.get(mif);
        if (foreignKeyFieldDescriptors == null && (v = this.getForeignKeyFields()) != null) {
            if (mif.isInterface()) {
                Vector extents = mif.getExtentClasses();
                Class firstConcreteClass = (Class)extents.get(0);
                mif = this.getClassDescriptor().getRepository().getDescriptorFor(firstConcreteClass);
            }
            Vector<FieldDescriptor> ret = new Vector<FieldDescriptor>();
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                FieldDescriptor fkfd;
                Object fk = iter.next();
                if (fk instanceof Integer) {
                    Integer index = (Integer)fk;
                    fkfd = mif.getFieldDescriptorByIndex(index);
                } else {
                    fkfd = mif.getFieldDescriptorByName((String)fk);
                }
                if (fkfd == null) {
                    throw new OJBRuntimeException("Incorrect or not found field reference name '" + fk + "' in descriptor " + this + " for class-descriptor '" + mif.getClassNameOfObject() + "'");
                }
                ret.add(fkfd);
            }
            foreignKeyFieldDescriptors = ret.toArray(new FieldDescriptor[ret.size()]);
            this.fkFieldMap.put(mif, foreignKeyFieldDescriptors);
        }
        return foreignKeyFieldDescriptors;
    }

    public Object[] getForeignKeyValues(Object obj, ClassDescriptor mif) throws PersistenceBrokerException {
        FieldDescriptor[] fks = this.getForeignKeyFieldDescriptors(mif);
        if (fks.length > 0) {
            obj = ProxyHelper.getRealObject(obj);
        }
        Object[] result = new Object[fks.length];
        for (int i = 0; i < result.length; ++i) {
            Object val;
            FieldDescriptor fmd = fks[i];
            PersistentField f = fmd.getPersistentField();
            result[i] = val = f.get(obj);
        }
        return result;
    }

    public Class getItemClass() {
        return this.m_ClassOfItems;
    }

    public String getItemClassName() {
        return this.m_ClassOfItems != null ? this.m_ClassOfItems.getName() : null;
    }

    public void setItemClass(Class c) {
        this.m_ClassOfItems = c;
    }

    public Vector getForeignKeyFields() {
        return this.m_ForeignKeyFields;
    }

    public void setForeignKeyFields(Vector vec) {
        this.m_ForeignKeyFields = vec;
    }

    public void addForeignKeyField(int newId) {
        if (this.m_ForeignKeyFields == null) {
            this.m_ForeignKeyFields = new Vector();
        }
        this.m_ForeignKeyFields.add(new Integer(newId));
    }

    public void addForeignKeyField(String newField) {
        if (this.m_ForeignKeyFields == null) {
            this.m_ForeignKeyFields = new Vector();
        }
        this.m_ForeignKeyFields.add(newField);
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean getCascadeRetrieve() {
        return this.m_CascadeRetrieve;
    }

    public void setCascadeRetrieve(boolean b) {
        this.m_CascadeRetrieve = b;
    }

    public int getCascadingStore() {
        return this.m_CascadeStore;
    }

    public void setCascadingStore(int cascade) {
        this.m_CascadeStore = cascade;
    }

    public void setCascadingStore(String value) {
        this.setCascadingStore(this.getCascadeStoreValue(value));
    }

    public boolean getCascadeStore() {
        return this.getCascadingStore() == 23;
    }

    public void setCascadeStore(boolean cascade) {
        if (cascade) {
            this.setCascadingStore(this.getCascadeStoreValue("true"));
        } else {
            this.setCascadingStore(this.getCascadeStoreValue("false"));
        }
    }

    public int getCascadingDelete() {
        return this.m_CascadeDelete;
    }

    public void setCascadingDelete(int cascade) {
        this.m_CascadeDelete = cascade;
    }

    public void setCascadingDelete(String value) {
        this.setCascadingDelete(this.getCascadeDeleteValue(value));
    }

    public boolean getCascadeDelete() {
        return this.getCascadingDelete() == 23;
    }

    public void setCascadeDelete(boolean cascade) {
        if (cascade) {
            this.setCascadingDelete(this.getCascadeDeleteValue("true"));
        } else {
            this.setCascadingDelete(this.getCascadeDeleteValue("false"));
        }
    }

    protected int getCascadeStoreValue(String cascade) {
        if (cascade.equalsIgnoreCase("none")) {
            return 17;
        }
        if (cascade.equalsIgnoreCase("link")) {
            return 19;
        }
        if (cascade.equalsIgnoreCase("object")) {
            return 23;
        }
        if (cascade.equalsIgnoreCase("true")) {
            return 23;
        }
        if (cascade.equalsIgnoreCase("false")) {
            return 19;
        }
        throw new OJBRuntimeException("Invalid value! Given value was '" + cascade + "', expected values are: " + "none" + ", " + "link" + ", " + "object" + " ('false' and 'true' are deprecated but still valid)");
    }

    protected int getCascadeDeleteValue(String cascade) {
        if (cascade.equalsIgnoreCase("none")) {
            return 17;
        }
        if (cascade.equalsIgnoreCase("link")) {
            return 19;
        }
        if (cascade.equalsIgnoreCase("object")) {
            return 23;
        }
        if (cascade.equalsIgnoreCase("true")) {
            return 23;
        }
        if (cascade.equalsIgnoreCase("false")) {
            return 17;
        }
        throw new OJBRuntimeException("Invalid value! Given value was '" + cascade + "', expected values are: " + "none" + ", " + "link" + ", " + "object" + " ('false' and 'true' are deprecated but still valid)");
    }

    public String getCascadeAsString(int cascade) {
        String result = null;
        switch (cascade) {
            case 17: {
                result = "none";
                break;
            }
            case 19: {
                result = "link";
                break;
            }
            case 23: {
                result = "object";
            }
        }
        return result;
    }

    public int getProxyPrefetchingLimit() {
        return this.m_ProxyPrefetchingLimit;
    }

    public void setProxyPrefetchingLimit(int proxyPrefetchingLimit) {
        this.m_ProxyPrefetchingLimit = proxyPrefetchingLimit;
    }

    public boolean getOtmDependent() {
        return this.m_OtmDependent;
    }

    public void setOtmDependent(boolean b) {
        this.m_OtmDependent = b;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cascade_retrieve", this.getCascadeRetrieve()).append("cascade_store", (Object)this.getCascadeAsString(this.m_CascadeStore)).append("cascade_delete", (Object)this.getCascadeAsString(this.m_CascadeDelete)).append("is_lazy", this.lazy).append("class_of_Items", (Object)this.m_ClassOfItems).toString();
    }

    public String toXML() {
        RepositoryTags tags = RepositoryTags.getInstance();
        String eol = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer(1024);
        result.append("      ");
        result.append(tags.getOpeningTagNonClosingById(20));
        result.append(eol);
        String name = this.getAttributeName();
        if (name == null) {
            name = "super";
        }
        result.append("        ");
        result.append(tags.getAttribute(16, name));
        result.append(eol);
        result.append("        ");
        result.append(tags.getAttribute(22, this.getItemClassName()));
        result.append(eol);
        if (this.isLazy()) {
            result.append("        ");
            result.append(tags.getAttribute(48, "true"));
            result.append(eol);
            result.append("        ");
            result.append(tags.getAttribute(114, "" + this.getProxyPrefetchingLimit()));
            result.append(eol);
        }
        if (this.isRefresh()) {
            result.append("        ");
            result.append(tags.getAttribute(47, "true"));
            result.append(eol);
        }
        result.append("        ");
        result.append(tags.getAttribute(24, "" + this.getCascadeRetrieve()));
        result.append(eol);
        result.append("        ");
        result.append(tags.getAttribute(25, this.getCascadeAsString(this.getCascadingStore())));
        result.append(eol);
        result.append("        ");
        result.append(tags.getAttribute(26, this.getCascadeAsString(this.getCascadingDelete())));
        result.append(eol);
        if (this.getOtmDependent()) {
            result.append("        ");
            result.append(tags.getAttribute(102, "true"));
            result.append(eol);
        }
        result.append("      >");
        result.append(eol);
        for (int i = 0; i < this.getForeignKeyFields().size(); ++i) {
            Object obj = this.getForeignKeyFields().get(i);
            if (obj instanceof Integer) {
                String fkId = obj.toString();
                result.append("        ");
                result.append(tags.getOpeningTagNonClosingById(49));
                result.append(" ");
                result.append(tags.getAttribute(70, fkId));
                result.append("/>");
                result.append(eol);
                continue;
            }
            String fk = (String)obj;
            result.append("        ");
            result.append(tags.getOpeningTagNonClosingById(49));
            result.append(" ");
            result.append(tags.getAttribute(84, fk));
            result.append("/>");
            result.append(eol);
        }
        result.append("      ");
        result.append(tags.getClosingTagById(20));
        result.append(eol);
        return result.toString();
    }
}

