/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import javax.sql.DataSource;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.metadata.ConnectionPoolDescriptor;
import org.apache.ojb.broker.metadata.DescriptorBase;
import org.apache.ojb.broker.metadata.ObjectCacheDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.SequenceDescriptor;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class JdbcConnectionDescriptor
extends DescriptorBase
implements Serializable,
XmlCapable {
    private static final long serialVersionUID = -600900924512028960L;
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor == null ? (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor = JdbcConnectionDescriptor.class$("org.apache.ojb.broker.metadata.JdbcConnectionDescriptor")) : class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor);
    private String m_jcdAlias;
    private String m_Dbms;
    private String m_Driver;
    private String m_Protocol;
    private String m_SubProtocol;
    private String m_DbAlias;
    private String m_DatasourceName;
    private String m_UserName;
    private String m_Password;
    private double m_JdbcLevel = 2.0;
    private boolean m_eagerRelease = false;
    private boolean m_batchMode = false;
    private boolean defaultConnection = false;
    private int useAutoCommit = 1;
    private boolean ignoreAutoCommitExceptions = false;
    private PBKey pbKey;
    private ConnectionPoolDescriptor cpd = new ConnectionPoolDescriptor();
    private SequenceDescriptor sequenceDescriptor;
    private ObjectCacheDescriptor objectCacheDescriptor = new ObjectCacheDescriptor();
    private transient DataSource dataSource;
    public static final int AUTO_COMMIT_IGNORE_STATE = 0;
    public static final int AUTO_COMMIT_SET_TRUE_AND_TEMPORARY_FALSE = 1;
    public static final int AUTO_COMMIT_SET_FALSE = 2;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor;

    public ObjectCacheDescriptor getObjectCacheDescriptor() {
        return this.objectCacheDescriptor;
    }

    public void setObjectCacheDescriptor(ObjectCacheDescriptor objectCacheDescriptor) {
        this.objectCacheDescriptor = objectCacheDescriptor;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getJcdAlias() {
        return this.m_jcdAlias;
    }

    public void setJcdAlias(String jcdAlias) {
        this.clearPBKey();
        this.m_jcdAlias = jcdAlias;
    }

    public boolean isDefaultConnection() {
        return this.defaultConnection;
    }

    public boolean isDataSource() {
        return this.getDataSource() != null || this.getDatasourceName() != null;
    }

    public void setDefaultConnection(boolean defaultConnection) {
        this.defaultConnection = defaultConnection;
    }

    public SequenceDescriptor getSequenceDescriptor() {
        return this.sequenceDescriptor;
    }

    public void setSequenceDescriptor(SequenceDescriptor sequenceDescriptor) {
        this.sequenceDescriptor = sequenceDescriptor;
    }

    public ConnectionPoolDescriptor getConnectionPoolDescriptor() {
        return this.cpd;
    }

    public void setConnectionPoolDescriptor(ConnectionPoolDescriptor cpd) {
        this.cpd = cpd;
    }

    public PBKey getPBKey() {
        if (this.pbKey == null) {
            this.pbKey = new PBKey(this.getJcdAlias(), this.getUserName(), this.getPassWord());
        }
        return this.pbKey;
    }

    private void clearPBKey() {
        this.pbKey = null;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        buf.append("jcd-alias", (Object)this.m_jcdAlias).append("default-connection", this.defaultConnection).append("dbms", (Object)this.m_Dbms).append("jdbc-level", this.m_JdbcLevel).append("driver", (Object)this.m_Driver).append("protocol", (Object)this.m_Protocol).append("sub-protocol", (Object)this.m_SubProtocol).append("db-alias", (Object)this.m_DbAlias).append("user", (Object)this.m_UserName).append("password", (Object)"*****").append("eager-release", this.m_eagerRelease).append("ConnectionPoolDescriptor", (Object)this.cpd).append("batchMode", this.m_batchMode).append("useAutoCommit", (Object)JdbcConnectionDescriptor.getUseAutoCommitAsString(this.useAutoCommit)).append("ignoreAutoCommitExceptions", this.ignoreAutoCommitExceptions).append("sequenceDescriptor", (Object)this.sequenceDescriptor);
        return buf.toString();
    }

    public int getUseAutoCommit() {
        return this.useAutoCommit;
    }

    public void setUseAutoCommit(int useAutoCommit) {
        this.useAutoCommit = useAutoCommit;
    }

    public boolean isIgnoreAutoCommitExceptions() {
        return this.ignoreAutoCommitExceptions;
    }

    public void setIgnoreAutoCommitExceptions(boolean ignoreAutoCommitExceptions) {
        this.ignoreAutoCommitExceptions = ignoreAutoCommitExceptions;
    }

    public String getDbms() {
        return this.m_Dbms;
    }

    public void setDbms(String str) {
        this.m_Dbms = str;
    }

    public String getDriver() {
        return this.m_Driver;
    }

    public void setDriver(String str) {
        this.m_Driver = str;
    }

    public String getProtocol() {
        return this.m_Protocol;
    }

    public void setProtocol(String str) {
        this.m_Protocol = str;
    }

    public String getSubProtocol() {
        return this.m_SubProtocol;
    }

    public void setSubProtocol(String str) {
        this.m_SubProtocol = str;
    }

    public String getDbAlias() {
        return this.m_DbAlias;
    }

    public void setDbAlias(String str) {
        this.m_DbAlias = str;
    }

    public String getUserName() {
        return this.m_UserName;
    }

    public void setUserName(String str) {
        this.clearPBKey();
        this.m_UserName = str;
    }

    public String getPassWord() {
        return this.m_Password;
    }

    public void setPassWord(String str) {
        this.clearPBKey();
        this.m_Password = str;
    }

    public String getDatasourceName() {
        return this.m_DatasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.m_DatasourceName = datasourceName;
    }

    public double getJdbcLevel() {
        return this.m_JdbcLevel;
    }

    public void setJdbcLevel(String jdbcLevel) {
        if (jdbcLevel != null) {
            try {
                double intLevel = Double.parseDouble(jdbcLevel);
                this.setJdbcLevel(intLevel);
            }
            catch (NumberFormatException nfe) {
                this.setJdbcLevel(2.0);
                this.logger.info("Specified JDBC level was not numeric (Value=" + jdbcLevel + "), used default jdbc level of 2.0 ");
            }
        } else {
            this.setJdbcLevel(2.0);
            this.logger.info("Specified JDBC level was null, used default jdbc level of 2.0 ");
        }
    }

    public void setJdbcLevel(double jdbcLevel) {
        this.m_JdbcLevel = jdbcLevel;
    }

    public boolean getEagerRelease() {
        return this.m_eagerRelease;
    }

    public void setEagerRelease(boolean flag) {
        this.m_eagerRelease = flag;
    }

    public boolean getBatchMode() {
        return this.m_batchMode;
    }

    public void setBatchMode(boolean flag) {
        this.m_batchMode = flag;
    }

    public String toXML() {
        String dsn;
        String passwd;
        RepositoryTags tags = RepositoryTags.getInstance();
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer strReturn = new StringBuffer(1024);
        strReturn.append(eol);
        strReturn.append("  <!-- Descriptor for Connection ");
        strReturn.append(this.getProtocol());
        strReturn.append(":");
        strReturn.append(this.getSubProtocol());
        strReturn.append(":");
        strReturn.append(this.getDbAlias());
        strReturn.append(" -->");
        strReturn.append(eol);
        strReturn.append("  ");
        strReturn.append(tags.getOpeningTagNonClosingById(1));
        strReturn.append(eol);
        strReturn.append("    ");
        strReturn.append(tags.getAttribute(82, this.getJcdAlias()));
        strReturn.append(eol);
        strReturn.append("    ");
        strReturn.append(tags.getAttribute(80, "" + this.isDefaultConnection()));
        strReturn.append(eol);
        strReturn.append("    ");
        strReturn.append(tags.getAttribute(2, this.getDbms()));
        strReturn.append(eol);
        strReturn.append("    ");
        strReturn.append(tags.getAttribute(45, "" + this.getJdbcLevel()));
        strReturn.append(eol);
        String user = this.getUserName();
        if (user != null) {
            strReturn.append("    ");
            strReturn.append(tags.getAttribute(10, user));
            strReturn.append(eol);
        }
        if ((passwd = this.getPassWord()) != null) {
            strReturn.append("    ");
            strReturn.append(tags.getAttribute(11, passwd));
            strReturn.append(eol);
        }
        if ((dsn = this.getDatasourceName()) != null) {
            strReturn.append("    ");
            strReturn.append(tags.getAttribute(44, this.getDatasourceName()));
            strReturn.append(eol);
        } else {
            strReturn.append("    ");
            strReturn.append(tags.getAttribute(6, this.getDriver()));
            strReturn.append(eol);
            strReturn.append("    ");
            strReturn.append(tags.getAttribute(7, this.getProtocol()));
            strReturn.append(eol);
            strReturn.append("    ");
            strReturn.append(tags.getAttribute(8, this.getSubProtocol()));
            strReturn.append(eol);
            strReturn.append("    ");
            strReturn.append(JdbcConnectionDescriptor.encode(tags.getAttribute(9, this.getDbAlias())));
            strReturn.append(eol);
        }
        strReturn.append("    ");
        strReturn.append(tags.getAttribute(74, "" + this.getEagerRelease()));
        strReturn.append(eol);
        strReturn.append("    ");
        strReturn.append(tags.getAttribute(83, "" + this.getBatchMode()));
        strReturn.append(eol);
        strReturn.append("    ");
        strReturn.append(tags.getAttribute(90, "" + this.getUseAutoCommit()));
        strReturn.append(eol);
        strReturn.append("    ");
        strReturn.append(tags.getAttribute(91, "" + this.isIgnoreAutoCommitExceptions()));
        strReturn.append(eol);
        strReturn.append("  >");
        strReturn.append(eol);
        strReturn.append(eol);
        strReturn.append(this.getConnectionPoolDescriptor().toXML());
        strReturn.append(eol);
        if (this.getSequenceDescriptor() != null) {
            strReturn.append(this.getSequenceDescriptor().toXML());
        }
        strReturn.append(eol);
        strReturn.append("  ");
        strReturn.append(tags.getClosingTagById(1));
        strReturn.append(eol);
        return strReturn.toString();
    }

    private static String encode(String toBeEncoded) {
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < toBeEncoded.length(); ++i) {
            char c = toBeEncoded.charAt(i);
            if (c == '<') {
                retval.append("&lt;");
                continue;
            }
            if (c == '>') {
                retval.append("&gt;");
                continue;
            }
            if (c == '&') {
                retval.append("&amp;");
                continue;
            }
            if (c == ' ') {
                retval.append("&nbsp;");
                continue;
            }
            retval.append(c);
        }
        return retval.toString();
    }

    private static String getUseAutoCommitAsString(int state) {
        switch (state) {
            case 1: {
                return "AUTO_COMMIT_SET_TRUE_AND_TEMPORARY_FALSE";
            }
            case 2: {
                return "AUTO_COMMIT_SET_FALSE";
            }
            case 0: {
                return "AUTO_COMMIT_IGNORE_STATE";
            }
        }
        return "UNKOWN_STATE";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

