/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.metadata.FieldType;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.metadata.JdbcTypesHelper;

class FieldTypeClasses {
    private FieldTypeClasses() {
    }

    static FieldType newFieldType(JdbcType jdbcType) {
        BaseFieldType result = null;
        switch (jdbcType.getType()) {
            case 2003: {
                result = new ArrayFieldType();
                break;
            }
            case -5: {
                result = new LongFieldType();
                break;
            }
            case -2: {
                result = new ByteArrayFieldType();
                break;
            }
            case -7: {
                result = new BooleanFieldType();
                break;
            }
            case 2004: {
                result = new BlobFieldType();
                break;
            }
            case 1: {
                result = new StringFieldType();
                break;
            }
            case 2005: {
                result = new ClobFieldType();
                break;
            }
            case 91: {
                result = new DateFieldType();
                break;
            }
            case 3: {
                result = new BigDecimalFieldType();
                break;
            }
            case 8: {
                result = new DoubleFieldType();
                break;
            }
            case 6: {
                result = new FloatFieldType();
                break;
            }
            case 4: {
                result = new IntegerFieldType();
                break;
            }
            case 2000: {
                result = new JavaObjectFieldType();
                break;
            }
            case -4: {
                result = new ByteArrayFieldType();
                break;
            }
            case -1: {
                result = new StringFieldType();
                break;
            }
            case 2: {
                result = new BigDecimalFieldType();
                break;
            }
            case 7: {
                result = new FloatFieldType();
                break;
            }
            case 2006: {
                result = new RefFieldType();
                break;
            }
            case 5: {
                result = new ShortFieldType();
                break;
            }
            case 2002: {
                result = new StructFieldType();
                break;
            }
            case 92: {
                result = new TimeFieldType();
                break;
            }
            case 93: {
                result = new TimestampFieldType();
                break;
            }
            case -6: {
                result = new ByteFieldType();
                break;
            }
            case -3: {
                result = new ByteArrayFieldType();
                break;
            }
            case 12: {
                result = new StringFieldType();
                break;
            }
            case 1111: {
                result = new JavaObjectFieldType();
                break;
            }
            case 16: {
                result = new BooleanFieldType();
                break;
            }
            case 70: {
                result = new URLFieldType();
                break;
            }
            default: {
                throw new OJBRuntimeException("Unkown or not supported field type specified, specified jdbc type was '" + jdbcType + "', as string: " + JdbcTypesHelper.getSqlTypeAsString(jdbcType.getType()));
            }
        }
        result.setSqlType(jdbcType);
        return result;
    }

    public static class URLFieldType
    extends ImmutableFieldType {
    }

    public static class DoubleFieldType
    extends ImmutableFieldType {
    }

    public static class FloatFieldType
    extends ImmutableFieldType {
    }

    public static class LongFieldType
    extends ImmutableFieldType {
    }

    public static class IntegerFieldType
    extends ImmutableFieldType {
    }

    public static class ShortFieldType
    extends ImmutableFieldType {
    }

    public static class ByteFieldType
    extends ImmutableFieldType {
    }

    public static class BooleanFieldType
    extends ImmutableFieldType {
    }

    public static class BigDecimalFieldType
    extends ImmutableFieldType {
    }

    public static class StringFieldType
    extends ImmutableFieldType {
    }

    public static class TimestampFieldType
    extends MutableFieldType {
        public Object copy(Object fieldValue) {
            Timestamp result = null;
            if (fieldValue != null) {
                Timestamp source = (Timestamp)fieldValue;
                result = (Timestamp)source.clone();
            }
            return result;
        }
    }

    public static class TimeFieldType
    extends MutableFieldType {
        public Object copy(Object fieldValue) {
            Time source = (Time)fieldValue;
            return source != null ? new Time(source.getTime()) : null;
        }
    }

    public static class DateFieldType
    extends MutableFieldType {
        public Object copy(Object fieldValue) {
            Date source = (Date)fieldValue;
            return source != null ? new Date(source.getTime()) : null;
        }
    }

    public static class ByteArrayFieldType
    extends MutableFieldType {
        public Object copy(Object fieldValue) {
            byte[] result = null;
            if (fieldValue != null) {
                byte[] source = (byte[])fieldValue;
                int length = source.length;
                result = new byte[length];
                System.arraycopy(fieldValue, 0, result, 0, length);
            }
            return result;
        }

        public boolean equals(Object firstValue, Object secondValue) {
            return Arrays.equals((byte[])firstValue, (byte[])secondValue);
        }
    }

    public static class JavaObjectFieldType
    extends MutableFieldType {
        public Object copy(Object fieldValue) {
            if (fieldValue == null) {
                return null;
            }
            Object copy = this.copyIfCloneable(fieldValue);
            if (copy == null) {
                copy = this.copyIfSerializeable(fieldValue);
            }
            return copy == null ? fieldValue : copy;
        }
    }

    public static class StructFieldType
    extends MutableFieldType {
        public Object copy(Object fieldValue) {
            if (fieldValue == null) {
                return null;
            }
            Object copy = this.copyIfCloneable(fieldValue);
            if (copy == null) {
                copy = this.copyIfSerializeable(fieldValue);
            }
            return copy == null ? fieldValue : copy;
        }
    }

    public static class RefFieldType
    extends ImmutableFieldType {
    }

    public static class ArrayFieldType
    extends ImmutableFieldType {
    }

    public static class BlobFieldType
    extends ImmutableFieldType {
    }

    public static class ClobFieldType
    extends ImmutableFieldType {
    }

    static abstract class MutableFieldType
    extends BaseFieldType {
        MutableFieldType() {
        }

        public boolean isMutable() {
            return true;
        }

        public boolean equals(Object firstValue, Object secondValue) {
            return ObjectUtils.equals((Object)firstValue, (Object)secondValue);
        }
    }

    static abstract class ImmutableFieldType
    extends BaseFieldType {
        ImmutableFieldType() {
        }

        public boolean isMutable() {
            return false;
        }

        public Object copy(Object source) {
            return source;
        }

        public boolean equals(Object firstValue, Object secondValue) {
            return ObjectUtils.equals((Object)firstValue, (Object)secondValue);
        }
    }

    static abstract class BaseFieldType
    implements FieldType {
        int sqlType;

        BaseFieldType() {
        }

        public void setSqlType(JdbcType jdbcType) {
            this.sqlType = jdbcType.getType();
        }

        public int getSqlType() {
            return this.sqlType;
        }

        Object copyIfCloneable(Object toCopy) {
            Object result = null;
            if (toCopy instanceof Cloneable) {
                try {
                    Method m = toCopy.getClass().getMethod("clone", ArrayUtils.EMPTY_CLASS_ARRAY);
                    result = m.invoke(toCopy, null);
                }
                catch (Exception e) {
                    throw new OJBRuntimeException("Can't invoke method 'clone' on object: " + toCopy, e);
                }
            }
            return result;
        }

        Object copyIfSerializeable(Object toCopy) {
            Object result = null;
            if (toCopy instanceof Serializable) {
                result = SerializationUtils.clone((Serializable)((Serializable)toCopy));
            }
            return result;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("sqlType", this.sqlType).append("sqlTypeAsString", (Object)JdbcTypesHelper.getSqlTypeAsString(this.sqlType)).append("isMutable", this.isMutable()).toString();
        }
    }
}

