/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ojb.broker.metadata.AttributeContainer;

class DescriptorBase
implements AttributeContainer,
Serializable {
    static final long serialVersionUID = 713914612744155925L;
    private Map attributeMap = null;

    public void addAttribute(String attributeName, String attributeValue) {
        if (attributeName == null) {
            return;
        }
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap();
        }
        this.attributeMap.put(attributeName, attributeValue);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        String result = defaultValue;
        if (this.attributeMap != null && (result = (String)this.attributeMap.get(attributeName)) == null) {
            result = defaultValue;
        }
        return result;
    }

    public String getAttribute(String attributeName) {
        return this.getAttribute(attributeName, null);
    }

    public Map getAttributes() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    public String[] getAttributeNames() {
        Set<Object> keys = this.attributeMap == null ? new HashSet() : this.attributeMap.keySet();
        String[] result = new String[keys.size()];
        keys.toArray(result);
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("custom attributes [");
        buf.append(this.attributeMap);
        buf.append("]");
        return buf.toString();
    }
}

