/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import org.apache.commons.lang.SystemUtils;
import org.apache.commons.transaction.locking.LockException;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.ojb.broker.locking.CommonsOJBLockManager;
import org.apache.ojb.broker.locking.LockManager;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class LockManagerCommonsImpl
implements LockManager {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$locking$LockManagerCommonsImpl == null ? (class$org$apache$ojb$broker$locking$LockManagerCommonsImpl = LockManagerCommonsImpl.class$("org.apache.ojb.broker.locking.LockManagerCommonsImpl")) : class$org$apache$ojb$broker$locking$LockManagerCommonsImpl);
    private long lockTimeout = 60000L;
    private long blockTimeout = 1000L;
    private LoggerFacade logFacade = new LoggerFacadeImpl();
    private OJBLockManager lm = new OJBLockManager(this.logFacade, this.blockTimeout, 500L);
    static /* synthetic */ Class class$org$apache$ojb$broker$locking$LockManagerCommonsImpl;

    private boolean ignore(int isolationLevel) {
        return isolationLevel == 4 || isolationLevel == -1;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(long timeout) {
        this.lockTimeout = timeout;
    }

    public long getBlockTimeout() {
        return this.blockTimeout;
    }

    public void setBlockTimeout(long blockTimeout) {
        this.blockTimeout = blockTimeout;
    }

    public String getLockInfo() {
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer msg = new StringBuffer("Class: " + (class$org$apache$ojb$broker$locking$LockManagerCommonsImpl == null ? (class$org$apache$ojb$broker$locking$LockManagerCommonsImpl = LockManagerCommonsImpl.class$("org.apache.ojb.broker.locking.LockManagerCommonsImpl")) : class$org$apache$ojb$broker$locking$LockManagerCommonsImpl).getName() + eol);
        msg.append("lock timeout: " + this.getLockTimeout() + " [ms]" + eol);
        msg.append("block timeout: " + this.getBlockTimeout() + " [ms]" + eol);
        msg.append("commons-tx lock-manger info ==> " + eol);
        msg.append((Object)this.lm);
        return msg.toString();
    }

    public boolean readLock(Object key, Object resourceId, int isolationLevel) {
        return this.ignore(isolationLevel) ? true : this.lm.readLock(key, resourceId, new Integer(isolationLevel), this.blockTimeout);
    }

    public boolean writeLock(Object key, Object resourceId, int isolationLevel) {
        return this.ignore(isolationLevel) ? true : this.lm.writeLock(key, resourceId, new Integer(isolationLevel), this.blockTimeout);
    }

    public boolean upgradeLock(Object key, Object resourceId, int isolationLevel) {
        return this.ignore(isolationLevel) ? true : this.lm.upgradeLock(key, resourceId, new Integer(isolationLevel), this.blockTimeout);
    }

    public boolean releaseLock(Object key, Object resourceId) {
        boolean result = true;
        try {
            this.lm.release(key, resourceId);
        }
        catch (RuntimeException e) {
            this.log.error("Can't release lock for owner key " + key + ", on resource " + resourceId, e);
            result = false;
        }
        return result;
    }

    public void releaseLocks(Object key) {
        try {
            this.lm.releaseAll(key);
        }
        catch (RuntimeException e) {
            this.log.error("Can't release all locks for owner key " + key, e);
        }
    }

    public boolean hasRead(Object key, Object resourceId) {
        return this.lm.hasRead(key, resourceId);
    }

    public boolean hasWrite(Object key, Object resourceId) {
        return this.lm.hasWrite(key, resourceId);
    }

    public boolean hasUpgrade(Object key, Object resourceId) {
        return this.lm.hasUpgrade(key, resourceId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class LoggerFacadeImpl
    implements LoggerFacade {
        LoggerFacadeImpl() {
        }

        public LoggerFacade createLogger(String name) {
            return this;
        }

        public void logInfo(String message) {
            LockManagerCommonsImpl.this.log.info(message);
        }

        public void logFine(String message) {
            LockManagerCommonsImpl.this.log.debug(message);
        }

        public boolean isFineEnabled() {
            return LockManagerCommonsImpl.this.log.isDebugEnabled();
        }

        public void logFiner(String message) {
            LockManagerCommonsImpl.this.log.debug(message);
        }

        public boolean isFinerEnabled() {
            return LockManagerCommonsImpl.this.log.isDebugEnabled();
        }

        public void logFinest(String message) {
            LockManagerCommonsImpl.this.log.debug(message);
        }

        public boolean isFinestEnabled() {
            return LockManagerCommonsImpl.this.log.isDebugEnabled();
        }

        public void logWarning(String message) {
            LockManagerCommonsImpl.this.log.warn(message);
        }

        public void logWarning(String message, Throwable t) {
            LockManagerCommonsImpl.this.log.warn(message, t);
        }

        public void logSevere(String message) {
            LockManagerCommonsImpl.this.log.error(message);
        }

        public void logSevere(String message, Throwable t) {
            LockManagerCommonsImpl.this.log.error(message, t);
        }
    }

    final class OJBLockManager
    extends CommonsOJBLockManager {
        public OJBLockManager(LoggerFacade logger, long timeoutMSecs, long checkThreshholdMSecs) throws IllegalArgumentException {
            super(logger, timeoutMSecs, checkThreshholdMSecs);
        }

        private CommonsOJBLockManager.OJBLock lookupLock(Object resourceId) {
            return (CommonsOJBLockManager.OJBLock)this.getLock(resourceId);
        }

        boolean readLock(Object key, Object resourceId, Integer isolationLevel, long timeout) {
            int lockLevel = this.mapLockLevelDependendOnIsolationLevel(isolationLevel, 101);
            return this.tryLock(key, resourceId, lockLevel, true, isolationLevel);
        }

        boolean writeLock(Object key, Object resourceId, Integer isolationLevel, long timeout) {
            try {
                int lockLevel = this.mapLockLevelDependendOnIsolationLevel(isolationLevel, 107);
                this.lock(key, resourceId, lockLevel, 1, false, timeout, isolationLevel);
                return true;
            }
            catch (LockException e) {
                if (LockManagerCommonsImpl.this.log.isEnabledFor(2)) {
                    LockManagerCommonsImpl.this.log.info("Can't get write lock for " + key, e);
                }
                return false;
            }
        }

        boolean upgradeLock(Object key, Object resourceId, Integer isolationLevel, long timeout) {
            try {
                int lockLevel = this.mapLockLevelDependendOnIsolationLevel(isolationLevel, 113);
                this.lock(key, resourceId, lockLevel, 1, false, timeout, isolationLevel);
                return true;
            }
            catch (LockException e) {
                if (LockManagerCommonsImpl.this.log.isEnabledFor(2)) {
                    LockManagerCommonsImpl.this.log.info("Can't get upgrade lock for " + key, e);
                }
                return false;
            }
        }

        boolean hasRead(Object key, Object resourceId) {
            CommonsOJBLockManager.OJBLock lock = this.lookupLock(resourceId);
            boolean result = false;
            if (lock != null) {
                result = lock.hasRead(key);
            }
            return result;
        }

        boolean hasWrite(Object key, Object resourceId) {
            CommonsOJBLockManager.OJBLock lock = this.lookupLock(resourceId);
            boolean result = false;
            if (lock != null) {
                result = lock.hasWrite(key);
            }
            return result;
        }

        boolean hasUpgrade(Object key, Object resourceId) {
            CommonsOJBLockManager.OJBLock lock = this.lookupLock(resourceId);
            boolean result = false;
            if (lock != null) {
                result = lock.hasUpgrade(key);
            }
            return result;
        }
    }
}

