/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class LockHelper {
    LockHelper() {
    }

    public static int getIsolationLevelFor(String isoLevel) {
        if (isoLevel == null || StringUtils.isEmpty((String)isoLevel)) {
            LoggerFactory.getDefaultLogger().debug("[LockHelper] Specified isolation level string is 'null', using the default isolation level");
            return 2;
        }
        if (isoLevel.equalsIgnoreCase("read-uncommitted")) {
            return 2;
        }
        if (isoLevel.equalsIgnoreCase("read-committed")) {
            return 3;
        }
        if (isoLevel.equalsIgnoreCase("repeatable-read")) {
            return 5;
        }
        if (isoLevel.equalsIgnoreCase("serializable")) {
            return 7;
        }
        if (isoLevel.equalsIgnoreCase("optimistic")) {
            return 4;
        }
        if (isoLevel.equalsIgnoreCase("none")) {
            return -1;
        }
        LoggerFactory.getDefaultLogger().warn("[LockHelper] Unknown isolation-level '" + isoLevel + "', using default isolation level");
        return 2;
    }
}

