/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import java.util.Map;
import org.apache.commons.transaction.locking.GenericLock;
import org.apache.commons.transaction.locking.GenericLockManager;
import org.apache.commons.transaction.locking.LockException;
import org.apache.commons.transaction.locking.MultiLevelLock;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.ojb.broker.locking.LockRuntimeException;

public class CommonsOJBLockManager
extends GenericLockManager {
    static final int COMMON_READ_LOCK = 101;
    static final int COMMON_WRITE_LOCK = 107;
    static final int COMMON_UPGRADE_LOCK = 113;

    public CommonsOJBLockManager(LoggerFacade logger, long timeoutMSecs, long checkThreshholdMSecs) throws IllegalArgumentException {
        super(1, logger, timeoutMSecs, checkThreshholdMSecs);
    }

    public boolean tryLock(Object ownerId, Object resourceId, int targetLockLevel, boolean reentrant) {
        return this.tryLock(ownerId, resourceId, targetLockLevel, reentrant, null);
    }

    public boolean tryLock(Object ownerId, Object resourceId, int targetLockLevel, boolean reentrant, Object isolationId) {
        this.timeoutCheck(ownerId);
        OJBLock lock = this.atomicGetOrCreateLock(resourceId, isolationId);
        boolean acquired = lock.tryLock(ownerId, targetLockLevel, reentrant ? 1 : 0, false);
        if (acquired) {
            this.addOwner(ownerId, lock);
        }
        return acquired;
    }

    public void lock(Object ownerId, Object resourceId, int targetLockLevel, int compatibility, boolean preferred, long timeoutMSecs) throws LockException {
        this.lock(ownerId, resourceId, targetLockLevel, compatibility, preferred, timeoutMSecs, null);
    }

    public void lock(Object ownerId, Object resourceId, int targetLockLevel, int compatibility, boolean preferred, long timeoutMSecs, Object isolationId) throws LockException {
        this.timeoutCheck(ownerId);
        OJBLock lock = this.atomicGetOrCreateLock(resourceId, isolationId);
        super.doLock((GenericLock)lock, ownerId, resourceId, targetLockLevel, compatibility, preferred, timeoutMSecs);
    }

    public MultiLevelLock atomicGetOrCreateLock(Object resourceId) {
        return this.atomicGetOrCreateLock(resourceId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OJBLock atomicGetOrCreateLock(Object resourceId, Object isolationId) {
        Map map = this.globalLocks;
        synchronized (map) {
            MultiLevelLock lock = this.getLock(resourceId);
            if (lock == null) {
                lock = this.createLock(resourceId, isolationId);
            }
            return (OJBLock)lock;
        }
    }

    protected GenericLock createLock(Object resourceId) {
        return this.createLock(resourceId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GenericLock createLock(Object resourceId, Object isolationId) {
        Map map = this.globalLocks;
        synchronized (map) {
            if (isolationId != null) {
                OJBLock lock = this.createIsolationLevel(resourceId, isolationId, this.logger);
                this.globalLocks.put(resourceId, lock);
                return lock;
            }
            GenericLock lock = new GenericLock(resourceId, this.maxLockLevel, this.logger);
            this.globalLocks.put(resourceId, lock);
            return lock;
        }
    }

    public OJBLock createIsolationLevel(Object resourceId, Object isolationId, LoggerFacade logger) {
        RepeadableReadsLock result = null;
        switch ((Integer)isolationId) {
            case 2: {
                result = new ReadUncommittedLock(resourceId, logger);
                break;
            }
            case 3: {
                result = new ReadCommitedLock(resourceId, logger);
                break;
            }
            case 5: {
                result = new RepeadableReadsLock(resourceId, logger);
                break;
            }
            case 7: {
                result = new SerializeableLock(resourceId, logger);
                break;
            }
            case 4: {
                throw new LockRuntimeException("Optimistic locking must be handled on top of this class");
            }
            default: {
                throw new LockRuntimeException("Unknown lock isolation level specified");
            }
        }
        return result;
    }

    int mapLockLevelDependendOnIsolationLevel(Integer isolationId, int lockLevel) {
        int result = 0;
        switch (isolationId) {
            case 2: {
                result = ReadUncommittedLock.mapLockLevel(lockLevel);
                break;
            }
            case 3: {
                result = ReadCommitedLock.mapLockLevel(lockLevel);
                break;
            }
            case 5: {
                result = RepeadableReadsLock.mapLockLevel(lockLevel);
                break;
            }
            case 7: {
                result = SerializeableLock.mapLockLevel(lockLevel);
                break;
            }
            case 4: {
                throw new LockRuntimeException("Optimistic locking must be handled on top of this class");
            }
            default: {
                throw new LockRuntimeException("Unknown lock isolation level specified");
            }
        }
        return result;
    }

    static final class SerializeableLock
    extends ReadUncommittedLock {
        public SerializeableLock(Object resourceId, LoggerFacade logger) {
            super(resourceId, logger);
        }

        protected boolean isCompatible(int targetLockLevel, int currentLockLevel) {
            return currentLockLevel <= 0;
        }
    }

    static class RepeadableReadsLock
    extends OJBLock {
        static final int NO_LOCK = 0;
        static final int READ_LOCK = 1;
        static final int UPGRADE_LOCK = 2;
        static final int WRITE_LOCK = 3;

        public RepeadableReadsLock(Object resourceId, LoggerFacade logger) {
            super(resourceId, 3, logger);
        }

        static int mapLockLevel(int commonLockLevel) {
            int result = 0;
            switch (commonLockLevel) {
                case 101: {
                    result = 1;
                    break;
                }
                case 113: {
                    result = 2;
                    break;
                }
                case 107: {
                    result = 3;
                    break;
                }
                default: {
                    throw new LockRuntimeException("Unknown common lock type: " + commonLockLevel);
                }
            }
            return result;
        }

        public boolean readLock(Object ownerId, long timeout) throws InterruptedException {
            return this.acquire(ownerId, 1, false, 1, false, timeout);
        }

        public boolean writeLock(Object ownerId, long timeout) throws InterruptedException {
            return this.acquire(ownerId, 3, true, 1, false, timeout);
        }

        public boolean upgradeLock(Object ownerId, long timeout) throws InterruptedException {
            return this.acquire(ownerId, 2, true, 1, true, timeout);
        }

        public boolean hasRead(Object ownerId) {
            return this.has(ownerId, 1);
        }

        public boolean hasWrite(Object ownerId) {
            return this.has(ownerId, 3);
        }

        public boolean hasUpgrade(Object ownerId) {
            return this.has(ownerId, 2);
        }
    }

    static final class ReadCommitedLock
    extends RepeadableReadsLock {
        public ReadCommitedLock(Object resourceId, LoggerFacade logger) {
            super(resourceId, logger);
        }

        protected boolean isCompatible(int targetLockLevel, int currentLockLevel) {
            if (currentLockLevel == 1) {
                return true;
            }
            return super.isCompatible(targetLockLevel, currentLockLevel);
        }
    }

    static class ReadUncommittedLock
    extends RepeadableReadsLock {
        public ReadUncommittedLock(Object resourceId, LoggerFacade logger) {
            super(resourceId, logger);
        }

        protected boolean isCompatible(int targetLockLevel, int currentLockLevel) {
            if (currentLockLevel == 1 || targetLockLevel == 1) {
                return true;
            }
            return super.isCompatible(targetLockLevel, currentLockLevel);
        }
    }

    static abstract class OJBLock
    extends GenericLock {
        public OJBLock(Object resourceId, int maxLockLevel, LoggerFacade logger) {
            super(resourceId, maxLockLevel, logger);
        }

        protected boolean tryLock(Object ownerId, int targetLockLevel, int compatibility, boolean preferred) {
            return super.tryLock(ownerId, targetLockLevel, compatibility, preferred);
        }

        abstract boolean hasRead(Object var1);

        abstract boolean hasWrite(Object var1);

        abstract boolean hasUpgrade(Object var1);

        abstract boolean readLock(Object var1, long var2) throws InterruptedException;

        abstract boolean writeLock(Object var1, long var2) throws InterruptedException;

        abstract boolean upgradeLock(Object var1, long var2) throws InterruptedException;
    }
}

