/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.lang.reflect.Proxy;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.VirtualProxy;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ProxyHelper {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$proxy$ProxyHelper == null ? (class$org$apache$ojb$broker$core$proxy$ProxyHelper = ProxyHelper.class$("org.apache.ojb.broker.core.proxy.ProxyHelper")) : class$org$apache$ojb$broker$core$proxy$ProxyHelper);
    static /* synthetic */ Class class$org$apache$ojb$broker$core$proxy$ProxyHelper;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$proxy$IndirectionHandler;

    public static final Object getRealObject(Object objectOrProxy) {
        if (ProxyHelper.isNormalOjbProxy(objectOrProxy)) {
            try {
                return ((IndirectionHandler)Proxy.getInvocationHandler(objectOrProxy)).getRealSubject();
            }
            catch (ClassCastException e) {
                String msg = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = ProxyHelper.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).getName();
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (IllegalArgumentException e) {
                String msg = "Could not retrieve real object for given Proxy: " + objectOrProxy;
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (PersistenceBrokerException e) {
                log.error("Could not retrieve real object for given Proxy: " + objectOrProxy);
                throw e;
            }
        }
        if (ProxyHelper.isVirtualOjbProxy(objectOrProxy)) {
            try {
                return ((VirtualProxy)objectOrProxy).getRealSubject();
            }
            catch (PersistenceBrokerException e) {
                log.error("Could not retrieve real object for VirtualProxy: " + objectOrProxy);
                throw e;
            }
        }
        return objectOrProxy;
    }

    public static final Object getRealObjectIfMaterialized(Object objectOrProxy) {
        if (ProxyHelper.isNormalOjbProxy(objectOrProxy)) {
            try {
                IndirectionHandler handler = (IndirectionHandler)Proxy.getInvocationHandler(objectOrProxy);
                return handler.alreadyMaterialized() ? handler.getRealSubject() : null;
            }
            catch (ClassCastException e) {
                String msg = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = ProxyHelper.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).getName();
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (IllegalArgumentException e) {
                String msg = "Could not retrieve real object for given Proxy: " + objectOrProxy;
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (PersistenceBrokerException e) {
                log.error("Could not retrieve real object for given Proxy: " + objectOrProxy);
                throw e;
            }
        }
        if (ProxyHelper.isVirtualOjbProxy(objectOrProxy)) {
            try {
                VirtualProxy proxy = (VirtualProxy)objectOrProxy;
                return proxy.alreadyMaterialized() ? proxy.getRealSubject() : null;
            }
            catch (PersistenceBrokerException e) {
                log.error("Could not retrieve real object for VirtualProxy: " + objectOrProxy);
                throw e;
            }
        }
        return objectOrProxy;
    }

    public static final Class getRealClass(Object objectOrProxy) {
        if (ProxyHelper.isNormalOjbProxy(objectOrProxy)) {
            try {
                IndirectionHandler handler = (IndirectionHandler)Proxy.getInvocationHandler(objectOrProxy);
                return handler.getIdentity().getObjectsRealClass();
            }
            catch (ClassCastException e) {
                String msg = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = ProxyHelper.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).getName();
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (IllegalArgumentException e) {
                String msg = "Could not retrieve real object for given Proxy: " + objectOrProxy;
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
        }
        if (ProxyHelper.isVirtualOjbProxy(objectOrProxy)) {
            IndirectionHandler handler = VirtualProxy.getIndirectionHandler((VirtualProxy)objectOrProxy);
            return handler.getIdentity().getObjectsRealClass();
        }
        return objectOrProxy.getClass();
    }

    public static boolean isNormalOjbProxy(Object proxyOrObject) {
        return proxyOrObject instanceof Proxy && Proxy.isProxyClass(proxyOrObject.getClass()) && Proxy.getInvocationHandler(proxyOrObject) instanceof IndirectionHandler;
    }

    public static boolean isVirtualOjbProxy(Object proxyOrObject) {
        return proxyOrObject instanceof VirtualProxy;
    }

    public static boolean isProxy(Object proxyOrObject) {
        return ProxyHelper.isNormalOjbProxy(proxyOrObject) || ProxyHelper.isVirtualOjbProxy(proxyOrObject);
    }

    public static IndirectionHandler getIndirectionHandler(Object obj) {
        if (obj == null) {
            return null;
        }
        if (ProxyHelper.isNormalOjbProxy(obj)) {
            return (IndirectionHandler)Proxy.getInvocationHandler(obj);
        }
        if (ProxyHelper.isVirtualOjbProxy(obj)) {
            return VirtualProxy.getIndirectionHandler((VirtualProxy)obj);
        }
        return null;
    }

    public static boolean isMaterialized(Object object) {
        IndirectionHandler handler = ProxyHelper.getIndirectionHandler(object);
        return handler == null ? true : handler.alreadyMaterialized();
    }

    public static String toString(Object object) {
        IndirectionHandler handler = ProxyHelper.getIndirectionHandler(object);
        if (handler != null && handler.alreadyMaterialized()) {
            return "unmaterialized proxy for " + handler.getIdentity();
        }
        return object.toString();
    }

    public static CollectionProxy getCollectionProxy(Object item) {
        if (ProxyHelper.isCollectionProxy(item)) {
            return (CollectionProxy)item;
        }
        return null;
    }

    public static boolean isCollectionProxy(Object item) {
        return item instanceof CollectionProxy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

