/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.ObjectUtils;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.IdentityFactory;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.MtoNImplementor;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PBState;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.TransactionInProgressException;
import org.apache.ojb.broker.TransactionNotInProgressException;
import org.apache.ojb.broker.accesslayer.ChainingIterator;
import org.apache.ojb.broker.accesslayer.ConnectionManagerFactory;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.accesslayer.JdbcAccessFactory;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.accesslayer.PagingIterator;
import org.apache.ojb.broker.accesslayer.PkEnumeration;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcherFactory;
import org.apache.ojb.broker.accesslayer.StatementManagerFactory;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.accesslayer.sql.SqlGenerator;
import org.apache.ojb.broker.accesslayer.sql.SqlGeneratorFactory;
import org.apache.ojb.broker.cache.MaterializationCache;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheFactory;
import org.apache.ojb.broker.core.IdentityFactoryImpl;
import org.apache.ojb.broker.core.MtoNBroker;
import org.apache.ojb.broker.core.PersistenceBrokerAbstractImpl;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryIF;
import org.apache.ojb.broker.core.QueryReferenceBroker;
import org.apache.ojb.broker.core.ReportRsIteratorFactoryImpl;
import org.apache.ojb.broker.core.RsIteratorFactory;
import org.apache.ojb.broker.core.RsIteratorFactoryImpl;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.QueryByIdentity;
import org.apache.ojb.broker.query.QueryBySQL;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.IdentityArrayList;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerFactory;
import org.apache.ojb.soda.QueryImpl;
import org.odbms.Query;

public class PersistenceBrokerImpl
extends PersistenceBrokerAbstractImpl
implements PBState {
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerImpl = PersistenceBrokerImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerImpl);
    protected PersistenceBrokerFactoryIF pbf;
    protected BrokerHelper brokerHelper;
    protected MtoNBroker mtoNBroker;
    protected QueryReferenceBroker referencesBroker;
    private boolean isClosed;
    private boolean inTransaction;
    private MaterializationCache objectCache;
    private JdbcAccess dbAccess;
    private DescriptorRepository descriptorRepository = null;
    private ConnectionManagerIF connectionManager = null;
    private SequenceManager sequenceManager = null;
    private StatementManagerIF statementManager = null;
    private SqlGenerator sqlGenerator;
    private IdentityFactory identityFactory;
    private RelationshipPrefetcherFactory relationshipPrefetcherFactory;
    private PBKey pbKey;
    private List nowStoring = new IdentityArrayList();
    private List markedForDelete = new IdentityArrayList();
    private Set deletedDuringTransaction = new HashSet();
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerImpl;

    public PersistenceBrokerImpl(PBKey key, PersistenceBrokerFactoryIF pbf) {
        this.refresh();
        if (key == null) {
            throw new PersistenceBrokerException("Could not instantiate broker with PBKey 'null'");
        }
        this.pbf = pbf;
        this.pbKey = key;
        this.brokerHelper = new BrokerHelper(this);
        this.connectionManager = ConnectionManagerFactory.getInstance().createConnectionManager(this);
        this.objectCache = ObjectCacheFactory.getInstance().createObjectCache(this);
        this.sequenceManager = SequenceManagerFactory.getSequenceManager(this);
        this.dbAccess = JdbcAccessFactory.getInstance().createJdbcAccess(this);
        this.statementManager = StatementManagerFactory.getInstance().createStatementManager(this);
        this.sqlGenerator = SqlGeneratorFactory.getInstance().createSqlGenerator(this.connectionManager.getSupportedPlatform());
        this.mtoNBroker = new MtoNBroker(this);
        this.referencesBroker = new QueryReferenceBroker(this);
        this.identityFactory = new IdentityFactoryImpl(this);
        this.relationshipPrefetcherFactory = new RelationshipPrefetcherFactory(this);
    }

    public MaterializationCache getInternalCache() {
        return this.objectCache;
    }

    public IdentityFactory serviceIdentity() {
        return this.identityFactory;
    }

    public SqlGenerator serviceSqlGenerator() {
        return this.sqlGenerator;
    }

    public StatementManagerIF serviceStatementManager() {
        return this.statementManager;
    }

    public JdbcAccess serviceJdbcAccess() {
        return this.dbAccess;
    }

    public ConnectionManagerIF serviceConnectionManager() {
        return this.connectionManager;
    }

    public SequenceManager serviceSequenceManager() {
        return this.sequenceManager;
    }

    public BrokerHelper serviceBrokerHelper() {
        return this.brokerHelper;
    }

    public ObjectCache serviceObjectCache() {
        return this.objectCache;
    }

    public QueryReferenceBroker getReferenceBroker() {
        return this.referencesBroker;
    }

    public RelationshipPrefetcherFactory getRelationshipPrefetcherFactory() {
        return this.relationshipPrefetcherFactory;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean closed) {
        if (!closed) {
            this.refresh();
        }
        this.isClosed = closed;
    }

    public void refresh() {
        this.setInTransaction(false);
        this.descriptorRepository = MetadataManager.getInstance().getRepository();
    }

    public void destroy() {
        this.removeAllListeners();
        if (this.connectionManager != null) {
            if (this.connectionManager.isInLocalTransaction()) {
                this.connectionManager.localRollback();
            }
            this.connectionManager.releaseConnection();
        }
        this.setClosed(true);
        this.descriptorRepository = null;
        this.pbKey = null;
        this.pbf = null;
        this.connectionManager = null;
        this.dbAccess = null;
        this.objectCache = null;
        this.sequenceManager = null;
        this.sqlGenerator = null;
        this.statementManager = null;
    }

    public PBKey getPBKey() {
        return this.pbKey;
    }

    public void setPBKey(PBKey key) {
        this.pbKey = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        if (this.isInTransaction()) {
            this.logger.error("Broker is still in PB-transaction, do automatic abort before close!");
            this.abortTransaction();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PB.close was called: " + this);
        }
        try {
            this.fireBrokerEvent(this.BEFORE_CLOSE_EVENT);
            this.clearRegistrationLists();
            this.referencesBroker.removePrefetchingListeners();
            if (this.connectionManager != null) {
                this.connectionManager.releaseConnection();
                this.connectionManager.setBatchMode(false);
            }
            Object var2_1 = null;
            this.descriptorRepository = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.descriptorRepository = null;
            this.removeAllListeners();
            this.setClosed(true);
            throw throwable;
        }
        this.removeAllListeners();
        this.setClosed(true);
        return true;
    }

    public synchronized void abortTransaction() throws TransactionNotInProgressException {
        if (this.isInTransaction()) {
            this.fireBrokerEvent(this.BEFORE_ROLLBACK_EVENT);
            this.setInTransaction(false);
            this.clearRegistrationLists();
            this.referencesBroker.removePrefetchingListeners();
            if (this.connectionManager.isInLocalTransaction()) {
                this.connectionManager.localRollback();
            }
            this.fireBrokerEvent(this.AFTER_ROLLBACK_EVENT);
        }
    }

    public synchronized void beginTransaction() throws TransactionInProgressException, TransactionAbortedException {
        if (this.isInTransaction()) {
            throw new TransactionInProgressException("PersistenceBroker is already in transaction");
        }
        this.fireBrokerEvent(this.BEFORE_BEGIN_EVENT);
        this.setInTransaction(true);
        this.connectionManager.localBegin();
        this.fireBrokerEvent(this.AFTER_BEGIN_EVENT);
    }

    public synchronized void commitTransaction() throws TransactionNotInProgressException, TransactionAbortedException {
        if (!this.isInTransaction()) {
            throw new TransactionNotInProgressException("PersistenceBroker is NOT in transaction, can't commit");
        }
        this.fireBrokerEvent(this.BEFORE_COMMIT_EVENT);
        this.setInTransaction(false);
        this.clearRegistrationLists();
        this.referencesBroker.removePrefetchingListeners();
        if (this.connectionManager.isInLocalTransaction()) {
            this.connectionManager.localCommit();
        }
        this.fireBrokerEvent(this.AFTER_COMMIT_EVENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Object obj) throws PersistenceBrokerException {
        if (!this.isInTransaction()) {
            String msg = "No running PB-tx found. Please, delete objects in context of an PB-transaction to avoid side-effects - e.g. when rollback of complex objects.";
            if (this.logger.isEnabledFor(2)) {
                try {
                    throw new Exception("** Delete object without active PersistenceBroker transaction **");
                }
                catch (Exception e) {
                    this.logger.info(msg, e);
                }
            } else {
                this.logger.warn(msg + " Enable log-level INFO to get more detailed message (stack trace).");
            }
        }
        try {
            this.doDelete(obj);
        }
        finally {
            this.markedForDelete.clear();
        }
    }

    private void doDelete(Object obj) throws PersistenceBrokerException {
        if (obj != null) {
            if (this.markedForDelete.contains(obj = ProxyHelper.getRealObject(obj))) {
                return;
            }
            this.markedForDelete.add(obj);
            ClassDescriptor cld = this.getClassDescriptor(obj.getClass());
            Identity oid = new Identity(obj, this, cld);
            this.BEFORE_DELETE_EVENT.setTarget(obj);
            this.fireBrokerEvent(this.BEFORE_DELETE_EVENT);
            this.BEFORE_DELETE_EVENT.setTarget(null);
            if (cld.getCollectionDescriptors().size() > 0) {
                this.deleteCollections(obj, cld.getCollectionDescriptors());
            }
            try {
                this.dbAccess.executeDelete(cld, obj);
            }
            catch (OptimisticLockException e) {
                this.objectCache.remove(oid);
                throw e;
            }
            this.deletedDuringTransaction.add(oid);
            if (cld.getObjectReferenceDescriptors().size() > 0) {
                this.deleteReferences(obj, cld.getObjectReferenceDescriptors());
            }
            this.objectCache.remove(oid);
            this.AFTER_DELETE_EVENT.setTarget(obj);
            this.fireBrokerEvent(this.AFTER_DELETE_EVENT);
            this.AFTER_DELETE_EVENT.setTarget(null);
            this.connectionManager.executeBatchIfNecessary();
        }
    }

    private void deleteByQuery(org.apache.ojb.broker.query.Query query, ClassDescriptor cld) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("deleteByQuery " + cld.getClassNameOfObject() + ", " + query);
        }
        if (query instanceof QueryBySQL) {
            String sql = ((QueryBySQL)query).getSql();
            this.dbAccess.executeUpdateSQL(sql, cld);
        } else {
            if (query instanceof QueryByIdentity) {
                QueryByIdentity qbi = (QueryByIdentity)query;
                Object oid = qbi.getExampleObject();
                if (!(oid instanceof Identity)) {
                    oid = new Identity(oid, this);
                }
                query = this.referencesBroker.getPKQuery((Identity)oid);
            }
            if (!cld.isInterface()) {
                this.dbAccess.executeDelete(query, cld);
            }
            String lastUsedTable = cld.getFullTableName();
            if (cld.isExtent()) {
                Iterator extents = this.getDescriptorRepository().getAllConcreteSubclassDescriptors(cld).iterator();
                while (extents.hasNext()) {
                    ClassDescriptor extCld = (ClassDescriptor)extents.next();
                    if (extCld.getFullTableName().equals(lastUsedTable)) continue;
                    lastUsedTable = extCld.getFullTableName();
                    this.dbAccess.executeDelete(query, extCld);
                }
            }
        }
    }

    public void deleteByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        ClassDescriptor cld = this.getClassDescriptor(query.getSearchClass());
        this.deleteByQuery(query, cld);
    }

    private void deleteReferences(Object obj, List listRds) throws PersistenceBrokerException {
        Iterator i = listRds.iterator();
        while (i.hasNext()) {
            Object referencedObject;
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
            if (rds.getCascadingDelete() != 23 || (referencedObject = rds.getPersistentField().get(obj)) == null) continue;
            this.doDelete(referencedObject);
        }
    }

    private void deleteCollections(Object obj, List listCds) throws PersistenceBrokerException {
        Iterator i = listCds.iterator();
        while (i.hasNext()) {
            Object col;
            CollectionDescriptor cds = (CollectionDescriptor)i.next();
            if (cds.getCascadingDelete() == 17) continue;
            if (cds.isMtoNRelation()) {
                this.mtoNBroker.deleteMtoNImplementor(cds, obj);
            }
            if (cds.getCascadingDelete() != 23 || (col = cds.getPersistentField().get(obj)) == null) continue;
            Iterator colIterator = BrokerHelper.getCollectionIterator(col);
            while (colIterator.hasNext()) {
                this.doDelete(colIterator.next());
            }
        }
    }

    public void store(Object obj) throws PersistenceBrokerException {
        if ((obj = this.extractObjectToStore(obj)) == null) {
            return;
        }
        ClassDescriptor cld = this.getClassDescriptor(obj.getClass());
        boolean insert = this.serviceBrokerHelper().hasNullPKField(cld, obj);
        Identity oid = new Identity(obj, this, cld);
        if (!insert) {
            insert = this.objectCache.lookup(oid) == null && !this.serviceBrokerHelper().doesExist(cld, oid, obj);
        }
        this.store(obj, oid, cld, insert);
    }

    private Object extractObjectToStore(Object obj) {
        Object result = obj;
        if (result != null && (result = ProxyHelper.getRealObjectIfMaterialized(obj)) == null && this.logger.isDebugEnabled()) {
            this.logger.debug("No materialized object could be found -> nothing to store, object was " + ObjectUtils.identityToString((Object)obj));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(Object obj, Identity oid, ClassDescriptor cld, boolean insert) {
        if (obj == null || this.nowStoring.contains(obj)) {
            return;
        }
        if (!insert) {
            insert = this.deletedDuringTransaction.contains(oid);
        }
        if (!this.isInTransaction()) {
            this.logger.warn("No running tx found, please only store in context of an PB-transaction, to avoid side-effects - e.g. when rollback of complex objects");
            if (this.logger.isEnabledFor(2)) {
                try {
                    throw new Exception("** Try to store object without active PersistenceBroker transaction **");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (insert) {
            this.BEFORE_STORE_EVENT.setTarget(obj);
            this.fireBrokerEvent(this.BEFORE_STORE_EVENT);
            this.BEFORE_STORE_EVENT.setTarget(null);
        } else {
            this.BEFORE_UPDATE_EVENT.setTarget(obj);
            this.fireBrokerEvent(this.BEFORE_UPDATE_EVENT);
            this.BEFORE_UPDATE_EVENT.setTarget(null);
        }
        try {
            this.nowStoring.add(obj);
            this.storeToDb(obj, cld, oid, insert);
        }
        finally {
            this.nowStoring.remove(obj);
        }
        if (insert) {
            this.AFTER_STORE_EVENT.setTarget(obj);
            this.fireBrokerEvent(this.AFTER_STORE_EVENT);
            this.AFTER_STORE_EVENT.setTarget(null);
        } else {
            this.AFTER_UPDATE_EVENT.setTarget(obj);
            this.fireBrokerEvent(this.AFTER_UPDATE_EVENT);
            this.AFTER_UPDATE_EVENT.setTarget(null);
        }
        if (this.deletedDuringTransaction.size() > 0) {
            this.deletedDuringTransaction.remove(oid);
        }
        this.connectionManager.executeBatchIfNecessary();
    }

    private void storeReferences(Object obj, ClassDescriptor cld, boolean insert) {
        Vector listRds = cld.getObjectReferenceDescriptors();
        if (listRds.size() == 0) {
            return;
        }
        Iterator i = listRds.iterator();
        while (i.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
            if (rds.getCascadingStore() == 17) continue;
            this.storeAndLinkOneToOne(false, obj, cld, rds, insert);
        }
    }

    private void storeAndLinkOneToOne(boolean onlyLink, Object obj, ClassDescriptor cld, ObjectReferenceDescriptor rds, boolean insert) {
        Object ref = rds.getPersistentField().get(obj);
        if (!onlyLink && rds.getCascadingStore() == 23) {
            this.store(ref);
        } else if (this.logger.isEnabledFor(2)) {
            this.logger.info("Cascade store for this reference-descriptor (" + rds.getAttributeName() + ") was set to false.");
        }
        this.link(obj, cld, rds, ref, insert);
    }

    private void storeCollections(Object obj, ClassDescriptor cld, boolean insert) throws PersistenceBrokerException {
        Vector listCods = cld.getCollectionDescriptors();
        if (listCods.size() == 0) {
            return;
        }
        Iterator i = listCods.iterator();
        while (i.hasNext()) {
            CollectionDescriptor cod = (CollectionDescriptor)i.next();
            if (cod.getCascadingStore() == 17) continue;
            Object referencedObjects = cod.getPersistentField().get(obj);
            if (cod.isMtoNRelation()) {
                this.storeAndLinkMtoN(false, obj, cod, referencedObjects, insert);
            } else {
                this.storeAndLinkOneToMany(false, obj, cod, referencedObjects, insert);
            }
            if (cod.getCascadingStore() != 23 || !(referencedObjects instanceof ManageableCollection)) continue;
            ((ManageableCollection)referencedObjects).afterStore(this);
        }
    }

    private void storeAndLinkMtoN(boolean onlyLink, Object obj, CollectionDescriptor cod, Object referencedObjects, boolean insert) {
        if (insert || !(referencedObjects instanceof CollectionProxy) || ((CollectionProxy)referencedObjects).isLoaded()) {
            List existingMtoNKeys;
            Iterator referencedObjectsIterator;
            if (referencedObjects == null) {
                referencedObjects = Collections.EMPTY_LIST;
            }
            if (!onlyLink && cod.getCascadingStore() == 23) {
                referencedObjectsIterator = BrokerHelper.getCollectionIterator(referencedObjects);
                while (referencedObjectsIterator.hasNext()) {
                    this.store(referencedObjectsIterator.next());
                }
            }
            if (!insert) {
                existingMtoNKeys = this.mtoNBroker.getMtoNImplementor(cod, obj);
                referencedObjectsIterator = BrokerHelper.getCollectionIterator(referencedObjects);
                this.mtoNBroker.deleteMtoNImplementor(cod, obj, referencedObjectsIterator, existingMtoNKeys);
            } else {
                existingMtoNKeys = Collections.EMPTY_LIST;
            }
            referencedObjectsIterator = BrokerHelper.getCollectionIterator(referencedObjects);
            while (referencedObjectsIterator.hasNext()) {
                Object refObj = referencedObjectsIterator.next();
                this.mtoNBroker.storeMtoNImplementor(cod, obj, refObj, existingMtoNKeys);
            }
        }
    }

    private void storeAndLinkOneToMany(boolean linkOnly, Object obj, CollectionDescriptor cod, Object referencedObjects, boolean insert) {
        if (referencedObjects == null) {
            return;
        }
        if (insert || !(referencedObjects instanceof CollectionProxyDefaultImpl) || ((CollectionProxyDefaultImpl)referencedObjects).isLoaded()) {
            Iterator it = BrokerHelper.getCollectionIterator(referencedObjects);
            while (it.hasNext()) {
                Object refObj = it.next();
                if (!ProxyHelper.isMaterialized(refObj)) continue;
                ClassDescriptor refCld = this.getClassDescriptor(ProxyHelper.getRealClass(refObj));
                refObj = ProxyHelper.getRealObject(refObj);
                this.link(refObj, refCld, cod, obj, insert);
                if (linkOnly || cod.getCascadingStore() != 23) continue;
                this.store(refObj);
            }
        }
    }

    public void link(Object targetObject, ClassDescriptor cld, ObjectReferenceDescriptor rds, Object referencedObject, boolean insert) {
        if (referencedObject == null) {
            if (!insert) {
                this.unlinkFK(targetObject, cld, rds);
            }
        } else {
            this.setFKField(targetObject, cld, rds, referencedObject);
        }
    }

    public void unlinkFK(Object targetObject, ClassDescriptor cld, ObjectReferenceDescriptor rds) {
        this.setFKField(targetObject, cld, rds, null);
    }

    private void setFKField(Object targetObject, ClassDescriptor cld, ObjectReferenceDescriptor rds, Object referencedObject) {
        ValueContainer[] refPkValues;
        FieldDescriptor[] objFkFields = rds.getForeignKeyFieldDescriptors(cld);
        if (objFkFields == null) {
            throw new PersistenceBrokerException("No foreign key fields defined for class '" + cld.getClassNameOfObject() + "'");
        }
        if (referencedObject == null) {
            refPkValues = null;
        } else {
            Class refClass = ProxyHelper.getRealClass(referencedObject);
            ClassDescriptor refCld = this.getClassDescriptor(refClass);
            refPkValues = this.brokerHelper.getKeyValues(refCld, referencedObject, false);
        }
        for (int i = 0; i < objFkFields.length; ++i) {
            FieldDescriptor fld = objFkFields[i];
            if (refPkValues == null && fld.isPrimaryKey()) continue;
            fld.getPersistentField().set(targetObject, refPkValues != null ? refPkValues[i].getValue() : null);
        }
    }

    public void linkOneToOne(Object obj, ClassDescriptor cld, ObjectReferenceDescriptor rds, boolean insert) {
        this.storeAndLinkOneToOne(true, obj, cld, rds, true);
    }

    public void linkOneToMany(Object obj, CollectionDescriptor cod, boolean insert) {
        Object referencedObjects = cod.getPersistentField().get(obj);
        this.storeAndLinkOneToMany(true, obj, cod, referencedObjects, insert);
    }

    public void linkMtoN(Object obj, CollectionDescriptor cod, boolean insert) {
        Object referencedObjects = cod.getPersistentField().get(obj);
        this.storeAndLinkMtoN(true, obj, cod, referencedObjects, insert);
    }

    public void unlinkXtoN(Object obj, CollectionDescriptor col) {
        if (col.isMtoNRelation()) {
            this.mtoNBroker.deleteMtoNImplementor(col, obj);
        } else {
            Object collectionObject = col.getPersistentField().get(obj);
            if (collectionObject != null) {
                Iterator colIterator = BrokerHelper.getCollectionIterator(collectionObject);
                ClassDescriptor cld = null;
                while (colIterator.hasNext()) {
                    Object target = colIterator.next();
                    if (cld == null) {
                        cld = this.getClassDescriptor(ProxyHelper.getRealClass(target));
                    }
                    this.unlinkFK(target, cld, col);
                }
            }
        }
    }

    public void retrieveAllReferences(Object pInstance) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Manually retrieving all references for object " + this.serviceIdentity().buildIdentity(pInstance));
        }
        ClassDescriptor cld = this.getClassDescriptor(pInstance.getClass());
        boolean forced = true;
        this.getInternalCache().enableMaterializationCache();
        Identity oid = this.serviceIdentity().buildIdentity(pInstance);
        boolean needLocalRemove = false;
        if (this.getInternalCache().doLocalLookup(oid) == null) {
            this.getInternalCache().doInternalCache(oid, pInstance, 0);
            needLocalRemove = true;
        }
        try {
            this.referencesBroker.retrieveReferences(pInstance, cld, true);
            this.referencesBroker.retrieveCollections(pInstance, cld, true);
            if (needLocalRemove) {
                this.getInternalCache().doLocalRemove(oid);
            }
            this.getInternalCache().disableMaterializationCache();
        }
        catch (RuntimeException e) {
            this.getInternalCache().doLocalClear();
            throw e;
        }
    }

    public void retrieveReference(Object pInstance, String pAttributeName) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Retrieving reference named [" + pAttributeName + "] on object of type [" + pInstance.getClass().getName() + "]");
        }
        ClassDescriptor cld = this.getClassDescriptor(pInstance.getClass());
        CollectionDescriptor cod = cld.getCollectionDescriptorByName(pAttributeName);
        this.getInternalCache().enableMaterializationCache();
        Identity oid = this.serviceIdentity().buildIdentity(pInstance);
        boolean needLocalRemove = false;
        if (this.getInternalCache().doLocalLookup(oid) == null) {
            this.getInternalCache().doInternalCache(oid, pInstance, 0);
            needLocalRemove = true;
        }
        try {
            if (cod != null) {
                this.referencesBroker.retrieveCollection(pInstance, cld, cod, true);
            } else {
                ObjectReferenceDescriptor ord = cld.getObjectReferenceDescriptorByName(pAttributeName);
                if (ord != null) {
                    this.referencesBroker.retrieveReference(pInstance, cld, ord, true);
                } else {
                    throw new PersistenceBrokerException("did not find attribute " + pAttributeName + " for class " + pInstance.getClass().getName());
                }
            }
            if (needLocalRemove) {
                this.getInternalCache().doLocalRemove(oid);
            }
            this.getInternalCache().disableMaterializationCache();
        }
        catch (RuntimeException e) {
            this.getInternalCache().doLocalClear();
            throw e;
        }
    }

    public void refreshRelationships(Object obj, ClassDescriptor cld) {
        Iterator iter = cld.getCollectionDescriptors().iterator();
        while (iter.hasNext()) {
            CollectionDescriptor cds = (CollectionDescriptor)iter.next();
            if (!cds.isRefresh()) continue;
            this.referencesBroker.retrieveCollection(obj, cld, cds, false);
        }
        iter = cld.getObjectReferenceDescriptors().iterator();
        while (iter.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)iter.next();
            if (!rds.isRefresh()) continue;
            this.referencesBroker.retrieveReference(obj, cld, rds, false);
        }
    }

    public ManageableCollection getCollectionByQuery(Class collectionClass, org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        return this.referencesBroker.getCollectionByQuery(collectionClass, query, false);
    }

    public Collection getCollectionByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        return this.referencesBroker.getCollectionByQuery(query, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getDBObject(Identity oid) throws ClassNotPersistenceCapableException {
        Class c = oid.getObjectsRealClass();
        if (c == null) {
            this.logger.info("Real class for used Identity object is 'null', use top-level class instead");
            c = oid.getObjectsTopLevelClass();
        }
        ClassDescriptor cld = this.getClassDescriptor(c);
        Object newObj = null;
        if (!cld.isInterface()) {
            newObj = this.dbAccess.materializeObject(cld, oid);
        }
        if (newObj == null && cld.isExtent()) {
            ClassDescriptor extCld;
            Iterator extents = this.getDescriptorRepository().getAllConcreteSubclassDescriptors(cld).iterator();
            while (extents.hasNext() && (newObj = this.dbAccess.materializeObject(extCld = (ClassDescriptor)extents.next(), oid)) == null) {
            }
        }
        if (newObj != null) {
            if (oid.getObjectsRealClass() == null) {
                oid.setObjectsRealClass(newObj.getClass());
            }
            Object object = newObj;
            synchronized (object) {
                this.objectCache.enableMaterializationCache();
                try {
                    this.objectCache.doInternalCache(oid, newObj, 11);
                    ClassDescriptor newObjCld = this.getClassDescriptor(newObj.getClass());
                    boolean unforced = false;
                    this.referencesBroker.retrieveReferences(newObj, newObjCld, false);
                    this.referencesBroker.retrieveCollections(newObj, newObjCld, false);
                    this.objectCache.disableMaterializationCache();
                }
                catch (RuntimeException e) {
                    this.objectCache.doLocalClear();
                    throw e;
                }
            }
        }
        return newObj;
    }

    public Iterator getIteratorByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        Class itemClass = query.getSearchClass();
        ClassDescriptor cld = this.getClassDescriptor(itemClass);
        return this.getIteratorFromQuery(query, cld);
    }

    protected OJBIterator getIteratorFromQuery(org.apache.ojb.broker.query.Query query, ClassDescriptor cld) throws PersistenceBrokerException {
        RsIteratorFactory factory = RsIteratorFactoryImpl.getInstance();
        OJBIterator result = this.getRsIteratorFromQuery(query, cld, factory);
        if (query.usePaging()) {
            result = new PagingIterator(result, query.getStartAtIndex(), query.getEndAtIndex());
        }
        return result;
    }

    public Object getObjectByIdentity(Identity id) throws PersistenceBrokerException {
        this.objectCache.enableMaterializationCache();
        Object result = null;
        try {
            result = this.doGetObjectByIdentity(id);
            this.objectCache.disableMaterializationCache();
        }
        catch (RuntimeException e) {
            this.objectCache.doLocalClear();
            throw e;
        }
        return result;
    }

    public Object doGetObjectByIdentity(Identity id) throws PersistenceBrokerException {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getObjectByIdentity " + id);
        }
        if ((obj = this.objectCache.lookup(id)) == null) {
            obj = this.getDBObject(id);
        } else {
            ClassDescriptor cld = this.getClassDescriptor(obj.getClass());
            if (cld.isAlwaysRefresh()) {
                this.refreshInstance(obj, id, cld);
            }
            this.refreshRelationships(obj, cld);
        }
        this.AFTER_LOOKUP_EVENT.setTarget(obj);
        this.fireBrokerEvent(this.AFTER_LOOKUP_EVENT);
        this.AFTER_LOOKUP_EVENT.setTarget(null);
        return obj;
    }

    private void refreshInstance(Object cachedInstance, Identity oid, ClassDescriptor cld) {
        Object freshInstance = this.getDBObject(oid);
        FieldDescriptor[] fields = cld.getFieldDescriptions();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor fmd = fields[i];
            PersistentField fld = fmd.getPersistentField();
            fld.set(cachedInstance, fld.get(freshInstance));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        Object result = null;
        if (query instanceof QueryByIdentity) {
            Object obj = query.getExampleObject();
            if (obj instanceof Identity) {
                Identity oid = (Identity)obj;
                result = this.getObjectByIdentity(oid);
            } else if (!this.serviceBrokerHelper().hasNullPKField(this.getClassDescriptor(obj.getClass()), obj)) {
                Identity oid = this.serviceIdentity().buildIdentity(obj);
                result = this.getObjectByIdentity(oid);
            }
        } else {
            Class itemClass = query.getSearchClass();
            ClassDescriptor cld = this.getClassDescriptor(itemClass);
            OJBIterator it = this.getIteratorFromQuery(query, cld);
            try {
                while (result == null && it.hasNext()) {
                    result = it.next();
                }
            }
            finally {
                if (it != null) {
                    it.releaseDbResources();
                }
            }
        }
        return result;
    }

    public Enumeration getPKEnumerationByQuery(Class primaryKeyClass, org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getPKEnumerationByQuery " + query);
        }
        ClassDescriptor cld = this.getClassDescriptor(query.getSearchClass());
        return new PkEnumeration(query, cld, primaryKeyClass, this);
    }

    public void store(Object obj, ObjectModification mod) throws PersistenceBrokerException {
        if ((obj = this.extractObjectToStore(obj)) == null) {
            return;
        }
        ClassDescriptor cld = this.getClassDescriptor(obj.getClass());
        Identity oid = this.serviceIdentity().buildIdentity(cld, obj);
        if (mod.needsInsert()) {
            this.store(obj, oid, cld, true);
        } else if (mod.needsUpdate()) {
            this.store(obj, oid, cld, false);
        } else {
            this.storeCollections(obj, cld, mod.needsInsert());
        }
    }

    private void storeToDb(Object obj, ClassDescriptor cld, Identity oid, boolean insert) {
        this.storeReferences(obj, cld, insert);
        Object[] pkValues = oid.getPrimaryKeyValues();
        if (!this.serviceBrokerHelper().assertValidPkFields(cld.getPkFields(), pkValues)) {
            pkValues = this.serviceBrokerHelper().getKeyValues(cld, obj);
            if (!this.serviceBrokerHelper().assertValidPkFields(cld.getPkFields(), pkValues)) {
                String append = insert ? " on insert" : " on update";
                throw new PersistenceBrokerException("assertValidPkFields failed for Object of type: " + cld.getClassNameOfObject() + append);
            }
        }
        if (cld.getSuperClass() != null) {
            ClassDescriptor superCld = this.getDescriptorRepository().getDescriptorFor(cld.getSuperClass());
            this.storeToDb(obj, superCld, oid, insert);
        }
        if (insert) {
            this.dbAccess.executeInsert(cld, obj);
        } else {
            try {
                this.dbAccess.executeUpdate(cld, obj);
            }
            catch (OptimisticLockException e) {
                this.objectCache.remove(oid);
                throw e;
            }
        }
        Identity newOid = this.serviceIdentity().buildIdentity(cld, obj);
        this.objectCache.doInternalCache(newOid, obj, 5);
        this.storeCollections(obj, cld, insert);
    }

    public boolean isInTransaction() {
        return this.inTransaction;
    }

    public void setInTransaction(boolean inTransaction) {
        this.inTransaction = inTransaction;
    }

    public void removeFromCache(Object objectOrIdentity) throws PersistenceBrokerException {
        Identity identity = objectOrIdentity instanceof Identity ? (Identity)objectOrIdentity : new Identity(objectOrIdentity, this);
        this.objectCache.remove(identity);
    }

    public ClassDescriptor getClassDescriptor(Class clazz) throws PersistenceBrokerException {
        return this.descriptorRepository.getDescriptorFor(clazz);
    }

    public boolean hasClassDescriptor(Class clazz) {
        return this.descriptorRepository.hasDescriptorFor(clazz);
    }

    public void clearCache() throws PersistenceBrokerException {
        this.objectCache.clear();
    }

    public Class getTopLevelClass(Class clazz) throws PersistenceBrokerException {
        try {
            return this.descriptorRepository.getTopLevelClass(clazz);
        }
        catch (ClassNotPersistenceCapableException e) {
            throw new PersistenceBrokerException((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        org.apache.ojb.broker.query.Query countQuery = this.serviceBrokerHelper().getCountQuery(query);
        int result = 0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getCount " + countQuery.getSearchClass() + ", " + countQuery);
        }
        Iterator iter = this.getReportQueryIteratorByQuery(countQuery);
        try {
            while (iter.hasNext()) {
                Object[] row = (Object[])iter.next();
                result += ((Number)row[0]).intValue();
            }
        }
        finally {
            if (iter instanceof OJBIterator) {
                ((OJBIterator)iter).releaseDbResources();
            }
        }
        return result;
    }

    public Iterator getReportQueryIteratorByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        ClassDescriptor cld = this.getClassDescriptor(query.getSearchClass());
        return this.getReportQueryIteratorFromQuery(query, cld);
    }

    private OJBIterator getRsIteratorFromQuery(org.apache.ojb.broker.query.Query query, ClassDescriptor cld, RsIteratorFactory factory) throws PersistenceBrokerException {
        if (query instanceof QueryBySQL) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating SQL-RsIterator for class [" + cld.getClassNameOfObject() + "]");
            }
            return factory.createRsIterator((QueryBySQL)query, cld, this);
        }
        if (!cld.isExtent() || !query.getWithExtents()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating RsIterator for class [" + cld.getClassNameOfObject() + "]");
            }
            return factory.createRsIterator(query, cld, this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating ChainingIterator for class [" + cld.getClassNameOfObject() + "]");
        }
        ChainingIterator chainingIter = new ChainingIterator();
        if (!cld.isInterface()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding RsIterator for class [" + cld.getClassNameOfObject() + "] to ChainingIterator");
            }
            chainingIter.addIterator(factory.createRsIterator(query, cld, this));
        }
        Iterator extents = this.getDescriptorRepository().getAllConcreteSubclassDescriptors(cld).iterator();
        while (extents.hasNext()) {
            ClassDescriptor extCld = (ClassDescriptor)extents.next();
            if (chainingIter.containsIteratorForTable(extCld.getFullTableName())) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Skipping class [" + extCld.getClassNameOfObject() + "]");
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding RsIterator of class [" + extCld.getClassNameOfObject() + "] to ChainingIterator");
            }
            chainingIter.addIterator(factory.createRsIterator(query, extCld, this));
        }
        return chainingIter;
    }

    private OJBIterator getReportQueryIteratorFromQuery(org.apache.ojb.broker.query.Query query, ClassDescriptor cld) throws PersistenceBrokerException {
        RsIteratorFactory factory = ReportRsIteratorFactoryImpl.getInstance();
        OJBIterator result = this.getRsIteratorFromQuery(query, cld, factory);
        if (query.usePaging()) {
            result = new PagingIterator(result, query.getStartAtIndex(), query.getEndAtIndex());
        }
        return result;
    }

    public Query query() {
        return new QueryImpl(this);
    }

    public DescriptorRepository getDescriptorRepository() {
        return this.descriptorRepository;
    }

    protected void finalize() {
        if (!this.isClosed) {
            this.close();
        }
    }

    private void clearRegistrationLists() {
        this.nowStoring.clear();
        this.objectCache.doLocalClear();
        this.deletedDuringTransaction.clear();
        this.mtoNBroker.reset();
    }

    public void deleteMtoNImplementor(MtoNImplementor m2nImpl) throws PersistenceBrokerException {
        this.mtoNBroker.deleteMtoNImplementor(m2nImpl);
    }

    public void addMtoNImplementor(MtoNImplementor m2n) throws PersistenceBrokerException {
        this.mtoNBroker.storeMtoNImplementor(m2n);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

