/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.TransactionInProgressException;
import org.apache.ojb.broker.TransactionNotInProgressException;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.core.DelegatingPersistenceBroker;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryDefaultImpl;
import org.apache.ojb.broker.core.PersistenceBrokerHandle;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.PoolablePersistenceBroker;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryException;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryFactory;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PersistenceBrokerFactorySyncImpl
extends PersistenceBrokerFactoryDefaultImpl {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl = PersistenceBrokerFactorySyncImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactorySyncImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl);
    private TransactionManager txMan;
    private TxRegistry txRegistry;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl;
    static /* synthetic */ Class class$javax$transaction$Status;

    public PersistenceBrokerFactorySyncImpl() {
        try {
            this.txMan = TransactionManagerFactoryFactory.instance().getTransactionManager();
        }
        catch (TransactionManagerFactoryException e) {
            throw new PBFactoryException("Can't instantiate TransactionManager of managed environment", (Throwable)((Object)e));
        }
        this.txRegistry = new TxRegistry();
    }

    public PersistenceBroker createPersistenceBroker(PBKey pbKey) throws PBFactoryException {
        pbKey = BrokerHelper.crossCheckPBKey(pbKey);
        Transaction tx = null;
        try {
            tx = this.searchForValidTx();
        }
        catch (SystemException e) {
            throw new PBFactoryException("Can't create PB instance, failure while lookup running JTA transaction", e);
        }
        DelegatingPersistenceBroker obtainedBroker = null;
        if (tx != null) {
            obtainedBroker = this.txRegistry.findBroker(tx, pbKey);
        }
        PersistenceBrokerSyncHandle result = obtainedBroker == null || obtainedBroker.isClosed() ? (PersistenceBrokerSyncHandle)super.createPersistenceBroker(pbKey) : new PersistenceBrokerSyncHandle((PersistenceBrokerSyncImpl)obtainedBroker);
        return result;
    }

    protected PersistenceBroker wrapBrokerWithPoolingHandle(PersistenceBroker broker, KeyedObjectPool pool) {
        return new PersistenceBrokerSyncImpl(broker, pool);
    }

    protected PersistenceBroker wrapRequestedBrokerInstance(PersistenceBroker broker) {
        PersistenceBrokerSyncImpl pb;
        block8: {
            if (!(broker instanceof PersistenceBrokerSyncImpl)) {
                throw new PBFactoryException("Expect instance of " + (class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl = PersistenceBrokerFactorySyncImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl) + ", found " + broker.getClass());
            }
            pb = (PersistenceBrokerSyncImpl)broker;
            try {
                Transaction tx = this.searchForValidTx();
                if (tx == null) break block8;
                this.txRegistry.register(tx, pb);
                try {
                    pb.internBegin();
                }
                catch (Exception e) {
                    this.log.error("Unexpected exception when start intern pb-tx", e);
                    try {
                        tx.setRollbackOnly();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    throw new PBFactoryException("Unexpected exception when start intern pb-tx", e);
                }
            }
            catch (Exception e) {
                if (e instanceof PBFactoryException) {
                    throw (PBFactoryException)((Object)e);
                }
                throw new PBFactoryException("Error while try to participate in JTA transaction", e);
            }
        }
        return new PersistenceBrokerSyncHandle(pb);
    }

    private Transaction searchForValidTx() throws SystemException {
        int status;
        Transaction tx = this.txMan.getTransaction();
        if (tx != null && (status = tx.getStatus()) != 0 && status != 6) {
            throw new PBFactoryException("Transaction synchronization failed - wrong status of external JTA tx. Expected was an 'active' or 'no transaction', found status is '" + PersistenceBrokerFactorySyncImpl.getStatusFlagAsString(status) + "'");
        }
        return tx;
    }

    private static String getStatusFlagAsString(int status) {
        String statusName = "no match, unknown status!";
        try {
            Field[] fields = (class$javax$transaction$Status == null ? (class$javax$transaction$Status = PersistenceBrokerFactorySyncImpl.class$("javax.transaction.Status")) : class$javax$transaction$Status).getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].getInt(null) != status) continue;
                statusName = fields[i].getName();
                break;
            }
        }
        catch (Exception e) {
            statusName = "no match, unknown status!";
        }
        return statusName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PersistenceBrokerSyncHandle
    extends PersistenceBrokerHandle {
        public PersistenceBrokerSyncHandle(PersistenceBrokerSyncImpl broker) {
            super(broker);
            broker.registerHandle(this);
        }

        public boolean isClosed() {
            return super.isClosed();
        }

        public boolean close() {
            if (this.getDelegate() != null) {
                ((PersistenceBrokerSyncImpl)this.getDelegate()).deregisterHandle(this);
            }
            return super.close();
        }
    }

    class TxRegistry {
        Map txBoxMap = Collections.synchronizedMap(new WeakHashMap());

        void register(Transaction tx, PersistenceBrokerSyncImpl syncObject) throws RollbackException, SystemException {
            TransactionBox txBox = (TransactionBox)this.txBoxMap.get(tx);
            if (txBox == null || txBox.isClosed) {
                if (txBox != null) {
                    this.txBoxMap.remove(tx);
                }
                txBox = new TransactionBox(tx);
                tx.registerSynchronization((Synchronization)txBox);
                this.txBoxMap.put(tx, txBox);
            }
            txBox.add(syncObject);
        }

        PersistenceBrokerSyncImpl findBroker(Transaction tx, PBKey pbKey) {
            PersistenceBrokerSyncImpl result = null;
            TransactionBox txBox = (TransactionBox)this.txBoxMap.get(tx);
            if (txBox != null) {
                result = txBox.find(pbKey);
            }
            return result;
        }

        TransactionBox findTxBox(Transaction tx) {
            return (TransactionBox)this.txBoxMap.get(tx);
        }

        void removeTxBox(Transaction tx) {
            this.txBoxMap.remove(tx);
        }
    }

    class TransactionBox
    implements Synchronization {
        Transaction jtaTx;
        Map syncMap = new HashMap();
        boolean isLocked = false;
        boolean isClosed = false;

        public TransactionBox(Transaction tx) {
            this.jtaTx = tx;
        }

        PersistenceBrokerSyncImpl find(PBKey key) {
            return (PersistenceBrokerSyncImpl)this.syncMap.get(key);
        }

        void add(PersistenceBrokerSyncImpl syncObj) {
            if (this.isLocked) {
                throw new PBFactoryException("Can't associate object with JTA transaction, because tx-completion started");
            }
            this.syncMap.put(syncObj.getPBKey(), syncObj);
        }

        public void afterCompletion(int status) {
            boolean failures = false;
            Synchronization synchronization = null;
            Iterator iterator = this.syncMap.values().iterator();
            while (iterator.hasNext()) {
                try {
                    synchronization = (Synchronization)iterator.next();
                    synchronization.afterCompletion(status);
                }
                catch (Exception e) {
                    failures = true;
                    PersistenceBrokerFactorySyncImpl.this.log.error("Unexpected error when perform Synchronization#afterCompletion method call on object " + synchronization, e);
                }
            }
            this.isClosed = true;
            PersistenceBrokerFactorySyncImpl.this.txRegistry.removeTxBox(this.jtaTx);
            if (failures) {
                throw new PBFactoryException("Unexpected error occured while performing Synchronization#afterCompletion method");
            }
        }

        public void beforeCompletion() {
            boolean failures = false;
            Synchronization synchronization = null;
            Iterator iterator = this.syncMap.values().iterator();
            while (iterator.hasNext()) {
                try {
                    synchronization = (Synchronization)iterator.next();
                    synchronization.beforeCompletion();
                }
                catch (Exception e) {
                    failures = true;
                    PersistenceBrokerFactorySyncImpl.this.log.error("Unexpected error when perform Synchronization#beforeCompletion method call on object " + synchronization, e);
                }
            }
            this.isLocked = true;
            if (failures) {
                throw new PBFactoryException("Unexpected error occured while performing Synchronization#beforeCompletion method");
            }
        }
    }

    public static class PersistenceBrokerSyncImpl
    extends PoolablePersistenceBroker
    implements Synchronization {
        private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl = PersistenceBrokerFactorySyncImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl);
        private List handleList = new ArrayList();

        public PersistenceBrokerSyncImpl(PersistenceBroker broker, KeyedObjectPool pool) {
            super(broker, pool);
        }

        public void beforeCompletion() {
            ConnectionManagerIF cm;
            if (this.log.isDebugEnabled()) {
                this.log.debug("beforeCompletion was called, nothing to do");
            }
            if (this.handleList.size() > 0) {
                for (int i = 0; i < this.handleList.size(); ++i) {
                    this.log.warn("Found unclosed PersistenceBroker handle, will do automatic close. Please make sure that all used PB instances will be closed.");
                    PersistenceBrokerHandle pbh = (PersistenceBrokerHandle)this.handleList.get(i);
                    pbh.close();
                }
                this.handleList.clear();
            }
            if ((cm = this.serviceConnectionManager()).isBatchMode()) {
                cm.executeBatch();
            }
            if (cm.isInLocalTransaction()) {
                this.log.warn("Seems the used PersistenceBroker handle wasn't closed, close the used handle before the transaction completes.");
                cm.localCommit();
            }
            cm.releaseConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("afterCompletion was called");
            }
            try {
                if (status != 3) {
                    if (status == 4 || status == 9) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Aborting PB-tx due to JTA initiated Rollback: " + PersistenceBrokerFactorySyncImpl.getStatusFlagAsString(status));
                        }
                    } else {
                        this.log.error("Aborting PB-tx due to inconsistent, and unexpected, status of JTA tx: " + PersistenceBrokerFactorySyncImpl.getStatusFlagAsString(status));
                    }
                    this.internAbort();
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Commit PB-tx");
                    }
                    this.internCommit();
                }
            }
            finally {
                this.doRealClose();
            }
        }

        private void internBegin() {
            super.beginTransaction();
        }

        private void internCommit() {
            super.commitTransaction();
        }

        private void internAbort() {
            super.abortTransaction();
        }

        private void doRealClose() {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Now do real close of PB instance");
            }
            super.close();
        }

        public boolean close() {
            if (!this.isInTransaction()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("PB close was called, pass the close call to underlying PB instance");
                }
                this.doRealClose();
            } else if (this.handleList.size() > 0) {
                if (this.log.isEnabledFor(2)) {
                    this.log.info("PB.close(): Active used by " + this.handleList.size() + " handle objects, will skip close call");
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("PB close was called, only close the PB handle when in JTA-tx");
                }
                PersistenceBrokerImpl pb = (PersistenceBrokerImpl)this.getInnermostDelegate();
                pb.fireBrokerEvent(pb.BEFORE_CLOSE_EVENT);
                ConnectionManagerIF cm = this.serviceConnectionManager();
                if (cm.isInLocalTransaction()) {
                    cm.localCommit();
                }
                cm.releaseConnection();
            }
            return true;
        }

        void registerHandle(PersistenceBrokerHandle handle) {
            this.handleList.add(handle);
        }

        void deregisterHandle(PersistenceBrokerHandle handle) {
            this.handleList.remove(handle);
        }

        public void beginTransaction() throws TransactionInProgressException, TransactionAbortedException {
            throw new UnsupportedOperationException("In managed environments only JTA transaction demarcation allowed");
        }

        public void commitTransaction() throws TransactionNotInProgressException, TransactionAbortedException {
            throw new UnsupportedOperationException("In managed environments only JTA transaction demarcation allowed");
        }

        public void abortTransaction() throws TransactionNotInProgressException {
            throw new UnsupportedOperationException("In managed environments only JTA transaction demarcation allowed");
        }
    }
}

