/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.cache.CacheDistributor;
import org.apache.ojb.broker.cache.ObjectCacheInternal;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class MaterializationCache
implements ObjectCacheInternal {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$cache$MaterializationCache == null ? (class$org$apache$ojb$broker$cache$MaterializationCache = MaterializationCache.class$("org.apache.ojb.broker.cache.MaterializationCache")) : class$org$apache$ojb$broker$cache$MaterializationCache);
    private CacheDistributor cacheDistributor;
    private HashMap objectBuffer;
    private boolean enabledReadCache;
    private int invokeCounter;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$MaterializationCache;

    MaterializationCache(CacheDistributor cache) {
        this.cacheDistributor = cache;
        this.objectBuffer = new HashMap();
        this.enabledReadCache = false;
    }

    public void enableMaterializationCache() {
        ++this.invokeCounter;
        this.enabledReadCache = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableMaterializationCache() {
        if (!this.enabledReadCache) {
            return;
        }
        --this.invokeCounter;
        if (this.invokeCounter == 0) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Materialisation of object is finished, push " + this.objectBuffer.size() + "objects to cache");
                }
                this.pushObjects();
            }
            finally {
                this.doLocalClear();
            }
        }
    }

    public void doInternalCache(Identity oid, Object obj, int type) {
        if (this.enabledReadCache) {
            this.doLocalCache(oid, obj, type);
        } else {
            this.cacheDistributor.doInternalCache(oid, obj, type);
        }
    }

    public void cache(Identity oid, Object obj) {
        this.doInternalCache(oid, obj, 0);
    }

    public boolean cacheIfNew(Identity oid, Object obj) {
        boolean result = this.cacheDistributor.cacheIfNew(oid, obj);
        if (this.enabledReadCache) {
            this.doLocalCache(oid, obj, 7);
        }
        return result;
    }

    public Object lookup(Identity oid) {
        Object result = null;
        if (this.enabledReadCache) {
            result = this.doLocalLookup(oid);
        }
        if (result == null) {
            result = this.cacheDistributor.lookup(oid);
        }
        return result;
    }

    public Object doLocalLookup(Identity oid) {
        ObjectEntry entry = (ObjectEntry)this.objectBuffer.get(oid);
        return entry != null ? entry.obj : null;
    }

    public void remove(Identity oid) {
        this.doLocalRemove(oid);
        this.cacheDistributor.remove(oid);
    }

    public void doLocalRemove(Identity oid) {
        this.objectBuffer.remove(oid);
    }

    public void doLocalClear() {
        if (log.isDebugEnabled()) {
            log.debug("Clear materialization cache");
        }
        this.invokeCounter = 0;
        this.enabledReadCache = false;
        this.objectBuffer.clear();
    }

    public void clear() {
        if (log.isDebugEnabled()) {
            log.debug("Clear used caches");
        }
        this.doLocalClear();
        this.cacheDistributor.clear();
    }

    private void doLocalCache(Identity oid, Object obj, int type) {
        this.objectBuffer.put(oid, new ObjectEntry(obj, type));
    }

    private void pushObjects() {
        Iterator it = this.objectBuffer.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ObjectEntry oe = (ObjectEntry)entry.getValue();
            if (log.isDebugEnabled()) {
                log.debug("Push to cache: " + entry.getKey());
            }
            this.cacheDistributor.doInternalCache((Identity)entry.getKey(), oe.obj, oe.type);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class ObjectEntry {
        Object obj;
        int type;

        public ObjectEntry(Object obj, int type) {
            this.obj = obj;
            this.type = type;
        }
    }
}

