/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.conversions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.ojb.broker.accesslayer.conversions.ConversionException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;
import org.apache.ojb.broker.util.Base64;

public class Object2Base64StringFieldConversion
implements FieldConversion {
    private ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
    private Base64.OutputStream uuOut = new Base64.OutputStream(this.byteOut, true, false);
    private GZIPOutputStream gzipOut;
    private ObjectOutputStream objOut;

    public Object javaToSql(Object source) {
        ByteArrayOutputStream byteArrayOutputStream = this.byteOut;
        synchronized (byteArrayOutputStream) {
            try {
                if (this.gzipOut == null) {
                    this.gzipOut = new GZIPOutputStream(this.uuOut);
                    this.objOut = new ObjectOutputStream(this.gzipOut);
                }
                this.byteOut.reset();
                this.objOut.writeObject(source);
                this.objOut.flush();
                this.gzipOut.finish();
                this.gzipOut.flush();
                return this.byteOut.toString();
            }
            catch (Throwable t) {
                throw new ConversionException(t);
            }
        }
    }

    public Object sqlToJava(Object source) {
        try {
            ByteArrayInputStream stringIn = new ByteArrayInputStream(((String)source).getBytes());
            Base64.InputStream uuIn = new Base64.InputStream(stringIn, false, false);
            GZIPInputStream gzipIn = new GZIPInputStream(uuIn);
            ObjectInputStream objIn = new ObjectInputStream(gzipIn);
            Object result = objIn.readObject();
            objIn.close();
            return result;
        }
        catch (Throwable t) {
            throw new ConversionException(t);
        }
    }
}

