/* 
 * Copyright 2022, Emanuel Rabina (http://www.ultraq.net.nz/)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nz.net.ultraq.thymeleaf.layoutdialect

import org.slf4j.Logger
import org.slf4j.LoggerFactory

import groovy.transform.CompileStatic
import groovy.transform.stc.POJO

/**
 * A no-Groovy wrapper around SLF4J's {@link LoggerFactory#getLogger(Class)}
 * method`.  This is to get around a bug when the bytecode generated by
 * `groovyc` is then run through Azul's Zulu 8 JDK.  The problem seems to arise
 * from a static context invoking that method, so the fix is to instantiate this
 * class, then use its {@link #getLogger)} method which then calls SLF4J's
 * method in a non-static context 🙃
 * <p>
 * This isn't a great fix, and should be removed either if the bug in
 * Groovy/Azul is fixed, a better workaround is discovered, or Java 8 support is
 * dropped.
 * 
 * @author Emanuel Rabina
 * @see <a href="https://github.com/ultraq/thymeleaf-layout-dialect/issues/230">thymeleaf-layout-dialect/230</a>
 */
@CompileStatic
@POJO
class PojoLoggerFactory {

	@SuppressWarnings('GrMethodMayBeStatic')
	Logger getLogger(Class<?> clazz) {

		return LoggerFactory.getLogger(clazz)
	}
}
