/*
 * Decompiled with CFR 0.152.
 */
package nz.net.osnz.common.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import nz.net.osnz.common.jackson.JacksonException;

public class JacksonHelper {
    private static ObjectMapper mapper;

    public static String serialize(Object object) throws JacksonException {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (Exception exception) {
            throw new JacksonException(exception);
        }
    }

    public static <T> T deserialize(String string, Class<T> clazz) throws JacksonException {
        try {
            return (T)mapper.readValue(string, clazz);
        }
        catch (Exception exception) {
            throw new JacksonException(exception);
        }
    }

    static {
        JsonFactory jsonFactory = new JsonFactory();
        mapper = new ObjectMapper(jsonFactory).registerModule((Module)new JavaTimeModule());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_IS_GETTERS});
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

