/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.border.TitledBorder;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.EvaluationUtils;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.classifiers.functions.Logistic;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class ThresholdVisualizePanel
extends VisualizePanel {
    private static final long serialVersionUID = 3070002211779443890L;
    private String m_ROCString = "";
    private String m_savePanelBorderText;

    public ThresholdVisualizePanel() {
        TitledBorder tb = (TitledBorder)this.m_plotSurround.getBorder();
        this.m_savePanelBorderText = tb.getTitle();
    }

    public void setROCString(String str) {
        this.m_ROCString = str;
    }

    public String getROCString() {
        return this.m_ROCString;
    }

    @Override
    public void setUpComboBoxes(Instances inst) {
        super.setUpComboBoxes(inst);
        this.m_XCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThresholdVisualizePanel.this.setBorderText();
            }
        });
        this.m_YCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThresholdVisualizePanel.this.setBorderText();
            }
        });
        this.setBorderText();
    }

    private void setBorderText() {
        String xs = this.m_XCombo.getSelectedItem().toString();
        String ys = this.m_YCombo.getSelectedItem().toString();
        if (xs.equals("X: False Positive Rate (Num)") && ys.equals("Y: True Positive Rate (Num)")) {
            this.m_plotSurround.setBorder(BorderFactory.createTitledBorder(this.m_savePanelBorderText + " " + this.m_ROCString));
        } else {
            this.m_plotSurround.setBorder(BorderFactory.createTitledBorder(this.m_savePanelBorderText));
        }
    }

    @Override
    protected void openVisibleInstances(Instances insts) throws Exception {
        super.openVisibleInstances(insts);
        this.setROCString("(Area under ROC = " + Utils.doubleToString(ThresholdCurve.getROCArea(insts), 4) + ")");
        this.setBorderText();
    }

    public static void main(String[] args) {
        Instances inst = null;
        Classifier classifier = null;
        int runs = 2;
        int folds = 10;
        boolean compute = true;
        Instances result = null;
        SingleIndex classIndex = null;
        SingleIndex valueIndex = null;
        int seed = 1;
        try {
            if (Utils.getFlag('h', args)) {
                System.out.println("\nOptions for " + ThresholdVisualizePanel.class.getName() + ":\n");
                System.out.println("-h\n\tThis help.");
                System.out.println("-t <file>\n\tDataset to process with given classifier.");
                System.out.println("-c <num>\n\tThe class index. first and last are valid, too (default: last).");
                System.out.println("-C <num>\n\tThe index of the class value to get the the curve for (default: first).");
                System.out.println("-W <classname>\n\tFull classname of classifier to run.\n\tOptions after '--' are passed to the classifier.\n\t(default: weka.classifiers.functions.Logistic)");
                System.out.println("-r <number>\n\tThe number of runs to perform (default: 1).");
                System.out.println("-x <number>\n\tThe number of Cross-validation folds (default: 10).");
                System.out.println("-S <number>\n\tThe seed value for randomizing the data (default: 1).");
                System.out.println("-l <file>\n\tPreviously saved threshold curve ARFF file.");
                return;
            }
            String tmpStr = Utils.getOption('l', args);
            if (tmpStr.length() != 0) {
                result = new Instances(new BufferedReader(new FileReader(tmpStr)));
                compute = false;
            }
            if (compute) {
                String[] options;
                tmpStr = Utils.getOption('r', args);
                runs = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 1;
                tmpStr = Utils.getOption('x', args);
                folds = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 10;
                tmpStr = Utils.getOption('S', args);
                seed = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 1;
                tmpStr = Utils.getOption('t', args);
                if (tmpStr.length() != 0) {
                    inst = new Instances(new BufferedReader(new FileReader(tmpStr)));
                    inst.setClassIndex(inst.numAttributes() - 1);
                }
                if ((tmpStr = Utils.getOption('W', args)).length() != 0) {
                    options = Utils.partitionOptions(args);
                } else {
                    tmpStr = Logistic.class.getName();
                    options = new String[]{};
                }
                classifier = AbstractClassifier.forName(tmpStr, options);
                tmpStr = Utils.getOption('c', args);
                classIndex = tmpStr.length() != 0 ? new SingleIndex(tmpStr) : new SingleIndex("last");
                tmpStr = Utils.getOption('C', args);
                valueIndex = tmpStr.length() != 0 ? new SingleIndex(tmpStr) : new SingleIndex("first");
            }
            if (compute) {
                if (classIndex != null) {
                    classIndex.setUpper(inst.numAttributes() - 1);
                    inst.setClassIndex(classIndex.getIndex());
                } else {
                    inst.setClassIndex(inst.numAttributes() - 1);
                }
                if (valueIndex != null) {
                    valueIndex.setUpper(inst.classAttribute().numValues() - 1);
                }
                ThresholdCurve tc = new ThresholdCurve();
                EvaluationUtils eu = new EvaluationUtils();
                FastVector predictions = new FastVector();
                for (int i = 0; i < runs; ++i) {
                    eu.setSeed(seed + i);
                    predictions.appendElements(eu.getCVPredictions(classifier, inst, folds));
                }
                result = valueIndex != null ? tc.getCurve(predictions, valueIndex.getIndex()) : tc.getCurve(predictions);
            }
            ThresholdVisualizePanel vmc = new ThresholdVisualizePanel();
            vmc.setROCString("(Area under ROC = " + Utils.doubleToString(ThresholdCurve.getROCArea(result), 4) + ")");
            if (compute) {
                vmc.setName(result.relationName() + ". (Class value " + inst.classAttribute().value(valueIndex.getIndex()) + ")");
            } else {
                vmc.setName(result.relationName() + " (display only)");
            }
            PlotData2D tempd = new PlotData2D(result);
            tempd.setPlotName(result.relationName());
            tempd.addInstanceNumberAttribute();
            vmc.addPlot(tempd);
            String plotName = vmc.getName();
            final JFrame jf = new JFrame("Weka Classifier Visualize: " + plotName);
            jf.setSize(500, 400);
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)vmc, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

