/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.CustomDisplayStringProvider;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Range
implements Serializable,
RevisionHandler,
CustomDisplayStringProvider {
    static final long serialVersionUID = 3667337062176835900L;
    Vector m_RangeStrings = new Vector();
    boolean m_Invert;
    boolean[] m_SelectFlags;
    int m_Upper = -1;

    public Range() {
    }

    public Range(String rangeList) {
        this.setRanges(rangeList);
    }

    public void setUpper(int newUpper) {
        if (newUpper >= 0) {
            this.m_Upper = newUpper;
            this.setFlags();
        }
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public void setInvert(boolean newSetting) {
        this.m_Invert = newSetting;
    }

    public String getRanges() {
        StringBuffer result = new StringBuffer(this.m_RangeStrings.size() * 4);
        boolean first = true;
        char sep = ',';
        for (int i = 0; i < this.m_RangeStrings.size(); ++i) {
            if (first) {
                result.append((String)this.m_RangeStrings.elementAt(i));
                first = false;
                continue;
            }
            result.append(sep + (String)this.m_RangeStrings.elementAt(i));
        }
        return result.toString();
    }

    public void setRanges(String rangeList) {
        Vector<String> ranges = new Vector<String>(10);
        while (!rangeList.equals("")) {
            String range = rangeList.trim();
            int commaLoc = rangeList.indexOf(44);
            if (commaLoc != -1) {
                range = rangeList.substring(0, commaLoc).trim();
                rangeList = rangeList.substring(commaLoc + 1).trim();
            } else {
                rangeList = "";
            }
            if (range.equals("")) continue;
            ranges.addElement(range);
        }
        this.m_RangeStrings = ranges;
        this.m_SelectFlags = null;
    }

    public boolean isInRange(int index) {
        if (this.m_Upper == -1) {
            throw new RuntimeException("No upper limit has been specified for range");
        }
        if (this.m_Invert) {
            return !this.m_SelectFlags[index];
        }
        return this.m_SelectFlags[index];
    }

    public String toString() {
        if (this.m_RangeStrings.size() == 0) {
            return "Empty";
        }
        String result = "Strings: ";
        Enumeration enu = this.m_RangeStrings.elements();
        while (enu.hasMoreElements()) {
            result = result + (String)enu.nextElement() + " ";
        }
        result = result + "\n";
        result = result + "Invert: " + this.m_Invert + "\n";
        try {
            if (this.m_Upper == -1) {
                throw new RuntimeException("Upper limit has not been specified");
            }
            String cols = null;
            for (int i = 0; i < this.m_SelectFlags.length; ++i) {
                if (!this.isInRange(i)) continue;
                cols = cols == null ? "Cols: " + (i + 1) : cols + "," + (i + 1);
            }
            if (cols != null) {
                result = result + cols + "\n";
            }
        }
        catch (Exception ex) {
            result = result + ex.getMessage();
        }
        return result;
    }

    public int[] getSelection() {
        if (this.m_Upper == -1) {
            throw new RuntimeException("No upper limit has been specified for range");
        }
        int[] selectIndices = new int[this.m_Upper + 1];
        int numSelected = 0;
        if (this.m_Invert) {
            for (int i = 0; i <= this.m_Upper; ++i) {
                if (this.m_SelectFlags[i]) continue;
                selectIndices[numSelected++] = i;
            }
        } else {
            Enumeration enu = this.m_RangeStrings.elements();
            while (enu.hasMoreElements()) {
                String currentRange = (String)enu.nextElement();
                int start = this.rangeLower(currentRange);
                int end = this.rangeUpper(currentRange);
                for (int i = start; i <= this.m_Upper && i <= end; ++i) {
                    if (!this.m_SelectFlags[i]) continue;
                    selectIndices[numSelected++] = i;
                }
            }
        }
        int[] result = new int[numSelected];
        System.arraycopy(selectIndices, 0, result, 0, numSelected);
        return result;
    }

    public static String indicesToRangeList(int[] indices) {
        StringBuffer rl = new StringBuffer();
        int last = -2;
        boolean range = false;
        for (int i = 0; i < indices.length; ++i) {
            if (i == 0) {
                rl.append(indices[i] + 1);
            } else if (indices[i] == last) {
                range = true;
            } else {
                if (range) {
                    rl.append('-').append(last);
                    range = false;
                }
                rl.append(',').append(indices[i] + 1);
            }
            last = indices[i] + 1;
        }
        if (range) {
            rl.append('-').append(last);
        }
        return rl.toString();
    }

    protected void setFlags() {
        this.m_SelectFlags = new boolean[this.m_Upper + 1];
        Enumeration enu = this.m_RangeStrings.elements();
        while (enu.hasMoreElements()) {
            String currentRange = (String)enu.nextElement();
            if (!this.isValidRange(currentRange)) {
                throw new IllegalArgumentException("Invalid range list at " + currentRange);
            }
            int start = this.rangeLower(currentRange);
            int end = this.rangeUpper(currentRange);
            for (int i = start; i <= this.m_Upper && i <= end; ++i) {
                this.m_SelectFlags[i] = true;
            }
        }
    }

    protected int rangeSingle(String single) {
        if (single.toLowerCase().equals("first")) {
            return 0;
        }
        if (single.toLowerCase().equals("last")) {
            return this.m_Upper;
        }
        int index = Integer.parseInt(single) - 1;
        if (index < 0) {
            index = 0;
        }
        if (index > this.m_Upper) {
            index = this.m_Upper;
        }
        return index;
    }

    protected int rangeLower(String range) {
        int hyphenIndex = range.indexOf(45);
        if (hyphenIndex >= 0) {
            return Math.min(this.rangeLower(range.substring(0, hyphenIndex)), this.rangeLower(range.substring(hyphenIndex + 1)));
        }
        return this.rangeSingle(range);
    }

    protected int rangeUpper(String range) {
        int hyphenIndex = range.indexOf(45);
        if (hyphenIndex >= 0) {
            return Math.max(this.rangeUpper(range.substring(0, hyphenIndex)), this.rangeUpper(range.substring(hyphenIndex + 1)));
        }
        return this.rangeSingle(range);
    }

    protected boolean isValidRange(String range) {
        if (range == null) {
            return false;
        }
        int hyphenIndex = range.indexOf(45);
        if (hyphenIndex >= 0) {
            return this.isValidRange(range.substring(0, hyphenIndex)) && this.isValidRange(range.substring(hyphenIndex + 1));
        }
        if (range.toLowerCase().equals("first")) {
            return true;
        }
        if (range.toLowerCase().equals("last")) {
            return true;
        }
        try {
            int index = Integer.parseInt(range);
            return index > 0 && index <= this.m_Upper + 1;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    @Override
    public String toDisplay() {
        if (this.getInvert()) {
            return "inv(" + this.getRanges() + ")";
        }
        return this.getRanges();
    }

    public static void main(String[] argv) {
        try {
            if (argv.length == 0) {
                throw new Exception("Usage: Range <rangespec>");
            }
            Range range = new Range();
            range.setRanges(argv[0]);
            range.setUpper(9);
            range.setInvert(false);
            System.out.println("Input: " + argv[0] + "\n" + range.toString());
            int[] rangeIndices = range.getSelection();
            for (int i = 0; i < rangeIndices.length; ++i) {
                System.out.print(" " + (rangeIndices[i] + 1));
            }
            System.out.println("");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }
}

