/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.matrix.EigenvalueDecomposition;
import weka.core.matrix.LUDecomposition;
import weka.core.matrix.Maths;

public class Matrix
implements Cloneable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -3604757095849145838L;
    protected weka.core.matrix.Matrix m_Matrix = null;

    public Matrix(int nr, int nc) {
        this.m_Matrix = new weka.core.matrix.Matrix(nr, nc);
    }

    public Matrix(double[][] array) throws Exception {
        this.m_Matrix = new weka.core.matrix.Matrix(array);
    }

    public Matrix(Reader r) throws Exception {
        this.m_Matrix = new weka.core.matrix.Matrix(r);
    }

    public Object clone() {
        try {
            return new Matrix(this.m_Matrix.getArrayCopy());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void write(Writer w) throws Exception {
        this.m_Matrix.write(w);
    }

    protected weka.core.matrix.Matrix getMatrix() {
        return this.m_Matrix;
    }

    public final double getElement(int rowIndex, int columnIndex) {
        return this.m_Matrix.get(rowIndex, columnIndex);
    }

    public final void addElement(int rowIndex, int columnIndex, double value) {
        this.m_Matrix.set(rowIndex, columnIndex, this.m_Matrix.get(rowIndex, columnIndex) + value);
    }

    public final int numRows() {
        return this.m_Matrix.getRowDimension();
    }

    public final int numColumns() {
        return this.m_Matrix.getColumnDimension();
    }

    public final void setElement(int rowIndex, int columnIndex, double value) {
        this.m_Matrix.set(rowIndex, columnIndex, value);
    }

    public final void setRow(int index, double[] newRow) {
        for (int i = 0; i < newRow.length; ++i) {
            this.m_Matrix.set(index, i, newRow[i]);
        }
    }

    public double[] getRow(int index) {
        double[] newRow = new double[this.numColumns()];
        for (int i = 0; i < newRow.length; ++i) {
            newRow[i] = this.getElement(index, i);
        }
        return newRow;
    }

    public double[] getColumn(int index) {
        double[] newColumn = new double[this.numRows()];
        for (int i = 0; i < newColumn.length; ++i) {
            newColumn[i] = this.getElement(i, index);
        }
        return newColumn;
    }

    public final void setColumn(int index, double[] newColumn) {
        for (int i = 0; i < this.numRows(); ++i) {
            this.m_Matrix.set(i, index, newColumn[i]);
        }
    }

    public String toString() {
        return this.m_Matrix.toString();
    }

    public final Matrix add(Matrix other) {
        try {
            return new Matrix(this.m_Matrix.plus(other.getMatrix()).getArrayCopy());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public final Matrix transpose() {
        try {
            return new Matrix(this.m_Matrix.transpose().getArrayCopy());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isSymmetric() {
        return this.m_Matrix.isSymmetric();
    }

    public final Matrix multiply(Matrix b) {
        try {
            return new Matrix(this.getMatrix().times(b.getMatrix()).getArrayCopy());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public final double[] regression(Matrix y, double ridge) {
        return this.getMatrix().regression(y.getMatrix(), ridge).getCoefficients();
    }

    public final double[] regression(Matrix y, double[] w, double ridge) {
        return this.getMatrix().regression(y.getMatrix(), w, ridge).getCoefficients();
    }

    public Matrix getL() throws Exception {
        int nr = this.numRows();
        int nc = this.numColumns();
        double[][] ld = new double[nr][nc];
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < i && j < nc; ++j) {
                ld[i][j] = this.getElement(i, j);
            }
            if (i >= nc) continue;
            ld[i][i] = 1.0;
        }
        Matrix l = new Matrix(ld);
        return l;
    }

    public Matrix getU() throws Exception {
        int nr = this.numRows();
        int nc = this.numColumns();
        double[][] ud = new double[nr][nc];
        for (int i = 0; i < nr; ++i) {
            for (int j = i; j < nc; ++j) {
                ud[i][j] = this.getElement(i, j);
            }
        }
        Matrix u = new Matrix(ud);
        return u;
    }

    public int[] LUDecomposition() throws Exception {
        LUDecomposition lu = this.m_Matrix.lu();
        if (!lu.isNonsingular()) {
            throw new Exception("Matrix is singular");
        }
        weka.core.matrix.Matrix u = lu.getU();
        weka.core.matrix.Matrix l = lu.getL();
        int nr = this.numRows();
        int nc = this.numColumns();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                if (j < i) {
                    this.setElement(i, j, l.get(i, j));
                    continue;
                }
                this.setElement(i, j, u.get(i, j));
            }
        }
        u = null;
        l = null;
        return lu.getPivot();
    }

    public void solve(double[] bb) throws Exception {
        weka.core.matrix.Matrix x = this.m_Matrix.solve(new weka.core.matrix.Matrix(bb, bb.length));
        int nr = x.getRowDimension();
        for (int i = 0; i < nr; ++i) {
            bb[i] = x.get(i, 0);
        }
    }

    public void eigenvalueDecomposition(double[][] V, double[] d) throws Exception {
        int i;
        if (!this.isSymmetric()) {
            throw new Exception("EigenvalueDecomposition: Matrix must be symmetric.");
        }
        EigenvalueDecomposition eig = this.m_Matrix.eig();
        weka.core.matrix.Matrix v = eig.getV();
        double[] d2 = eig.getRealEigenvalues();
        int nr = this.numRows();
        int nc = this.numColumns();
        for (i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                V[i][j] = v.get(i, j);
            }
        }
        for (i = 0; i < d2.length; ++i) {
            d[i] = d2[i];
        }
    }

    protected static double hypot(double a, double b) {
        return Maths.hypot(a, b);
    }

    public String toMatlab() {
        return this.getMatrix().toMatlab();
    }

    public static Matrix parseMatlab(String matlab) throws Exception {
        return new Matrix(weka.core.matrix.Matrix.parseMatlab(matlab).getArray());
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] ops) {
        double[] first = new double[]{2.3, 1.2, 5.0};
        double[] second = new double[]{5.2, 1.4, 9.0};
        double[] response = new double[]{4.0, 7.0, 8.0};
        double[] weights = new double[]{1.0, 2.0, 3.0};
        try {
            int i;
            double[][] m = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 6.0}, {3.0, 6.0, 9.0}};
            Matrix M = new Matrix(m);
            int n = M.numRows();
            double[][] V = new double[n][n];
            double[] d = new double[n];
            double[] e = new double[n];
            M.eigenvalueDecomposition(V, d);
            Matrix v = new Matrix(V);
            Matrix a = new Matrix(2, 3);
            Matrix b = new Matrix(3, 2);
            System.out.println("Number of columns for a: " + a.numColumns());
            System.out.println("Number of rows for a: " + a.numRows());
            a.setRow(0, first);
            a.setRow(1, second);
            b.setColumn(0, first);
            b.setColumn(1, second);
            System.out.println("a:\n " + a);
            System.out.println("b:\n " + b);
            System.out.println("a (0, 0): " + a.getElement(0, 0));
            System.out.println("a transposed:\n " + a.transpose());
            System.out.println("a * b:\n " + a.multiply(b));
            Matrix r = new Matrix(3, 1);
            r.setColumn(0, response);
            System.out.println("r:\n " + r);
            System.out.println("Coefficients of regression of b on r: ");
            double[] coefficients = b.regression(r, 1.0E-8);
            for (i = 0; i < coefficients.length; ++i) {
                System.out.print(coefficients[i] + " ");
            }
            System.out.println();
            System.out.println("Weights: ");
            for (i = 0; i < weights.length; ++i) {
                System.out.print(weights[i] + " ");
            }
            System.out.println();
            System.out.println("Coefficients of weighted regression of b on r: ");
            coefficients = b.regression(r, weights, 1.0E-8);
            for (i = 0; i < coefficients.length; ++i) {
                System.out.print(coefficients[i] + " ");
            }
            System.out.println();
            a.setElement(0, 0, 6.0);
            System.out.println("a with (0, 0) set to 6:\n " + a);
            a.write(new FileWriter("main.matrix"));
            System.out.println("wrote matrix to \"main.matrix\"\n" + a);
            a = new Matrix(new FileReader("main.matrix"));
            System.out.println("read matrix from \"main.matrix\"\n" + a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

