/*
 * Decompiled with CFR 0.152.
 */
package no.sparebank1.turbo;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SourceFileFinder {
    public List<String> getSourceFiles(String projectRoot, String ignoreChangesInFiles) {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        List<String> filesInProjectRoot = this.findFilesInDir(projectRoot);
        sourceFiles.addAll(filesInProjectRoot);
        List<String> filesInSrc = this.findFilesInDirRecursively(projectRoot + "/src");
        sourceFiles.addAll(filesInSrc);
        List<String> prunedSourcefiles = this.pruneSourefiles(sourceFiles, ignoreChangesInFiles);
        return prunedSourcefiles;
    }

    List<String> pruneSourefiles(List<String> sourcefiles, String ignoreChangesInFiles) {
        ArrayList<String> prunedSourcefiles = new ArrayList<String>(sourcefiles);
        sourcefiles.forEach(sourcefile -> {
            if (sourcefile.contains("swagger.json") || sourcefile.contains(".iml") || sourcefile.contains("editorconfig") || sourcefile.contains("docker-image-id")) {
                prunedSourcefiles.remove(sourcefile);
            }
        });
        return prunedSourcefiles;
    }

    List<String> findFilesInDir(String dir) {
        File dirFile = new File(dir);
        List<File> list = Arrays.asList(dirFile.listFiles());
        return list.stream().filter(file -> !file.isDirectory()).map(file -> file.getAbsolutePath()).collect(Collectors.toList());
    }

    List<String> findFilesInDirRecursively(String dir) {
        File file = new File(dir);
        File[] filesInDir = file.listFiles();
        ArrayList<String> sourcefiles = new ArrayList<String>();
        if (filesInDir != null) {
            for (int fileNo = 0; fileNo < filesInDir.length; ++fileNo) {
                if (filesInDir[fileNo].isDirectory()) {
                    List<String> filesInSubDir = this.findFilesInDirRecursively(filesInDir[fileNo].getAbsolutePath());
                    sourcefiles.addAll(filesInSubDir);
                    continue;
                }
                sourcefiles.add(filesInDir[fileNo].getAbsolutePath());
            }
        }
        return sourcefiles;
    }
}

