/*
 * Decompiled with CFR 0.152.
 */
package no.sparebank1.turbo;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import no.sparebank1.turbo.ArtifactAnalyzer;
import no.sparebank1.turbo.SourceFileFinder;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;

public class ProjectsAnalyzer {
    private final SourceFileFinder sourceFileFinder;
    private final ArtifactAnalyzer artifactAnalyzer;

    public ProjectsAnalyzer(ArtifactAnalyzer artifactAnalyzer, SourceFileFinder sourceFileFinder) {
        this.artifactAnalyzer = artifactAnalyzer;
        this.sourceFileFinder = sourceFileFinder;
    }

    public List<MavenProject> calculateProjectsToBuild(String m2Repository, List<MavenProject> projects, ProjectDependencyGraph projectDependencyGraph, String ignoreChangesInFiles, String alwaysBuildModules) {
        List projectsToBuild = projects.stream().filter(project -> this.shallBuildProject(m2Repository, (MavenProject)project, ignoreChangesInFiles, alwaysBuildModules)).distinct().collect(Collectors.toList());
        ArrayList downstreamProjects = new ArrayList();
        projectsToBuild.stream().forEach(project -> downstreamProjects.addAll(projectDependencyGraph.getDownstreamProjects(project, true)));
        projectsToBuild.addAll(downstreamProjects);
        return projectsToBuild.stream().distinct().collect(Collectors.toList());
    }

    protected boolean shallBuildProject(String m2Repository, MavenProject project, String ignoreChangesInFiles, String alwaysBuildModules) {
        List<String> sourceFiles = this.sourceFileFinder.getSourceFiles(project.getBasedir().getAbsolutePath(), ignoreChangesInFiles);
        return this.artifactAnalyzer.shallBuild(m2Repository, sourceFiles, project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging(), alwaysBuildModules);
    }
}

