/*
 * Decompiled with CFR 0.152.
 */
package no.sparebank1.turbo;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Checksum {
    public static byte[] createChecksum(String filename) {
        FileInputStream fis = null;
        try {
            int numRead;
            fis = new FileInputStream(filename);
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byte[] byArray = complete.digest();
            return byArray;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot create MD5 checksum for file " + filename);
        }
        finally {
            try {
                ((InputStream)fis).close();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot close file handle for file " + filename);
            }
        }
    }

    public static String getMD5Checksum(String filename) {
        byte[] b = MD5Checksum.createChecksum(filename);
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }
}

