/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble.data;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Data
implements Parcelable {
    private static char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    public static final int FORMAT_UINT8 = 17;
    public static final int FORMAT_UINT16 = 18;
    public static final int FORMAT_UINT24 = 19;
    public static final int FORMAT_UINT32 = 20;
    public static final int FORMAT_SINT8 = 33;
    public static final int FORMAT_SINT16 = 34;
    public static final int FORMAT_SINT24 = 35;
    public static final int FORMAT_SINT32 = 36;
    public static final int FORMAT_SFLOAT = 50;
    public static final int FORMAT_FLOAT = 52;
    protected byte[] mValue;
    public static final Parcelable.Creator<Data> CREATOR = new Parcelable.Creator<Data>(){

        public Data createFromParcel(Parcel in) {
            return new Data(in);
        }

        public Data[] newArray(int size) {
            return new Data[size];
        }
    };

    public Data() {
        this.mValue = null;
    }

    public Data(@Nullable byte[] value) {
        this.mValue = value;
    }

    public static Data from(@NonNull String value) {
        return new Data(value.getBytes());
    }

    public static Data from(@NonNull BluetoothGattCharacteristic characteristic) {
        return new Data(characteristic.getValue());
    }

    public static Data from(@NonNull BluetoothGattDescriptor descriptor) {
        return new Data(descriptor.getValue());
    }

    public static Data opCode(byte opCode) {
        return new Data(new byte[]{opCode});
    }

    public static Data opCode(byte opCode, byte parameter) {
        return new Data(new byte[]{opCode, parameter});
    }

    @Nullable
    public byte[] getValue() {
        return this.mValue;
    }

    @Nullable
    public String getStringValue(@IntRange(from=0L) int offset) {
        if (this.mValue == null || offset > this.mValue.length) {
            return null;
        }
        byte[] strBytes = new byte[this.mValue.length - offset];
        for (int i = 0; i != this.mValue.length - offset; ++i) {
            strBytes[i] = this.mValue[offset + i];
        }
        return new String(strBytes);
    }

    public int size() {
        return this.mValue != null ? this.mValue.length : 0;
    }

    @NonNull
    public String toString() {
        if (this.size() == 0) {
            return "";
        }
        char[] out = new char[this.mValue.length * 3 - 1];
        for (int j = 0; j < this.mValue.length; ++j) {
            int v = this.mValue[j] & 0xFF;
            out[j * 3] = HEX_ARRAY[v >>> 4];
            out[j * 3 + 1] = HEX_ARRAY[v & 0xF];
            if (j == this.mValue.length - 1) continue;
            out[j * 3 + 2] = 45;
        }
        return "(0x) " + new String(out);
    }

    @Nullable
    public Byte getByte(@IntRange(from=0L) int offset) {
        if (offset + 1 > this.size()) {
            return null;
        }
        return this.mValue[offset];
    }

    @Nullable
    public Integer getIntValue(int formatType, @IntRange(from=0L) int offset) {
        if (offset + Data.getTypeLen(formatType) > this.size()) {
            return null;
        }
        switch (formatType) {
            case 17: {
                return Data.unsignedByteToInt(this.mValue[offset]);
            }
            case 18: {
                return Data.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1]);
            }
            case 19: {
                return Data.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], (byte)0);
            }
            case 20: {
                return Data.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]);
            }
            case 33: {
                return Data.unsignedToSigned(Data.unsignedByteToInt(this.mValue[offset]), 8);
            }
            case 34: {
                return Data.unsignedToSigned(Data.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1]), 16);
            }
            case 35: {
                return Data.unsignedToSigned(Data.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], (byte)0), 24);
            }
            case 36: {
                return Data.unsignedToSigned(Data.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]), 32);
            }
        }
        return null;
    }

    @Nullable
    public Long getLongValue(int formatType, @IntRange(from=0L) int offset) {
        if (offset + Data.getTypeLen(formatType) > this.size()) {
            return null;
        }
        switch (formatType) {
            case 36: {
                return Data.unsignedToSigned(Data.unsignedBytesToLong(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]), 32);
            }
            case 20: {
                return Data.unsignedBytesToLong(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]);
            }
        }
        return null;
    }

    @Nullable
    public Float getFloatValue(int formatType, @IntRange(from=0L) int offset) {
        if (offset + Data.getTypeLen(formatType) > this.size()) {
            return null;
        }
        switch (formatType) {
            case 50: {
                if (this.mValue[offset + 1] == 7 && this.mValue[offset] == -2) {
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                if (this.mValue[offset + 1] == 7 && this.mValue[offset] == -1 || this.mValue[offset + 1] == 8 && this.mValue[offset] == 0 || this.mValue[offset + 1] == 8 && this.mValue[offset] == 1) {
                    return Float.valueOf(Float.NaN);
                }
                if (this.mValue[offset + 1] == 8 && this.mValue[offset] == 2) {
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
                return Float.valueOf(Data.bytesToFloat(this.mValue[offset], this.mValue[offset + 1]));
            }
            case 52: {
                if (this.mValue[offset + 3] == 0) {
                    if (this.mValue[offset + 2] == 127 && this.mValue[offset + 1] == -1) {
                        if (this.mValue[offset] == -2) {
                            return Float.valueOf(Float.POSITIVE_INFINITY);
                        }
                        if (this.mValue[offset] == -1) {
                            return Float.valueOf(Float.NaN);
                        }
                    } else if (this.mValue[offset + 2] == -128 && this.mValue[offset + 1] == 0) {
                        if (this.mValue[offset] == 0 || this.mValue[offset] == 1) {
                            return Float.valueOf(Float.NaN);
                        }
                        if (this.mValue[offset] == 2) {
                            return Float.valueOf(Float.NEGATIVE_INFINITY);
                        }
                    }
                }
                return Float.valueOf(Data.bytesToFloat(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]));
            }
        }
        return null;
    }

    public static int getTypeLen(int formatType) {
        return formatType & 0xF;
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private static long unsignedByteToLong(byte b) {
        return (long)b & 0xFFL;
    }

    private static int unsignedBytesToInt(byte b0, byte b1) {
        return Data.unsignedByteToInt(b0) + (Data.unsignedByteToInt(b1) << 8);
    }

    private static int unsignedBytesToInt(byte b0, byte b1, byte b2, byte b3) {
        return Data.unsignedByteToInt(b0) + (Data.unsignedByteToInt(b1) << 8) + (Data.unsignedByteToInt(b2) << 16) + (Data.unsignedByteToInt(b3) << 24);
    }

    private static long unsignedBytesToLong(byte b0, byte b1, byte b2, byte b3) {
        return Data.unsignedByteToLong(b0) + (Data.unsignedByteToLong(b1) << 8) + (Data.unsignedByteToLong(b2) << 16) + (Data.unsignedByteToLong(b3) << 24);
    }

    private static float bytesToFloat(byte b0, byte b1) {
        int mantissa = Data.unsignedToSigned(Data.unsignedByteToInt(b0) + ((Data.unsignedByteToInt(b1) & 0xF) << 8), 12);
        int exponent = Data.unsignedToSigned(Data.unsignedByteToInt(b1) >> 4, 4);
        return (float)((double)mantissa * Math.pow(10.0, exponent));
    }

    private static float bytesToFloat(byte b0, byte b1, byte b2, byte b3) {
        int mantissa = Data.unsignedToSigned(Data.unsignedByteToInt(b0) + (Data.unsignedByteToInt(b1) << 8) + (Data.unsignedByteToInt(b2) << 16), 24);
        return (float)((double)mantissa * Math.pow(10.0, b3));
    }

    private static int unsignedToSigned(int unsigned, int size) {
        if ((unsigned & 1 << size - 1) != 0) {
            unsigned = -1 * ((1 << size - 1) - (unsigned & (1 << size - 1) - 1));
        }
        return unsigned;
    }

    private static long unsignedToSigned(long unsigned, int size) {
        if ((unsigned & (long)(1 << size - 1)) != 0L) {
            unsigned = -1L * ((long)(1 << size - 1) - (unsigned & (long)((1 << size - 1) - 1)));
        }
        return unsigned;
    }

    protected Data(Parcel in) {
        this.mValue = in.createByteArray();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.mValue);
    }

    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FloatFormat {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LongFormat {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IntFormat {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ValueFormat {
    }
}

