/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import no.nordicsemi.android.ble.Operation;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.RequestHandler;
import no.nordicsemi.android.ble.SimpleValueRequest;
import no.nordicsemi.android.ble.callback.BeforeCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.InvalidRequestCallback;
import no.nordicsemi.android.ble.callback.MtuCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;

public final class MtuRequest
extends SimpleValueRequest<MtuCallback>
implements Operation {
    private final int value;

    MtuRequest(@NonNull Request.Type type, @IntRange(from=23L, to=517L) int mtu) {
        super(type);
        if (mtu < 23) {
            mtu = 23;
        }
        if (mtu > 517) {
            mtu = 517;
        }
        this.value = mtu;
    }

    @Override
    @NonNull
    MtuRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public MtuRequest setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public MtuRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public MtuRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public MtuRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public MtuRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public MtuRequest with(@NonNull MtuCallback callback) {
        super.with(callback);
        return this;
    }

    void notifyMtuChanged(@NonNull BluetoothDevice device, @IntRange(from=23L, to=517L) int mtu) {
        this.handler.post(() -> {
            if (this.valueCallback != null) {
                ((MtuCallback)this.valueCallback).onMtuChanged(device, mtu);
            }
        });
    }

    int getRequiredMtu() {
        return this.value;
    }
}

