/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic.extras;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.TreeSet;
import no.difi.asic.AsicUtils;
import no.difi.asic.AsicWriter;
import no.difi.asic.KeyStoreType;
import no.difi.asic.MimeType;
import no.difi.asic.SignatureHelper;
import no.difi.asic.extras.CmsEncryptedAsicAbstract;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;

public class CmsEncryptedAsicWriter
extends CmsEncryptedAsicAbstract
implements AsicWriter {
    private AsicWriter asicWriter;
    private X509Certificate certificate;
    private ASN1ObjectIdentifier cmsAlgorithm;
    private Set<String> entryNeames = new TreeSet<String>();

    public CmsEncryptedAsicWriter(AsicWriter asicWriter, X509Certificate certificate) {
        this(asicWriter, certificate, CMSAlgorithm.AES256_GCM);
    }

    public CmsEncryptedAsicWriter(AsicWriter asicWriter, X509Certificate certificate, ASN1ObjectIdentifier cmsAlgorithm) {
        this.asicWriter = asicWriter;
        this.certificate = certificate;
        this.cmsAlgorithm = cmsAlgorithm;
    }

    @Override
    public AsicWriter add(File file) throws IOException {
        return this.add(file.toPath());
    }

    @Override
    public AsicWriter add(File file, String entryName) throws IOException {
        return this.add(file.toPath(), entryName);
    }

    @Override
    public AsicWriter add(Path path) throws IOException {
        return this.add(path, path.toFile().getName());
    }

    @Override
    public AsicWriter add(Path path, String entryName) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            this.add(inputStream, entryName);
        }
        return this;
    }

    @Override
    public AsicWriter add(InputStream inputStream, String filename) throws IOException {
        return this.add(inputStream, filename, AsicUtils.detectMime(filename));
    }

    @Override
    public AsicWriter add(File file, String entryName, MimeType mimeType) throws IOException {
        return this.add(file.toPath(), entryName, mimeType);
    }

    @Override
    public AsicWriter add(Path path, String entryName, MimeType mimeType) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            this.add(inputStream, entryName, mimeType);
        }
        return this;
    }

    @Override
    public AsicWriter add(InputStream inputStream, String filename, MimeType mimeType) throws IOException {
        return this.asicWriter.add(inputStream, filename, mimeType);
    }

    public AsicWriter addEncrypted(File file) throws IOException {
        return this.addEncrypted(file.toPath());
    }

    public AsicWriter addEncrypted(File file, String entryName) throws IOException {
        return this.addEncrypted(file.toPath(), entryName);
    }

    public AsicWriter addEncrypted(Path path) throws IOException {
        return this.addEncrypted(path, path.toFile().getName());
    }

    public AsicWriter addEncrypted(Path path, String entryName) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            this.addEncrypted(inputStream, entryName);
        }
        return this;
    }

    public AsicWriter addEncrypted(InputStream inputStream, String filename) throws IOException {
        return this.addEncrypted(inputStream, filename, AsicUtils.detectMime(filename));
    }

    public AsicWriter addEncrypted(File file, String entryName, MimeType mimeType) throws IOException {
        return this.addEncrypted(file.toPath(), entryName, mimeType);
    }

    public AsicWriter addEncrypted(Path path, String entryName, MimeType mimeType) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            this.addEncrypted(inputStream, entryName, mimeType);
        }
        return this;
    }

    public AsicWriter addEncrypted(InputStream inputStream, String filename, MimeType mimeType) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteStreams.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            CMSEnvelopedDataGenerator cmsEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cmsEnvelopedDataGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(this.certificate).setProvider("BC"));
            CMSEnvelopedData data = cmsEnvelopedDataGenerator.generate((CMSTypedData)new CMSProcessableByteArray(byteArrayOutputStream.toByteArray()), new JceCMSContentEncryptorBuilder(this.cmsAlgorithm).setProvider("BC").build());
            this.entryNeames.add(filename);
            return this.asicWriter.add(new ByteArrayInputStream(data.getEncoded()), filename + ".p7m", mimeType);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public AsicWriter setRootEntryName(String name) {
        if (this.entryNeames.contains(name)) {
            name = String.format("%s.p7m", name);
        }
        return this.asicWriter.setRootEntryName(name);
    }

    @Override
    public AsicWriter sign(File keyStoreFile, String keyStorePassword, String keyPassword) throws IOException {
        return this.asicWriter.sign(keyStoreFile, keyStorePassword, keyPassword);
    }

    @Override
    public AsicWriter sign(File keyStoreFile, String keyStorePassword, String keyAlias, String keyPassword) throws IOException {
        return this.asicWriter.sign(keyStoreFile, keyStorePassword, keyAlias, keyPassword);
    }

    @Override
    public AsicWriter sign(SignatureHelper signatureHelper) throws IOException {
        return this.asicWriter.sign(signatureHelper);
    }

    @Override
    public AsicWriter sign(File keyStoreFile, String keyStorePassword, KeyStoreType keyStoreType, String keyAlias, String keyPassword) throws IOException {
        return this.asicWriter.sign(keyStoreFile, keyStorePassword, keyStoreType, keyAlias, keyPassword);
    }
}

