/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import no.difi.asic.MimeType;
import no.difi.commons.asic.jaxb.opendocument.manifest.FileEntry;
import no.difi.commons.asic.jaxb.opendocument.manifest.Manifest;

class OasisManifest {
    private static JAXBContext jaxbContext;
    private Manifest manifest = new Manifest();

    public static Manifest read(InputStream inputStream) {
        return new OasisManifest(inputStream).getManifest();
    }

    public OasisManifest(MimeType mimeType) {
        this.add("/", mimeType);
    }

    public OasisManifest(InputStream inputStream) {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            this.manifest = (Manifest)unmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to read XML as OASIS OpenDocument Manifest.", e);
        }
    }

    public void add(String path, MimeType mimeType) {
        FileEntry fileEntry = new FileEntry();
        fileEntry.setMediaType(mimeType.toString());
        fileEntry.setFullPath(path);
        this.manifest.getFileEntry().add(fileEntry);
    }

    public void append(OasisManifest oasisManifest) {
        for (FileEntry fileEntry : oasisManifest.getManifest().getFileEntry()) {
            if (fileEntry.getFullPath().equals("/")) continue;
            this.manifest.getFileEntry().add(fileEntry);
        }
    }

    public int size() {
        return this.manifest.getFileEntry().size();
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public byte[] toBytes() {
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            marshaller.marshal((Object)this.manifest, (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to create OASIS OpenDocument Manifest.", e);
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Manifest.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException(String.format("Unable to create JAXBContext: %s ", e.getMessage()), e);
        }
    }
}

