/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import no.difi.asic.AsicUtils;
import no.difi.asic.AsicWriter;
import no.difi.asic.CadesAsicWriter;
import no.difi.asic.SignatureMethod;
import no.difi.asic.XadesAsicWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsicWriterFactory {
    private static Logger logger = LoggerFactory.getLogger(AsicWriterFactory.class);
    private SignatureMethod signatureMethod;

    public static AsicWriterFactory newFactory() {
        return AsicWriterFactory.newFactory(SignatureMethod.CAdES);
    }

    public static AsicWriterFactory newFactory(SignatureMethod signatureMethod) {
        return new AsicWriterFactory(signatureMethod);
    }

    private AsicWriterFactory(SignatureMethod signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public AsicWriter newContainer(File outputDir, String filename) throws IOException {
        return this.newContainer(new File(outputDir, filename));
    }

    public AsicWriter newContainer(File file) throws IOException {
        return this.newContainer(file.toPath());
    }

    public AsicWriter newContainer(Path path) throws IOException {
        if (!AsicUtils.PATTERN_EXTENSION_ASICE.matcher(path.toString()).matches()) {
            logger.warn("ASiC-E files should use \"asice\" as file extension.");
        }
        return this.newContainer(Files.newOutputStream(path, new OpenOption[0]), true);
    }

    public AsicWriter newContainer(OutputStream outputStream) throws IOException {
        return this.newContainer(outputStream, false);
    }

    AsicWriter newContainer(OutputStream outputStream, boolean closeStreamOnClose) throws IOException {
        switch (this.signatureMethod) {
            case CAdES: {
                return new CadesAsicWriter(this.signatureMethod, outputStream, closeStreamOnClose);
            }
            case XAdES: {
                return new XadesAsicWriter(this.signatureMethod, outputStream, closeStreamOnClose);
            }
        }
        throw new IllegalStateException(String.format("Not implemented: %s", new Object[]{this.signatureMethod}));
    }
}

