/*
 * Decompiled with CFR 0.152.
 */
package no.api.freemarker.java8.time;

import freemarker.template.AdapterTemplateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import no.api.freemarker.java8.time.AbstractAdapter;
import no.api.freemarker.java8.time.AbstractChecker;
import no.api.freemarker.java8.time.AbstractFormatter;
import no.api.freemarker.java8.time.DateTimeTools;

public class LocalDateAdapter
extends AbstractAdapter<LocalDate>
implements AdapterTemplateModel,
TemplateScalarModel,
TemplateHashModel {
    public LocalDateAdapter(LocalDate obj) {
        super(obj);
    }

    public TemplateModel get(String s) throws TemplateModelException {
        if ("format".equals(s)) {
            return new LocalDateFormatter((LocalDate)this.getObject());
        }
        if ("isEqual".equals(s) || "isAfter".equals(s) || "isBefore".equals(s)) {
            return new LocalDateChecker((LocalDate)this.getObject(), s);
        }
        throw new TemplateModelException("Unknown method call: " + s);
    }

    public class LocalDateChecker
    extends AbstractChecker<LocalDate>
    implements TemplateMethodModelEx {
        private String method;

        public LocalDateChecker(LocalDate obj, String method) {
            super(obj);
            this.method = method;
        }

        public Object exec(List list) throws TemplateModelException {
            LocalDateAdapter adapter = (LocalDateAdapter)((Object)list.get(0));
            switch (this.method) {
                case "isEqual": {
                    return ((LocalDate)this.getObject()).isEqual((ChronoLocalDate)adapter.getObject());
                }
                case "isAfter": {
                    return ((LocalDate)this.getObject()).isAfter((ChronoLocalDate)adapter.getObject());
                }
                case "isBefore": {
                    return ((LocalDate)this.getObject()).isBefore((ChronoLocalDate)adapter.getObject());
                }
            }
            throw new TemplateModelException("method not implemented");
        }
    }

    public class LocalDateFormatter
    extends AbstractFormatter<LocalDate>
    implements TemplateMethodModelEx {
        public LocalDateFormatter(LocalDate obj) {
            super(obj);
        }

        public Object exec(List list) throws TemplateModelException {
            return ((LocalDate)this.getObject()).format(DateTimeTools.createDateTimeFormatter(list, 0, DateTimeFormatter.ISO_LOCAL_DATE));
        }
    }
}

