/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.xpath.utils;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XPathTextUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XPathTextUtils.class);
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ", (TimeZone)TimeZone.getDefault(), (Locale)Locale.ENGLISH);

    private XPathTextUtils() {
    }

    public static String stringToXPathLiteral(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        return str.replaceAll("'", "\"");
    }

    public static String stringToJCRSearchExp(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        String parseString = StringUtils.trimToEmpty((String)str);
        parseString = StringUtils.replaceEach((String)parseString, (String[])new String[]{":)", ":("}, (String[])new String[]{": )", ": ("});
        String escapeChars = "[\\\\+\\-\\!\\(\\)\\:\\^\\]\\{\\}\\~\\*\\?\"\\[\\]|]";
        parseString = parseString.replaceAll(escapeChars, "\\\\$0");
        if (StringUtils.startsWith((CharSequence)(parseString = parseString.replaceAll("'", "''")), (CharSequence)"OR ")) {
            parseString = parseString.replaceFirst("\\bOR\\b", "\"OR\"");
        }
        return parseString;
    }

    public static String encodeDigitsInPath(String path) {
        log.debug("path to encode is {}", (Object)path);
        if (StringUtils.isBlank((CharSequence)path)) {
            String msg = "path cannot be a null or empty string";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        StringBuilder encodedPath = new StringBuilder(path.length());
        int inXpathCondition = 0;
        boolean xpathWithFunction = false;
        for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            if (i > 0 && path.charAt(i - 1) == '/' && Character.isDigit(ch)) {
                encodedPath.append("_x").append(StringUtils.leftPad((String)Integer.toHexString(ch), (int)4, (char)'0')).append("_");
                continue;
            }
            if (i > 0 && path.charAt(i - 1) == '/' && ch == '-') {
                encodedPath.append("_x002d_");
                continue;
            }
            if (inXpathCondition <= 0 && ch == ' ') {
                encodedPath.append("_x0020_");
                continue;
            }
            if (inXpathCondition <= 0 && ch == ',') {
                encodedPath.append("_x002c_");
                continue;
            }
            if (inXpathCondition <= 0 && ch == '\u00b0') {
                encodedPath.append("_x00b0_");
                continue;
            }
            if (inXpathCondition <= 0 && ch == '$') {
                encodedPath.append("_x0024_");
                continue;
            }
            if (ch == '[') {
                ++inXpathCondition;
            } else if (ch == '(') {
                if (StringUtils.endsWith((CharSequence)StringUtils.substring((String)path, (int)0, (int)i), (CharSequence)"element")) {
                    ++inXpathCondition;
                    xpathWithFunction = true;
                } else if (inXpathCondition == 0) {
                    encodedPath.append("_x0028_");
                    continue;
                }
            } else if (inXpathCondition > 0 && ch == ']') {
                --inXpathCondition;
            } else if (ch == ')') {
                if (inXpathCondition > 0 && xpathWithFunction) {
                    --inXpathCondition;
                    xpathWithFunction = false;
                } else if (inXpathCondition == 0) {
                    encodedPath.append("_x0029_");
                    continue;
                }
            }
            encodedPath.append(ch);
        }
        log.debug("returning encoded path {}", (Object)encodedPath);
        return encodedPath.toString();
    }

    public static String toXsdDate(Calendar date) {
        if (date == null) {
            return null;
        }
        String xsdDate = DATE_FORMAT.format(date);
        int length = xsdDate.length();
        return StringUtils.substring((String)xsdDate, (int)0, (int)(length - 2)) + ":" + StringUtils.substring((String)xsdDate, (int)(length - 2), (int)length);
    }

    public static String toXPath(String path) {
        if (!XPathTextUtils.isValidNodePath(path)) {
            throw new IllegalArgumentException("Path " + path + " is not a valid JCR node path");
        }
        if (path.equals("/")) {
            return "//*";
        }
        return XPathTextUtils.encodeDigitsInPath("/jcr:root" + StringUtils.removeEnd((String)path, (String)"/") + "//*");
    }

    public static boolean isValidNodePath(String path) {
        return path != null && ("//*".equals(path) || path.startsWith("/") && !path.contains("//") && !path.contains("*") && !path.contains("(") && !path.contains(")"));
    }
}

