/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.xpath;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class XPathSelect {
    private String type;
    private String root;
    private String predicate;
    private String orderByClause;
    private int guesstimatedBufferSize = 20;

    public String toStatementString() {
        String r;
        StringBuilder buf = new StringBuilder(this.guesstimatedBufferSize);
        String string = r = this.root == null ? "//*" : this.root;
        if (r.startsWith("//")) {
            r = r.substring(2);
            buf.append("//");
        } else if (r.startsWith("/")) {
            r = r.substring(1);
            buf.append('/');
        }
        if (this.type != null) {
            buf.append("element(");
        }
        buf.append(r);
        if (this.type != null) {
            buf.append(", ").append(this.type.replace("{http://www.jcp.org/jcr/nt/1.0}", "nt:")).append(")");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.predicate)) {
            buf.append("[").append(this.predicate).append("]");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.orderByClause)) {
            buf.append(" order by ").append(this.orderByClause);
        }
        return buf.toString();
    }

    public XPathSelect setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
        this.guesstimatedBufferSize += orderByClause.length();
        return this;
    }

    public XPathSelect setRoot(String root) {
        this.root = root;
        this.guesstimatedBufferSize += root.length();
        return this;
    }

    public XPathSelect setPredicate(String predicate) {
        this.predicate = predicate;
        this.guesstimatedBufferSize += predicate.length();
        return this;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }
}

