/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.xpath;

import nl.vpro.jcr.criteria.query.Criteria;
import nl.vpro.jcr.criteria.query.JCRQueryException;
import nl.vpro.jcr.criteria.query.TranslatableCriteria;
import org.apache.commons.lang3.StringUtils;

public class CriteriaQueryTranslator {
    private final TranslatableCriteria criteria;

    public CriteriaQueryTranslator(TranslatableCriteria criteria) throws JCRQueryException {
        this.criteria = criteria;
    }

    public Criteria getRootCriteria() {
        return this.criteria;
    }

    public String getPredicate() {
        StringBuilder condition = new StringBuilder(30);
        boolean isfirst = true;
        for (TranslatableCriteria.CriterionEntry entry : this.criteria.getCriterionEntries()) {
            String xpathString = entry.getCriterion().toXPathString(entry.getCriteria());
            if (!StringUtils.isNotBlank((CharSequence)xpathString)) continue;
            if (!isfirst && StringUtils.isNotBlank((CharSequence)xpathString)) {
                condition.append(" and ");
            }
            condition.append(xpathString);
            isfirst = false;
        }
        return condition.toString();
    }

    public String getOrderBy() {
        StringBuilder orderBy = new StringBuilder(30);
        for (TranslatableCriteria.OrderEntry oe : this.criteria.getOrderEntries()) {
            if (orderBy.length() > 0) {
                orderBy.append(", ");
            }
            orderBy.append(oe.getOrder().toXPathString(oe.getCriteria()));
        }
        return orderBy.toString();
    }
}

