/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.sql2;

import java.time.ZoneId;
import java.util.Calendar;
import nl.vpro.jcr.criteria.query.criterion.Op;
import nl.vpro.jcr.criteria.query.sql2.BooleanSimpleExpressionCondition;
import nl.vpro.jcr.criteria.query.sql2.CastFromStringSimpleExpressionCondition;
import nl.vpro.jcr.criteria.query.sql2.Condition;
import nl.vpro.jcr.criteria.query.sql2.Field;
import nl.vpro.jcr.criteria.query.sql2.NumberSimpleExpressionCondition;
import nl.vpro.jcr.criteria.query.sql2.StringSimpleExpressionCondition;
import nl.vpro.jcr.utils.Utils;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class SimpleExpressionCondition<T>
implements Condition {
    final Field field;
    final Op op;
    final T value;

    protected SimpleExpressionCondition(@NonNull Field field, @NonNull Op op, @NonNull T value) {
        this.field = field;
        this.op = op;
        this.value = value;
    }

    abstract String getValue();

    @Override
    public boolean toSql2(StringBuilder builder) {
        this.field.toSql2(builder);
        builder.append(" ").append(this.op.getXpath()).append(" ").append(this.getValue());
        return true;
    }

    public static SimpleExpressionCondition<?> of(Field field, Op op, Object v, ZoneId zoneId) {
        v = Utils.toCalendarIfPossible(v, zoneId);
        if (v instanceof CharSequence) {
            return new StringSimpleExpressionCondition(field, op, v.toString());
        }
        if (v instanceof Boolean) {
            return new BooleanSimpleExpressionCondition(field, op, (Boolean)v);
        }
        if (v instanceof Number) {
            return new NumberSimpleExpressionCondition(field, op, (Number)v);
        }
        if (v instanceof Calendar) {
            return new CastFromStringSimpleExpressionCondition("date", field, op, ValueFactoryImpl.getInstance().createValue((Calendar)v).getString());
        }
        throw new UnsupportedOperationException("Unrecognized " + v.getClass() + " " + v);
    }
}

