/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.sql2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import nl.vpro.jcr.criteria.query.TranslatableCriteria;
import nl.vpro.jcr.criteria.query.impl.AbstractCriteriaImpl;
import nl.vpro.jcr.criteria.query.impl.Column;
import nl.vpro.jcr.criteria.query.sql2.AndCondition;
import nl.vpro.jcr.criteria.query.sql2.Condition;
import nl.vpro.jcr.criteria.query.sql2.Field;
import nl.vpro.jcr.criteria.query.sql2.IsDescendantNode;
import nl.vpro.jcr.criteria.query.sql2.Order;
import nl.vpro.jcr.criteria.query.sql2.OrderDirection;

public class Select {
    String type = "nt:base";
    final AndCondition condition = new AndCondition(new Condition[0]);
    final List<Order> order = new ArrayList<Order>();
    final List<Column> columns = new ArrayList<Column>();

    public String toSql2() {
        StringBuilder builder = new StringBuilder("SELECT ");
        if (this.columns.isEmpty()) {
            this.columns.add(Column.ALL);
        }
        builder.append(this.columns.stream().map(Column::getSql2).map(s -> String.format(s, "a")).collect(Collectors.joining(",")));
        builder.append(" from ");
        builder.append("[").append(this.type).append("] as a");
        if (this.condition.hasClauses()) {
            int length = builder.length();
            if (this.condition.toSql2(builder)) {
                builder.insert(length, " WHERE ");
            }
        }
        if (!this.order.isEmpty()) {
            builder.append(" ORDER BY ");
            Iterator<Order> iterator = this.order.iterator();
            while (iterator.hasNext()) {
                iterator.next().toSql2(builder);
                if (!iterator.hasNext()) continue;
                builder.append(", ");
            }
        }
        return builder.toString();
    }

    public static Select from(AbstractCriteriaImpl criteria) {
        Select select = new Select();
        select.getColumns().clear();
        select.getColumns().addAll(criteria.getColumns());
        if (criteria.getBasePath() != null) {
            select.condition.clauses.add(new IsDescendantNode(criteria.getBasePath()));
        }
        if (criteria.getType() != null) {
            select.type = criteria.getType();
        }
        for (TranslatableCriteria.CriterionEntry e : criteria.getCriterionEntries()) {
            select.condition.clauses.add(e.getCriterion().toSQLCondition(criteria));
        }
        for (TranslatableCriteria.OrderEntry orderEntry : criteria.getOrderEntries()) {
            select.getOrder().add(Order.builder().direction(orderEntry.getOrder().isAscending() ? OrderDirection.ASC : OrderDirection.DESC).field(Field.of(orderEntry.getOrder().getNodeName())).build());
        }
        return select;
    }

    @Generated
    public Select() {
        this.columns.add(Column.ALL);
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public AndCondition getCondition() {
        return this.condition;
    }

    @Generated
    public List<Order> getOrder() {
        return this.order;
    }

    @Generated
    public List<Column> getColumns() {
        return this.columns;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Select)) {
            return false;
        }
        Select other = (Select)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        AndCondition this$condition = this.getCondition();
        AndCondition other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        List<Order> this$order = this.getOrder();
        List<Order> other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        List<Column> this$columns = this.getColumns();
        List<Column> other$columns = other.getColumns();
        return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Select;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        AndCondition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        List<Order> $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        List<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Select(type=" + this.getType() + ", condition=" + this.getCondition() + ", order=" + this.getOrder() + ", columns=" + this.getColumns() + ")";
    }
}

